/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.shynieke.georenouveau.client.model.GeOreGolemModel;
import com.shynieke.georenouveau.entity.GeOreGolem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class GeOreGolemRenderer
extends GeoEntityRenderer<GeOreGolem> {
    GeOreGolem golem;
    MultiBufferSource buffer;
    ResourceLocation text;

    public GeOreGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new GeOreGolemModel());
    }

    public RenderType getRenderType(GeOreGolem animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public void preRender(PoseStack poseStack, GeOreGolem animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        this.golem = animatable;
        this.buffer = bufferSource;
        this.text = this.getTextureLocation((Entity)animatable);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void renderRecursively(PoseStack stack, GeOreGolem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer bufferIn, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        if (bone.getName().equals("item")) {
            stack.pushPose();
            RenderUtil.translateToPivotPoint((PoseStack)stack, (GeoBone)bone);
            stack.translate(0.0, -0.1, 0.0);
            ItemStack itemstack = this.golem.getMainHandItem();
            Minecraft.getInstance().getItemRenderer().renderStatic(itemstack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, stack, this.buffer, animatable.level(), (int)this.golem.getOnPos().asLong());
            stack.popPose();
            bufferIn = this.buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.text));
        }
        super.renderRecursively(stack, (Entity)animatable, bone, renderType, bufferSource, bufferIn, isReRender, partialTick, packedLight, packedOverlay, color);
    }
}

