(function recipeRemovals() {
  const { MATERIALS, CRUSHING_RECIPES_TO_BECOME_GRINDING } = global.server;

  onEvent("recipes", (event) => {
    //Tech Reborn
    /** @type {Internal.RecipeFilter_[]} */
    const recipeRemovals = [
      // storage units
      { output: "techreborn:crude_storage_unit" },
      { output: "techreborn:basic_storage_unit" },
      { output: "techreborn:advanced_storage_unit" },
      { output: "techreborn:industrial_storage_unit" },
      { output: "techreborn:quantum_storage_unit" },
      // tanks units
      { output: "techreborn:basic_tank_unit" },
      { output: "techreborn:advanced_tank_unit" },
      { output: "techreborn:industrial_tank_unit" },
      { output: "techreborn:quantum_tank_unit" },
      //cables
      { output: "techreborn:gold_cable" },
      { output: "techreborn:copper_cable" },
      { output: "techreborn:tin_cable" },
      { output: "techreborn:hv_cable" },
      { output: "techreborn:glassfiber_cable" },
      { output: "techreborn:insulated_hv_cable" },
      { output: "techreborn:insulated_gold_cable" },
      { output: "techreborn:insulated_copper_cable" },
      { output: "techreborn:hv_transformer" },
      { output: "techreborn:nanosaber" },
      { output: "techreborn:lightning_rod" },
      { output: "techreborn:refined_iron_fence" },
      { output: "techreborn:chunk_loader" },
      { output: "techreborn:pyrite_dust" },
      { output: "ae2:spatial_anchor" },
      { output: "techreborn:carbon_fiber" },
      { output: "techreborn:scrap_box" },
      { output: "techreborn:industrial_electrolyzer" },
      { output: "techreborn:industrial_sawmill" },
      { output: "techreborn:vacuum_freezer" },
      { output: "techreborn:solid_canning_machine" },
      { output: "techreborn:greenhouse_controller" },
      { output: "techreborn:industrial_centrifuge" },
      { output: "techreborn:electric_furnace" },
      { output: "techreborn:distillation_tower" },
      { output: "techreborn:chemical_reactor" },
      { output: "techreborn:auto_crafting_table" },
      { output: "techreborn:alloy_smelter" },
      { output: "techreborn:extractor" },
      { output: "createendertransmission:chunk_loader" },
      { input: "techreborn:sponge_piece" },
      { output: "techreborn:sponge_piece" },
      { output: "techreborn:compressed_plantball" },
      { input: "techreborn:compressed_plantball", type: "techreborn:solid_canning_machine" },
      { output: "techreborn:plantball" },
      { output: "techreborn:grinder" },
      { output: "techreborn:scrapboxinator" },
      { output: "techreborn:recycler" },
      { output: "techreborn:block_breaker" },
      { output: "techreborn:wire_mill" },
      { output: "techreborn:compressor" },
      { output: "techreborn:synthetic_redstone_crystal" },
      { output: "techreborn:bronze_nugget" },
      { output: "techreborn:steel_ingot" },
      { output: "techreborn:steel_storage_block" },
      { output: "techreborn:steel_plate" },
      { output: "techreborn:bronze_storage_block" },
      { output: "techreborn:ender_pearl_dust" },
      { output: "techreborn:electronic_circuit" },
      { output: "techreborn:industrial_circuit" },
      { output: "techreborn:energy_flow_chip" },
      { output: "techreborn:lithium_ion_battery" },
      { output: "techreborn:rubber", type: "minecraft:smelting" },
      { output: "techreborn:basic_machine_frame" },
      { output: "techreborn:advanced_machine_frame" },
      { output: "techreborn:industrial_machine_frame" },
      { output: "techreborn:advanced_machine_casing" },
      { output: "techreborn:industrial_machine_casing" },
      { output: "techreborn:refined_iron_ingot" },
      { output: "techreborn:fusion_coil" },
      { output: "techreborn:carbon_mesh" },
      { output: "techreborn:data_storage_core" },
      { output: "techreborn:data_storage_chip" },
      { output: "techreborn:player_detector" },
      { output: "techreborn:quantum_helmet" },
      { output: "techreborn:quantum_chestplate" },
      { output: "techreborn:quantum_leggings" },
      { output: "techreborn:quantum_boots" },
      { output: "techreborn:copper_nugget" },
      { output: "techreborn:steel_plate" },
      { output: "techreborn:nanosaber" },
      { output: "yttr:promethium_speck" },
      { output: "yttr:promethium_lump" },
      { output: "yttr:promethium_glob" },
      { output: "yttr:reinforced_cleaver" },
      { type: "techreborn:scrapbox" },
      {
        type: "techreborn:grinder",
        input: "#techreborn:calcite_dust_material",
      },
      { type: "techreborn:grinder", input: "#c:ores" },
      { type: "techreborn:grinder", input: "#c:storage_blocks" },
      {
        type: "techreborn:grinder",
        input: "#techreborn:storage_blocks",
      },
      { type: "techreborn:grinder", output: "#c:concrete_powder" },
      { type: "techreborn:grinder", input: "#c:sandstone" },
      { type: "techreborn:grinder", input: "#minecraft:wool" },
      { type: "techreborn:grinder", input: "minecraft:gravel" },
      { type: "techreborn:grinder", input: "minecraft:obsidian" },
      {
        type: "techreborn:grinder",
        input: "minecraft:shroomlight",
      },
      { type: "techreborn:grinder", input: "minecraft:glowstone" },
      { type: "techreborn:grinder", input: "ad_astra:steel_block" },
      {
        type: "techreborn:grinder",
        input: "createastral:bronze_block",
      },
      { type: "techreborn:grinder", input: "minecraft:andesite" },
      { type: "techreborn:grinder", input: "minecraft:diorite" },
      { type: "techreborn:grinder", input: "minecraft:granite" },
      { type: "techreborn:grinder", input: "minecraft:netherrack" },
      {
        type: "techreborn:grinder",
        input: "minecraft:warped_nylium",
      },
      {
        type: "techreborn:grinder",
        input: "minecraft:crimson_nylium",
      },
      {
        type: "techreborn:grinder",
        output: "techreborn:saw_small_dust",
      },
      { type: "techreborn:grinder", output: "minecraft:sand" },
      { type: "techreborn:grinder", output: "minecraft:red_sand" },
      {
        type: "techreborn:grinder",
        input: "minecraft:pointed_dripstone",
      },
      {
        type: "minecraft:crafting_shaped",
        output: "techreborn:plantball",
      },
      {
        type: "minecraft:crafting_shapeless",
        output: "techreborn:plantball",
      },
      {
        type: "minecraft:crafting_shaped",
        output: "techreborn:nak_coolant_cell_60k",
      },
      { id: "techreborn:crafting_table/paper" },
      { output: "techreborn:block_placer" },
      { output: "minecraft:soul_sand", type: "techreborn:centrifuge" },
      { input: "techreborn:clay_dust", type: "techreborn:industrial_electrolyzer" },
      { id: "techreborn:solid_canning_machine/sulfur_cell" },
      { id: "techreborn:solid_canning_machine/bio_cell" },
      //Create
      { output: "create:sturdy_sheet" },
      { output: "create:track" },
      { output: "create:blaze_cake" },
      { output: "create:blaze_cake_base" },
      { output: "create:blaze_burner" },
      { output: "create:ochrum" },
      { output: "create:crimsite" },
      { input: "create:crimsite", output: "create:crushed_raw_iron" },
      { output: "create:limestone" },
      { output: "create:asurine" },
      { output: "create:veridium" },
      { output: "create:scoria" },
      { output: "create:scorchia" },
      { output: "create:crushed_raw_uranium" },
      { output: "create:electron_tube" },
      { output: "create:cogwheel", type: "minecraft:crafting_shaped" },
      { output: "create:large_cogwheel", type: "minecraft:crafting_shaped" },
      { output: "travelersbackpack:standard", type: "minecraft:crafting_shaped" },
      { output: "travelersbackpack:standard", type: "minecraft:crafting_shaped" },
      { output: "create:cogwheel" },
      { output: "create:large_cogwheel" },
      { output: "create:experience_block" },
      { output: "create:stockpile_switch" },
      { output: "create:copper_casing" },
      { output: "create:precision_mechanism" },
      { output: "create:railway_casing" },
      { output: "create:copper_backtank" },
      { output: "create:belt_connector" },
      { output: "create:brass_hand" },
      { output: "create:controls" },
      { output: "create:fluid_pipe" },
      { output: "create:fluid_tank" },
      { output: "create:goggles" },
      { output: "create:fluid_valve" },
      { output: "create:andesite_funnel" },
      { output: "create:andesite_tunnel" },
      { output: "create:brass_funnel" },
      { output: "create:brass_tunnel" },
      {
        output: "create:andesite_alloy",
        input: "minecraft:andesite",
      },
      {
        output: "create:experience_nugget",
        input: "create:experience_block",
      },
      { type: "create:milling", output: "minecraft:gunpowder" },
      { type: "create:milling", output: "minecraft:flint" },
      { type: "create:crushing", input: "minecraft:blaze_rod" },
      { type: "create:crushing", input: "minecraft:bone" },
      { type: "create:crushing", input: "minecraft:tuff" },
      { type: "create:milling", input: "minecraft:tuff" },
      { type: "create:milling", input: "minecraft:basalt" },
      { type: "create:milling", input: "minecraft:clay" },
      { type: "create:crushing", input: "minecraft:clay" },
      { type: "create:crushing", input: "minecraft:lapis_lazuli" },
      { type: "create:crushing", input: "minecraft:diamond" },
      { type: "create:crushing", input: "minecraft:diorite" },
      { type: "create:crushing", input: "minecraft:granite" },
      { type: "create:crushing", input: "minecraft:andesite" },
      { type: "create:crushing", input: "create:asurine" },
      { type: "create:crushing", input: "#create:stone_types/asurine" },
      { type: "create:crushing", input: "create:veridium" },
      { type: "create:crushing", input: "create:limestone" },
      { type: "create:crushing", input: "create:ochrum" },
      { type: "create:crushing", input: "create:scoria" },
      { type: "create:crushing", input: "create:scorchia" },
      { type: "create:crushing", input: "minecraft:cobblestone" },
      { type: "create:crushing", output: "create:cinder_flour" },
      { type: "create:mixing", output: "create:brass_ingot" },
      { type: "create:splashing", input: "minecraft:red_sand" },
      { type: "create:haunting", input: "minecraft:red_sand" },
      { type: "create:haunting", input: "minecraft:moss_block" },
      {
        type: "create:mixing",
        output: "tconstruct:rose_gold_ingot",
      },
      {
        type: "create:mixing",
        output: "tconstruct:slimesteel_ingot",
      },
      {
        type: "create:mixing",
        output: "tconstruct:pig_iron_ingot",
      },
      {
        type: "create:mixing",
        output: "tconstruct:manyullyn_ingot",
      },
      {
        type: "create:mixing",
        output: "tconstruct:hepatizon_ingot",
      },
      {
        type: "create:mixing",
        output: "tconstruct:queens_slime_ingot",
      },
      {
        output: "create:brass_casing",
        type: "create:item_application",
      },
      {
        type: "create:mixing",
        output: "create:dough",
      },
      { mod: "create", output: "minecraft:andesite" },
      // Create Deco
      { output: "createdeco:andesite_door" },
      { output: "createdeco:brass_door" },
      { output: "createdeco:copper_door" },
      { output: "createdeco:zinc_door" },
      { output: "createdeco:zinc_sheet" },
      //Create Additions
      { output: "createaddition:alternator" },
      { id: "createaddition:mixing/bioethanol" },
      { output: "createaddition:electric_motor" },
      { output: "createaddition:tesla_coil" },
      { output: "createaddition:biomass_pellet" },
      { output: "createaddition:biomass_pellet" },
      { output: "createaddition:biomass" },
      { output: "createaddition:bioethanol" },
      { type: "createaddition:liquid_burning" },
      // Create Railways
      { output: "railways:track_acacia" },
      { output: "railways:track_birch" },
      { output: "railways:track_crimson" },
      { output: "railways:track_dark_oak" },
      { output: "railways:track_jungle" },
      { output: "railways:track_oak" },
      { output: "railways:track_spruce" },
      { output: "railways:track_warped" },
      { output: "railways:track_blackstone" },
      { output: "railways:track_ender" },
      { output: "railways:track_tieless" },
      { output: "railways:track_phantom" },
      { output: "railways:track_monorail" },
      //Createdeco sheetmetal rebalance
      { output: "createdeco:copper_sheet_metal" },
      { output: "createdeco:andesite_sheet_metal" },
      { output: "createdeco:gold_sheet_metal" },
      { output: "createdeco:netherite_sheet_metal" },
      { output: "createdeco:brass_sheet_metal" },
      { output: "createdeco:cast_iron_sheet_metal" },
      { output: "createdeco:iron_sheet_metal" },
      { output: "createdeco:zinc_sheet_metal" },
      // Big cannon removals
      { output: "createbigcannons:nethersteel_nugget" },
      { output: "createbigcannons:nethersteel_ingot" },
      { output: "createbigcannons:nethersteel_block" },
      { output: "createbigcannons:molten_bronze", type: "createbigcannons:melting" },
      { output: "createbigcannons:molten_nethersteel", type: "createbigcannons:melting" },
      { output: "createbigcannons:molten_steel", type: "createbigcannons:melting" },
      { output: "createbigcannons:cast_iron_ingot", type: "create:compacting" },
      { output: "createbigcannons:cast_iron_nugget", type: "create:compacting" },
      // dustrial decor sheetmetal rework
      { output: "dustrial_decor:rusty_iron_door" },
      { output: "dustrial_decor:rusty_sheet_metal_treading" },
      // Ad Astra
      { output: "ad_astra:oxygen_distributor" },
      { output: "ad_astra:steel_ingot" },
      { output: "ad_astra:iron_plate" },
      { output: "ad_astra:coal_generator" },
      { output: "ad_astra:solar_panel" },
      { output: "ad_astra:fuel_refinery" },
      { output: "ad_astra:oxygen_loader" },
      { output: "ad_astra:energizer" },
      { output: "ad_astra:iron_rod" },
      { output: "ad_astra:nasa_workbench" },
      { output: "ad_astra:rocket_fin" },
      { output: "ad_astra:launch_pad" },
      { output: "ad_astra:space_boots" },
      { output: "ad_astra:desh_fluid_pipe" },
      { output: "ad_astra:ostrum_fluid_pipe" },
      { output: "ad_astra:wrench" },
      { output: "ad_astra:netherite_space_helmet" },
      { output: "ad_astra:netherite_space_suit" },
      { output: "ad_astra:netherite_space_pants" },
      { output: "ad_astra:netherite_space_boots" },
      { output: "ad_astra:jet_suit_helmet" },
      { output: "ad_astra:jet_suit" },
      { output: "ad_astra:jet_suit_pants" },
      { output: "ad_astra:jet_suit_boots" },
      { output: "ad_astra:tier_1_rocket" },
      { output: "ad_astra:tier_3_rocket" },
      { output: "ad_astra:tier_4_rocket" },
      { output: "ad_astra:desh_cable" },
      { output: "ad_astra:steel_cable" },
      { output: "ad_astra:compressor" },
      { output: "ad_astra:ostrum_ingot", type: "minecraft:smelting" },
      { output: "ad_astra:ostrum_ingot", type: "minecraft:blasting" },
      { output: "ad_astra:calorite_ingot", type: "minecraft:smelting" },
      { output: "ad_astra:calorite_ingot", type: "minecraft:blasting" },
      { output: "ad_astra:calorite_engine" },
      { output: "ad_astra:calorite_tank" },
      { output: "ad_astra:steel_tank" },
      { output: "ad_astra:rocket_nose_cone" },
      { output: "ad_astra:oxygen", type: "ad_astra:oxygen_conversion" },
      { output: "ad_astra:cryo_fuel", type: "ad_astra:cryo_fuel_conversion" },
      { type: "ad_astra:space_station" },
      // AE2
      { output: "ae2:fluix_dust" },
      { output: "ae2:molecular_assembler" },
      { output: "ae2:inscriber" },
      { type: "ae2:inscriber" },
      { output: "ae2:controller", type: "crafting_shaped" },
      // Tconstruct
      { output: "tconstruct:gold_bars" },
      { input: "tconstruct:gold_bars", output: "tconstruct:molten_gold" },
      { mod: "tconstruct", output: "minecraft:granite" },
      {
        type: "tconstruct:casting_basin",
        output: "minecraft:diorite",
      },
      { output: "tconstruct:copper_nugget" },
      { output: "tconstruct:smeltery_controller" },
      { output: "tconstruct:seared_melter" },
      { output: "tconstruct:scorched_alloyer" },
      { output: "tconstruct:earth_slime_sling" },
      { output: "tconstruct:sky_slime_sling" },
      { output: "tconstruct:ender_slime_sling" },
      { output: "tconstruct:seared_ingot_gauge" },
      { output: "tconstruct:seared_ingot_tank" },
      { output: "tconstruct:seared_fuel_gauge" },
      { output: "tconstruct:seared_fuel_tank" },
      { output: "tconstruct:seared_bricks" },
      { output: "tconstruct:scorched_ingot_gauge" },
      { output: "tconstruct:scorched_ingot_tank" },
      { output: "tconstruct:scorched_fuel_gauge" },
      { output: "tconstruct:scorched_fuel_tank" },
      { output: "tconstruct:scorched_bricks" },
      { output: "tconstruct:grout" },
      { type: "tconstruct:entity_melting" },
      { type: "tconstruct:alloy" },
      { output: "tconstruct:nether_grout" },
      { output: "tconstruct:efln_ball" },
      { output: "tconstruct:piggy_backpack" },
      { id: "tconstruct:smeltery/casting/clay/block" },
      { id: "tconstruct:smeltery/casting/metal/bronze/plate_gold_cast" },
      { id: "tconstruct:smeltery/casting/metal/steel/block" },
      { id: "tconstruct:smeltery/casting/metal/steel/ingot_gold_cast" },
      { id: "tconstruct:smeltery/casting/metal/steel/ingot_sand_cast" },
      { id: "tconstruct:smeltery/casting/metal/steel/nugget_gold_cast" },
      { id: "tconstruct:smeltery/casting/metal/steel/nugget_sand_cast" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/casting/metal/steel/plate_gold_cast" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/casting/metal/steel/plate_sand_cast" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/casting/metal/uranium/block" },
      { id: "tconstruct:smeltery/casting/scorched/brick_composite" },
      { id: "tconstruct:smeltery/casting/scorched/polished_from_magma" },
      { id: "tconstruct:smeltery/casting/scorched/stone_from_magma" },
      { id: "tconstruct:smeltery/casting/seared/cobble/wall" },
      { id: "tconstruct:smeltery/casting/seared/stone/slab" },
      { id: "tconstruct:smeltery/casting/seared/stone/stairs" },
      { id: "tconstruct:smeltery/casting/seared/brick_composite" },
      { id: "tconstruct:smeltery/casting/seared/chiseled" },
      { id: "tconstruct:smeltery/casting/seared/cracked" },
      { id: "tconstruct:smeltery/casting/seared/paver" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/casting/slime/ichor/block" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/casting/slime/ichor/congealed" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/casting/slime/slimeball" },
      { id: "tconstruct:smeltery/casting/soup/mushroom" },
      { id: "tconstruct:smeltery/entity_melting/blaze" },
      { id: "tconstruct:smeltery/entity_melting/heads/blaze" },
      { id: "tconstruct:smeltery/melting/fuel/blaze" },
      { id: "tconstruct:smeltery/melting/fuel/lava" },
      { id: "tconstruct:smeltery/melting/glass/block" },
      { id: "tconstruct:smeltery/melting/glass/bottle" },
      { id: "tconstruct:smeltery/melting/glass/pane" },
      { id: "tconstruct:smeltery/melting/glass/sand_cast" },
      { id: "tconstruct:smeltery/melting/glass/sand" },
      { id: "tconstruct:smeltery/melting/metal/bronze/plates" },
      { id: "tconstruct:smeltery/melting/metal/copper/wire" },
      { id: "tconstruct:smeltery/melting/metal/iron/chain" },
      { id: "tconstruct:smeltery/melting/metal/iron/raw_block" },
      { id: "tconstruct:smeltery/melting/metal/iron/raw" },
      { id: "tconstruct:smeltery/melting/metal/rose_gold/silky_cloth" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/melting/metal/silver/ore_singular" },
      { id: "tconstruct:smeltery/melting/metal/silver/raw_block" },
      { id: "tconstruct:smeltery/melting/metal/silver/raw" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/melting/metal/tin/ore_singular" },
      { id: "tconstruct:smeltery/melting/metal/tin/raw_block" },
      { id: "tconstruct:smeltery/melting/metal/tin/raw" },
      { id: "tconstruct:smeltery/melting/obsidian/beacon" },
      { id: "tconstruct:smeltery/melting/obsidian/block" },
      { id: "tconstruct:smeltery/melting/obsidian/chest" },
      { id: "tconstruct:smeltery/melting/obsidian/dust" },
      // @ts-expect-error Missing recipe?
      { id: "tconstruct:smeltery/melting/obsidian/foundry_controler" },
      { id: "tconstruct:smeltery/melting/obsidian/foundry_io" },
      { id: "tconstruct:smeltery/melting/obsidian/pane" },
      { id: "tconstruct:smeltery/melting/scorched/casting" },
      { id: "tconstruct:smeltery/melting/seared/grout" },
      { id: "tconstruct:smeltery/melting/slime/beetroot_soup" },
      { id: "tconstruct:smeltery/melting/slime/honey_block" },
      { id: "tconstruct:smeltery/melting/slime/mushroom_stew" },
      { output: "tconstruct:mushroom_stew" },
      { input: "tconstruct:mushroom_stew" },
      //horse armor
      { output: "minecraft:leather_horse_armor" },
      { type: "tconstruct:melting", input: "minecraft:iron_horse_armor" },
      { type: "tconstruct:melting", input: "minecraft:golden_horse_armor" },
      { type: "tconstruct:melting", input: "minecraft:diamond_horse_armor" },
      // reinfchest
      { output: "reinfchest:diamond_chest" },
      { output: "reinfchest:gold_chest" },
      { output: "reinfchest:iron_chest" },
      { output: "reinfchest:netherite_chest" },
      // Miscellaneous
      { output: "minecraft:shroomlight" },
      { output: "chipped:mechanist_workbench" },
      { output: "chipped:carpenters_table" },
      { output: "chipped:alchemy_bench" },
      { output: "passivepiglins:piglin_fortune" },
      { output: "passivepiglins:piglin_totem" },
      { output: "passivepiglins:piglin_coin" },
      { output: "campanion:sleeping_bag" },
      { output: "travelersbackpack:white_sleeping_bag" },
      { output: "travelersbackpack:orange_sleeping_bag" },
      { output: "travelersbackpack:magenta_sleeping_bag" },
      { output: "travelersbackpack:light_blue_sleeping_bag" },
      { output: "travelersbackpack:yellow_sleeping_bag" },
      { output: "travelersbackpack:lime_sleeping_bag" },
      { output: "travelersbackpack:pink_sleeping_bag" },
      { output: "travelersbackpack:gray_sleeping_bag" },
      { output: "travelersbackpack:light_gray_sleeping_bag" },
      { output: "travelersbackpack:cyan_sleeping_bag" },
      { output: "travelersbackpack:purple_sleeping_bag" },
      { output: "travelersbackpack:blue_sleeping_bag" },
      { output: "travelersbackpack:brown_sleeping_bag" },
      { output: "travelersbackpack:green_sleeping_bag" },
      { output: "travelersbackpack:red_sleeping_bag" },
      { output: "travelersbackpack:black_sleeping_bag" },
      { input: "travelersbackpack:backpack_tank", output: "travelersbackpack:standard" },
      { output: "travelersbackpack:hose" },
      { output: "travelersbackpack:hose_nozzle" },
      { output: "ad_astra:ostrum_engine" },
      { output: "dbe:server_rack" },
      { output: "dustrial_decor:cast_iron_billet" },
      { output: "mcdw:pick_diamond_pickaxe_var" },
      { output: "mcdw:sword_diamond_sword_var" },
      { output: "automobility:auto_mechanic_table" },
      { output: "automobility:automobile_assembler" },
      // @ts-expect-error Missing item?
      { type: "automobility:automobile_assembler" },
      { type: "ad_astra:fuel_conversion" },
      { output: "campanion:grappling_hook" },
      { output: "campanion:mre" },
      { output: "campanion:day_pack" },
      { output: "campanion:camping_pack" },
      { output: "campanion:wooden_spear" },
      { output: "campanion:stone_spear" },
      { output: "campanion:iron_spear" },
      { output: "campanion:diamond_spear" },
      { output: "campanion:netherite_spear" },
      { output: "campanion:golden_spear" },
      { output: "explorerscompass:explorerscompass" },
      { output: "phonos:radio_player_piano" },
      { output: "phonos:radio_jukebox" },
      { output: "phonos:redstone_chip" },
      { output: "create:andesite_alloy_block" },
      { input: "create:andesite_alloy_block" },
      { mod: "doodads" },
      { mod: "extended_drawers" },
      { output: "doodads:slimey_shoes" },
      { output: "dbe:steel_ingot" },
      { output: "dbe:copper_coil" },
      { output: "farmersdelight:cooking_pot" },
      { output: "immersive_aircraft:boiler" },
      { output: "immersive_aircraft:engine" },
      { output: "immersive_aircraft:nether_engine" },
      // @ts-expect-error Missing item?
      { output: "immersive_aircraft:large_propeller" },
      { output: "immersive_aircraft:airship" },
      { output: "immersive_aircraft:gyrodyne" },
      { output: "immersive_aircraft:biplane" },
      { output: "immersive_aircraft:quadrocopter" },
      { output: "immersive_aircraft:hull" },
      { output: "immersive_aircraft:propeller" },
      { output: "immersive_aircraft:sail" },
      { output: "catwalksinc:iron_rod" },
      { output: "polaroidcamera:camera" },
      { output: "computercraft:turtle_advanced" },
      { output: "computercraft:computer_advanced" },
      { output: "computercraft:pocket_computer_advanced" },
      { output: "buildinggadgets:gadget_building" },
      { output: "buildinggadgets:gadget_copy_paste" },
      { output: "buildinggadgets:gadget_destruction" },
      { output: "buildinggadgets:gadget_exchanging" },
      // Yttr
      { type: "yttr:centrifuging", input: "minecraft:coal" },
      { output: "yttr:chute" },
      { output: "yttr:rafter" },
      { output: "yttr:centrifuge" },
      { output: "yttr:dopper" },
      { output: "yttr:aware_hopper" },
      { output: "yttr:levitation_chamber" },
      { output: "yttr:skeletal_sorter_right_handed" },
      { output: "yttr:skeletal_sorter_left_handed" },
      { output: "yttr:rifle" },
      { output: "yttr:rifle_reinforced" },
      { output: "yttr:rifle_overclocked" },
      { output: "yttr:shifter" },
      { output: "yttr:projector" },
      { output: "yttr:spatula" },
      { output: "yttr:bedrock_smasher" },
      { output: "yttr:effector" },
      { output: "yttr:music_disc_papillons" },
      { output: "yttr:yttrium_dust" },
      { output: "yttr:magtank" },
      { output: "yttr:neodymium_disc" },
      { output: "yttr:yttrium_ingot", type: "minecraft:smelting" },
      { output: "yttr:yttrium_ingot", type: "minecraft:blasting" },
      { output: "yttr:xl_iron_ingot" },
      { output: "yttr:spatula" },
      { output: "yttr:giant_cobblestone" },
      { output: "yttr:armor_plating" },
      { output: "yttr:lamp", input: "yttr:glowing_gas" },
      { output: "yttr:quicksilver" },
      { output: "minecraft:slime_ball", type: "yttr:centrifuging" },
      { output: "yttr:lazor_emitter" },
      { input: "yttr:raw_gadolinite", type: "yttr:centrifuging" },
      { input: "minecraft:coal", type: "yttr:centrifuging" },
      // Minecraft
      { mod: "minecraft", output: "minecraft:granite" },
      { output: "minecraft:elytra" },
      {
        mod: "minecraft",
        input: "minecraft:diorite",
        output: "minecraft:andesite",
      },
      {
        mod: "minecraft",
        input: "minecraft:cobblestone",
        output: "minecraft:diorite",
      },
      { output: "minecraft:iron_sword" },
      { output: "minecraft:iron_pickaxe" },
      { output: "minecraft:iron_hoe" },
      { output: "minecraft:iron_shovel" },
      { output: "minecraft:iron_axe" },
      { output: "minecraft:iron_helmet" },
      { output: "minecraft:iron_chestplate" },
      { output: "minecraft:iron_leggings" },
      { output: "minecraft:iron_boots" },
      { output: "minecraft:diamond_helmet" },
      { output: "minecraft:diamond_chestplate" },
      { output: "minecraft:diamond_leggings" },
      { output: "minecraft:diamond_boots" },
      { output: "minecraft:diamond_sword" },
      { output: "minecraft:diamond_pickaxe" },
      { output: "minecraft:diamond_hoe" },
      { output: "minecraft:diamond_shovel" },
      { output: "minecraft:diamond_axe" },
      { output: "minecraft:wooden_sword" },
      { output: "minecraft:wooden_pickaxe" },
      { output: "minecraft:wooden_hoe" },
      { output: "minecraft:wooden_shovel" },
      { output: "minecraft:wooden_axe" },
      { output: "minecraft:stone_sword" },
      { output: "minecraft:stone_pickaxe" },
      { output: "minecraft:stone_hoe" },
      { output: "minecraft:stone_shovel" },
      { output: "minecraft:stone_axe" },
      { output: "minecraft:furnace" },
      { output: "minecraft:blast_furnace" },
      { output: "minecraft:bow" },
      { output: "minecraft:crossbow" },
      { output: "minecraft:arrow" },
      { output: "minecraft:shulker_shell" },
      { output: "minecraft:ender_eye" },
      { output: "minecraft:diamond_ore" },
      { output: "minecraft:emerald_ore" },
      { output: "minecraft:blackstone" },
      { output: "minecraft:gravel", input: "techreborn:granite_dust" },
      { output: "ae2:silicon" },
      { output: "blahaj:bread" },
      { id: "techreborn:centrifuge/redstone" }, // remove other version of centrifuging certus quartz
      { input: "minecraft:crying_obsidian" },
      {
        input: "minecraft:copper_block",
        type: "minecraft:stonecutting",
      },
      { output: "minecraft:dispenser" },
      { input: "tconstruct:copper_nugget", output: "minecraft:copper_ingot" },
      { id: "minecraft:cut_copper" },
      // xpcrystals
      { output: "xpcrystals:crystal_broth" },
      { output: "xpcrystals:sticky_crystal_pudding" },
      { output: "xpcrystals:soul_bucket" },
      { output: "xpcrystals:soul_compound" },
      { output: "xpcrystals:xp_boost_potion" },
      // vinery
      { output: "vinery:wine_rack_1" },
      { output: "vinery:grapevine_pot" },
      { output: "vinery:dough" },
      { id: "vinery:wood_fired_oven_cooking/toast" },
      // techreborn
      { output: "techreborn:sulfur" },
      { output: "techreborn:iridium_ingot" },
      { output: "techreborn:iridium_storage_block" },
      {
        input: "minecraft:soul_soil",
        output: "techreborn:coal_dust",
      },
      {
        input: "minecraft:soul_sand",
        output: "techreborn:coal_dust",
      },
      {
        input: "minecraft:glowstone_dust",
        output: "minecraft:redstone",
      },
      {
        input: "techreborn:netherrack_dust",
        output: "minecraft:redstone",
      },
      // extractinator
      { type: "extractinator:extractinating" },
      { output: "extractinator:extractinator" },
      // estrogen
      { type: "create:compacting", input: "minecraft:slime_ball" },
      { output: "estrogen:crystal_estrogen_pill" },
      { type: "create:mixing", output: "estrogen:balls" },
      { id: "estrogen:mixing/molten_amethyst" },
      // farmers delight
      { type: "farmersdelight:cutting", input: "minecraft:gravel" },
      { type: "farmersdelight:cutting", input: "farmersdelight:wild_rice" },
      { output: "farmersdelight:wheat_dough" },
      { id: "farmersdelight:create/filling/chocolate_pie" },
      // Hephaestus modifiers
      { id: "tconstruct:tools/modifiers/ability/double_jump" },
      { id: "tconstruct:tools/modifiers/ability/luck_level_1" },
      { id: "tconstruct:tools/modifiers/ability/luck_level_2" },
      { id: "tconstruct:tools/modifiers/ability/luck_level_3" },
      { id: "tconstruct:tools/modifiers/ability/reach" },
      { id: "tconstruct:tools/modifiers/ability/strength" },
      { id: "tconstruct:tools/modifiers/ability/tool_belt_1" },
      { id: "tconstruct:tools/modifiers/ability/tool_belt_2" },
      { id: "tconstruct:tools/modifiers/ability/tool_belt_3" },
      { id: "tconstruct:tools/modifiers/ability/tool_belt_4" },
      { id: "tconstruct:tools/modifiers/ability/tool_belt_5" },
      { id: "tconstruct:tools/modifiers/ability/tool_belt_6" },
      { id: "tconstruct:tools/modifiers/ability/unbreakable" },
      { id: "tconstruct:tools/modifiers/defense/turtle_shell" },
      { id: "tconstruct:tools/modifiers/slotless/draconic_from_head" },
      { id: "tconstruct:tools/modifiers/slotless/draconic_from_scales" },
      { id: "tconstruct:tools/modifiers/slotless/resurrected" },
      { id: "tconstruct:tools/modifiers/upgrade/killager_from_block" },
      { id: "tconstruct:tools/modifiers/upgrade/killager_from_block_unarmed" },
      { id: "tconstruct:tools/modifiers/upgrade/killager_from_dust" },
      { id: "tconstruct:tools/modifiers/upgrade/killager_from_dust_unarmed" },
      { id: "tconstruct:tools/modifiers/upgrade/leaping" },
      { id: "tconstruct:tools/modifiers/upgrade/piercing" },
    ];
    recipeRemovals.forEach((recipe) => {
      event.remove(recipe);
    });
    // YTTR Project Table
    event.remove({ output: "yttr:project_table" });
    /** @satisfies {string[]} */
    const colors = /** @type {const} */ ([
      "white",
      "orange",
      "magenta",
      "light_blue",
      "yellow",
      "lime",
      "pink",
      "gray",
      "light_gray",
      "cyan",
      "purple",
      "blue",
      "brown",
      "green",
      "red",
      "black",
    ]);
    colors.forEach((color) => event.remove({ output: `yttr:${color}_project_table` }));
    // Define the array of materials
    /** @satisfies {string[]} */
    const materials = /** @type {const} */ (["techreborn:bronze", "techreborn:silver"]);
    // Define a function to remove all recipes with a given material
    materials.forEach((material) => {
      event.remove({ output: `${material}_helmet` });
      event.remove({ output: `${material}_chestplate` });
      event.remove({ output: `${material}_leggings` });
      event.remove({ output: `${material}_boots` });
    });
    event.remove({ output: "techreborn:bronze_axe" });
    event.remove({ output: "techreborn:bronze_sword" });
    event.remove({ output: "techreborn:bronze_pickaxe" });
    event.remove({ output: "techreborn:bronze_hoe" });
    event.remove({ output: "techreborn:bronze_spade" }); // TR calls shovels "spades". 🤔
    /** @satisfies {string[]} */
    const metal = /** @type {const} */ ([
      "tungstensteel",
      "chrome",
      "titanium",
      "nickel",
      "refined_iron",
      "bronze",
      "aluminum",
      "tungsten",
      "platinum",
      "brass",
      "zinc",
      "nickel",
      "platinum",
    ]);
    metal.forEach((metal) => {
      event.remove({ output: `techreborn:${metal}_plate` });
      event.remove({ output: `techreborn:${metal}_ingot` });
      event.remove({ output: `techreborn:${metal}_storage_block` });
      event.remove({ output: `techreborn:${metal}_storage_block_stairs` });
      event.remove({ output: `techreborn:${metal}_storage_block_slab` });
      event.remove({ output: `techreborn:${metal}_storage_block_wall` });
      event.remove({ output: `techreborn:${metal}_nugget` });
    });
    /** @satisfies {string[]} */
    const metalsWithDusts = /** @type {const} */ ([
      "chrome",
      "titanium",
      "nickel",
      "bronze",
      "aluminum",
      "platinum",
      "brass",
      "zinc",
      "nickel",
      "platinum",
    ]);
    metalsWithDusts.forEach((metal) => {
      event.remove({ output: `techreborn:${metal}_dust` });
    });
    /** @satisfies {string[]} */
    const metalsWithSmallDusts = /** @type {const} */ ([
      "chrome",
      "titanium",
      "nickel",
      "tungsten",
      "platinum",
      "zinc",
      "nickel",
      "platinum",
    ]);
    metalsWithSmallDusts.forEach((dust) => {
      event.remove({ output: `techreborn:${dust}_small_dust` });
    });
    /**
     * Remove unused plate materials.
     * @satisfies {string[]}
     */
    const plates = /** @type {const} */ ([
      "iron",
      "copper",
      "gold",
      "advanced_alloy",
      "iridium_alloy",
      "iridium",
      "carbon",
      "coal",
      "emerald",
      "lapis",
      "lazurite",
      "obsidian",
      "redstone",
      "silicon",
    ]);
    plates.forEach((plate) => {
      event.remove({ output: `techreborn:${plate}_plate` });
    });
    /** @satisfies {{name: string, hasSmall: boolean}[]} */
    const dusts = /** @type {const} */ ([
      { name: "almandine", hasSmall: false },
      { name: "amethyst", hasSmall: false },
      { name: "andesite", hasSmall: true },
      { name: "andradite", hasSmall: false },
      { name: "ashes", hasSmall: true },
      { name: "basalt", hasSmall: true },
      { name: "bauxite", hasSmall: false },
      { name: "bronze", hasSmall: false },
      { name: "calcite", hasSmall: true },
      { name: "charcoal", hasSmall: true },
      { name: "cinnabar", hasSmall: false },
      { name: "clay", hasSmall: true },
      { name: "coal", hasSmall: true },
      { name: "dark_ashes", hasSmall: true },
      { name: "diamond", hasSmall: true },
      { name: "diorite", hasSmall: true },
      { name: "electrum", hasSmall: true },
      { name: "emerald", hasSmall: false },
      { name: "ender_eye", hasSmall: false },
      { name: "ender_pearl", hasSmall: false },
      { name: "endstone", hasSmall: false },
      { name: "flint", hasSmall: true },
      { name: "galena", hasSmall: true },
      { name: "granite", hasSmall: true },
      { name: "grossular", hasSmall: false },
      { name: "invar", hasSmall: false },
      { name: "lazurite", hasSmall: true },
      { name: "magnesium", hasSmall: false },
      { name: "manganese", hasSmall: false },
      { name: "marble", hasSmall: false },
      { name: "netherrack", hasSmall: true },
      { name: "nickel", hasSmall: false },
      { name: "obsidian", hasSmall: false },
      { name: "olivine", hasSmall: true },
      { name: "phosphorous", hasSmall: false },
      { name: "pyrite", hasSmall: false },
      { name: "pyrope", hasSmall: false },
      { name: "quartz", hasSmall: false },
      { name: "saltpeter", hasSmall: false },
      { name: "saw", hasSmall: true },
      { name: "sodalite", hasSmall: false },
      { name: "spessartine", hasSmall: false },
      { name: "sphalerite", hasSmall: false },
      { name: "steel", hasSmall: true },
      { name: "sulfur", hasSmall: false },
      { name: "uvarovite", hasSmall: false },
      { name: "glowstone", hasSmall: true },
      { name: "redstone", hasSmall: true },
      { name: "peridot", hasSmall: false },
      { name: "red_garnet", hasSmall: false },
      { name: "ruby", hasSmall: false },
      { name: "sapphire", hasSmall: false },
      { name: "yellow_garnet", hasSmall: false },
    ]);
    dusts.forEach((dust) => {
      if (dust.hasSmall) {
        event.remove({ output: `techreborn:${dust.name}_small_dust` });
      }
      if (dust.name != "glowstone" && dust.name != "redstone") event.remove({ output: `techreborn:${dust.name}_dust` });
    });
    MATERIALS.forEach((material) => {
      event.remove({ not: { mod: "tconstruct" }, output: material.plate });
    });
    for (let recipe of CRUSHING_RECIPES_TO_BECOME_GRINDING) {
      event.remove({ type: "create:crushing", input: recipe.input.item });
    }
  });
})();
