(function adAstraSpaceStationRecipe() {
  onEvent("recipes", (event) => {
    /**
     * @typedef StationIngredient
     * @property {Helper.ItemOrTag} ingredient
     * @property {number} count
     */

    /** @type {StationIngredient[]} */
    const stationIngredients = [
      {
        ingredient: { tag: "c:iron_plates" },
        count: 64,
      },
      {
        ingredient: { item: "techreborn:rubber" },
        count: 64,
      },
      {
        ingredient: { tag: "c:compressed_desh" },
        count: 32,
      },
      {
        ingredient: { tag: "c:glass" },
        count: 32,
      },
      {
        ingredient: { item: "create:sturdy_sheet" },
        count: 16,
      },
      {
        ingredient: { item: "create:integrated_circuit" },
        count: 8,
      },
      {
        ingredient: { item: "createastral:navigation_mechanism" },
        count: 1,
      },
      {
        ingredient: { item: "ad_astra:oxygen_distributor" },
        count: 1,
      },
    ];

    event.custom({
      type: "ad_astra:space_station",
      ingredients: stationIngredients,
    });
  });
})();
