/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.mixin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;

public class IntegratedMixinPlugin
implements IMixinConfigPlugin {
    private static final Map<String, String> CLASS_TO_MOD = new HashMap<String, String>();
    private static final Set<String> CONFIG_ACTIVATED = new HashSet<String>();

    public void onLoad(String mixinPackage) {
        PolymorphIntegrations.loadConfig();
        CONFIG_ACTIVATED.addAll(PolymorphIntegrations.getConfigActivated());
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        for (Map.Entry<String, String> entry : CLASS_TO_MOD.entrySet()) {
            if (!targetClassName.startsWith(entry.getKey())) continue;
            String modid = entry.getValue();
            return CONFIG_ACTIVATED.contains(modid) && FabricLoader.getInstance().isModLoaded(modid);
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        CLASS_TO_MOD.put("me.shedaniel.rei.", PolymorphIntegrations.Mod.REI.getId());
        CLASS_TO_MOD.put("appeng.", PolymorphIntegrations.Mod.APPLIED_ENERGISTICS_2.getId());
        CLASS_TO_MOD.put("com.tom.storagemod.", PolymorphIntegrations.Mod.TOMS_STORAGE.getId());
        CLASS_TO_MOD.put("tfar.fastbench.", PolymorphIntegrations.Mod.FASTBENCH.getId());
        CLASS_TO_MOD.put("com.biom4st3r.recipecache.", PolymorphIntegrations.Mod.RECIPECACHE.getId());
        CLASS_TO_MOD.put("me.shedaniel.istations.", PolymorphIntegrations.Mod.IMPROVEDSTATIONS.getId());
    }
}

