/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network;

import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4861;
import net.minecraft.server.MinecraftServer;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;
import top.theillusivec4.polymorph.common.network.PolymorphPackets;

public class PolymorphNetwork {
    public static void setup() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PolymorphPackets.PLAYER_SELECT, PolymorphNetwork::handlePlayerSelect);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PolymorphPackets.PERSISTENT_SELECT, PolymorphNetwork::handlePersistentSelect);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PolymorphPackets.STACK_SELECT, PolymorphNetwork::handleStackSelect);
    }

    private static void handlePlayerSelect(MinecraftServer pServer, class_3222 pPlayer, class_3244 pHandler, class_2540 pBuf, PacketSender pResponseSender) {
        class_2960 identifier = pBuf.method_10810();
        pServer.execute(() -> {
            class_1703 screenHandler = pPlayer.field_7512;
            pPlayer.field_6002.method_8433().method_8130(identifier).ifPresent(recipe -> {
                PolymorphApi.common().getRecipeData((class_1657)pPlayer).ifPresent(recipeData -> recipeData.selectRecipe((class_1860<?>)recipe));
                for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
                    if (!integration.selectRecipe(screenHandler, (class_1860<?>)recipe)) continue;
                    return;
                }
                screenHandler.method_7609((class_1263)pPlayer.method_31548());
                if (screenHandler instanceof class_4861) {
                    ((class_4861)screenHandler).method_24928();
                }
            });
        });
    }

    private static void handlePersistentSelect(MinecraftServer pServer, class_3222 pPlayer, class_3244 pHandler, class_2540 pBuf, PacketSender pResponseSender) {
        class_2960 identifier = pBuf.method_10810();
        pServer.execute(() -> {
            class_1937 world = pPlayer.method_5770();
            Optional maybeRecipe = world.method_8433().method_8130(identifier);
            maybeRecipe.ifPresent(recipe -> {
                class_1703 screenHandler = pPlayer.field_7512;
                PolymorphApi.common().getRecipeDataFromBlockEntity(screenHandler).ifPresent(recipeData -> {
                    recipeData.selectRecipe((class_1860<?>)recipe);
                    for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
                        if (!integration.selectRecipe((class_2586)recipeData.getOwner(), (class_1860<?>)recipe) && !integration.selectRecipe(screenHandler, (class_1860<?>)recipe)) continue;
                        return;
                    }
                });
            });
        });
    }

    private static void handleStackSelect(MinecraftServer pServer, class_3222 pPlayer, class_3244 pHandler, class_2540 pBuf, PacketSender pResponseSender) {
        class_2960 identifier = pBuf.method_10810();
        pServer.execute(() -> {
            class_1937 world = pPlayer.method_5770();
            Optional maybeRecipe = world.method_8433().method_8130(identifier);
            maybeRecipe.ifPresent(recipe -> {
                class_1703 screenHandler = pPlayer.field_7512;
                PolymorphApi.common().getRecipeDataFromBlockEntity(screenHandler).ifPresent(recipeData -> {
                    recipeData.selectRecipe((class_1860<?>)recipe);
                    for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
                        if (!integration.selectRecipe(screenHandler, (class_1860<?>)recipe)) continue;
                        return;
                    }
                });
            });
        });
    }
}

