/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;
import top.theillusivec4.polymorph.common.PolymorphMod;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.appliedenergistics2.AppliedEnergisticsModule;
import top.theillusivec4.polymorph.common.integration.camsbackpacks.CamsBackpacksModule;
import top.theillusivec4.polymorph.common.integration.fastbench.FastBenchModule;
import top.theillusivec4.polymorph.common.integration.fastfurnace.FastFurnaceModule;
import top.theillusivec4.polymorph.common.integration.ironfurnaces.IronFurnacesModule;
import top.theillusivec4.polymorph.common.integration.origins.OriginsModule;
import top.theillusivec4.polymorph.common.integration.recipecache.RecipeCacheModule;
import top.theillusivec4.polymorph.common.integration.toms_storage.TomsStorageModule;

public class PolymorphIntegrations {
    private static final Set<String> CONFIG_ACTIVATED = new HashSet<String>();
    private static final Map<String, Supplier<Supplier<AbstractCompatibilityModule>>> INTEGRATIONS = new HashMap<String, Supplier<Supplier<AbstractCompatibilityModule>>>();
    private static final Set<AbstractCompatibilityModule> ACTIVE_INTEGRATIONS = new HashSet<AbstractCompatibilityModule>();
    private static final Gson GSON;

    public static void loadConfig() {
        TreeMap<String, IntegrationConfig> defaultModConfigs = new TreeMap<String, IntegrationConfig>();
        for (Mod mod : Mod.values()) {
            defaultModConfigs.put(mod.getId(), new IntegrationConfig(mod.getId(), true));
        }
        IntegrationConfig[] defaults = defaultModConfigs.values().toArray(new IntegrationConfig[0]);
        IntegrationConfig[] configs = PolymorphIntegrations.fromJson((TypeToken<T[]>)TypeToken.get(IntegrationConfig[].class), new File(FabricLoader.getInstance().getConfigDir().toString(), "polymorph-integrations.json"), defaults);
        TreeMap<String, IntegrationConfig> currentModConfigs = new TreeMap<String, IntegrationConfig>((Map<String, IntegrationConfig>)defaultModConfigs);
        for (IntegrationConfig config : configs) {
            currentModConfigs.replace(config.id, config);
        }
        for (IntegrationConfig config : currentModConfigs.values()) {
            if (!config.enabled) continue;
            CONFIG_ACTIVATED.add(config.id);
        }
        PolymorphIntegrations.toJson((TypeToken<T[]>)TypeToken.get(IntegrationConfig[].class), new File(FabricLoader.getInstance().getConfigDir().toString(), "polymorph-integrations.json"), currentModConfigs.values().toArray(new IntegrationConfig[0]));
    }

    public static void init() {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        INTEGRATIONS.forEach((modid, supplier) -> {
            if (CONFIG_ACTIVATED.contains(modid) && fabricLoader.isModLoaded(modid)) {
                ACTIVE_INTEGRATIONS.add((AbstractCompatibilityModule)((Supplier)supplier.get()).get());
            }
        });
    }

    public static void setup() {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            integration.setup();
        }
    }

    public static void registerBlockEntities() {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            integration.registerBlockEntities();
        }
    }

    public static void clientSetup() {
        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
            integration.clientSetup();
        }
    }

    public static Set<AbstractCompatibilityModule> get() {
        return ImmutableSet.copyOf(ACTIVE_INTEGRATIONS);
    }

    public static Set<String> getConfigActivated() {
        return ImmutableSet.copyOf(CONFIG_ACTIVATED);
    }

    private static <T> T[] fromJson(TypeToken<T[]> token, File file, T[] defaults) {
        Object[] objectArray;
        if (!file.exists()) {
            PolymorphIntegrations.toJson(token, file, defaults);
            return defaults;
        }
        FileReader reader = new FileReader(file);
        try {
            objectArray = (Object[])GSON.fromJson((Reader)reader, token.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                PolymorphMod.LOGGER.error("Error reading config file!");
                return defaults;
            }
        }
        reader.close();
        return objectArray;
    }

    private static <T> void toJson(TypeToken<T[]> token, File file, T[] defaults) {
        if (!file.exists()) {
            try {
                FileUtils.forceMkdirParent((File)file);
                file.createNewFile();
            }
            catch (IOException e) {
                PolymorphMod.LOGGER.error("Error creating config file!");
                return;
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(PolymorphIntegrations.getJson(defaults, token));
        }
        catch (IOException e) {
            PolymorphMod.LOGGER.error("Error creating config file!");
        }
    }

    private static <T> String getJson(T[] elements, TypeToken<T[]> token) {
        return GSON.toJson(elements, token.getType());
    }

    static {
        INTEGRATIONS.put(Mod.FASTBENCH.getId(), () -> FastBenchModule::new);
        INTEGRATIONS.put(Mod.FASTFURNACE.getId(), () -> FastFurnaceModule::new);
        INTEGRATIONS.put(Mod.APPLIED_ENERGISTICS_2.getId(), () -> AppliedEnergisticsModule::new);
        INTEGRATIONS.put(Mod.IRON_FURNACES.getId(), () -> IronFurnacesModule::new);
        INTEGRATIONS.put(Mod.TOMS_STORAGE.getId(), () -> TomsStorageModule::new);
        INTEGRATIONS.put(Mod.RECIPECACHE.getId(), () -> RecipeCacheModule::new);
        INTEGRATIONS.put(Mod.ORIGINS.getId(), () -> OriginsModule::new);
        INTEGRATIONS.put(Mod.CAMMIES_WEARABLE_BACKPACKS.getId(), () -> CamsBackpacksModule::new);
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public static enum Mod {
        REI("roughlyenoughitems-runtime"),
        TOMS_STORAGE("toms_storage"),
        APPLIED_ENERGISTICS_2("ae2"),
        IRON_FURNACES("ironfurnaces"),
        FASTFURNACE("fastfurnace"),
        RECIPECACHE("recipecache"),
        IMPROVEDSTATIONS("improved-stations"),
        ORIGINS("origins"),
        CAMMIES_WEARABLE_BACKPACKS("camsbackpacks"),
        FASTBENCH("fastbench");

        private final String id;

        private Mod(String pId) {
            this.id = pId;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class IntegrationConfig {
        private final String id;
        private final boolean enabled;

        private IntegrationConfig(String id, boolean enabled) {
            this.id = id;
            this.enabled = enabled;
        }
    }
}

