/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.api.client.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1159;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import top.theillusivec4.polymorph.api.client.widget.OutputWidget;
import top.theillusivec4.polymorph.api.common.base.RecipePair;
import top.theillusivec4.polymorph.mixin.core.AccessorHandledScreen;
import top.theillusivec4.polymorph.mixin.core.AccessorScreen;

public class SelectionWidget
extends class_332
implements class_4068,
class_364 {
    private final Consumer<class_2960> onSelect;
    private final class_465<?> handledScreen;
    private final List<OutputWidget> outputWidgets = new ArrayList<OutputWidget>();
    private int xOffset;
    private int yOffset;
    private OutputWidget hoveredButton;
    private boolean active = false;
    private int x;
    private int y;
    private int lastX;
    private int lastY;
    public static final int DEFAULT_BACKGROUND_COLOR = -267386864;
    public static final int DEFAULT_BORDER_COLOR_START = 0x505000FF;
    public static final int DEFAULT_BORDER_COLOR_END = 1344798847;

    public SelectionWidget(int x, int y, int xOffset, int yOffset, Consumer<class_2960> onSelect, class_465<?> screen) {
        this.setPosition(x, y);
        this.onSelect = onSelect;
        this.handledScreen = screen;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    public void setOffsets(int pX, int pY) {
        this.xOffset = pX;
        this.yOffset = pY;
    }

    public void highlightButton(class_2960 pIdentifier) {
        this.outputWidgets.forEach(widget -> widget.setHighlighted(widget.getIdentifier().equals((Object)pIdentifier)));
    }

    private void updateButtonPositions() {
        int size = this.outputWidgets.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.outputWidgets.forEach(widget -> {
            widget.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<OutputWidget> getOutputWidgets() {
        return this.outputWidgets;
    }

    public void setRecipeList(Set<RecipePair> pRecipeList) {
        this.outputWidgets.clear();
        pRecipeList.forEach(data -> {
            if (!data.getOutput().method_7960()) {
                this.outputWidgets.add(new OutputWidget((RecipePair)data));
            }
        });
        this.updateButtonPositions();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void renderTooltip(class_4587 matrixStack, int mouseX, int mouseY) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null && this.hoveredButton != null) {
            this.renderTooltip(matrixStack, this.hoveredButton.getTooltipText(mc.field_1755), mouseX, mouseY);
        }
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float delta) {
        if (this.isActive()) {
            int x = ((AccessorHandledScreen)this.handledScreen).getX() + this.xOffset;
            int y = ((AccessorHandledScreen)this.handledScreen).getY() + this.yOffset;
            if (this.lastX != x || this.lastY != y) {
                this.setPosition(x, y);
                this.lastX = x;
                this.lastY = y;
            }
            this.hoveredButton = null;
            this.outputWidgets.forEach(button -> {
                button.method_25394(matrixStack, mouseX, mouseY, delta);
                if (button.field_22764 && button.method_25367()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(matrixStack, mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isActive()) {
            for (OutputWidget widget : this.outputWidgets) {
                if (!widget.method_25402(mouseX, mouseY, button)) continue;
                this.onSelect.accept(widget.getIdentifier());
                return true;
            }
        }
        return false;
    }

    public void renderTooltip(class_4587 matrices, List<class_2561> textLines, int mouseX, int mouseY) {
        SelectionWidget.drawHoveringText(matrices, textLines, mouseX, mouseY, this.handledScreen.field_22789, this.handledScreen.field_22790, -1, -267386864, 0x505000FF, 1344798847, ((AccessorScreen)this.handledScreen).getTextRenderer());
    }

    public static void drawHoveringText(class_4587 mStack, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font) {
        if (!textLines.isEmpty()) {
            int n;
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (class_5348 class_53482 : textLines) {
                int textLineWidth = font.method_27525(class_53482);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends class_5348> wrappedTextLines = new ArrayList<class_5348>();
                for (int i = 0; i < textLines.size(); ++i) {
                    class_5348 textLine = textLines.get(i);
                    List wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (class_5348 line : wrappedLine) {
                        int lineWidth = font.method_27525(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((class_5348)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 900;
            mStack.method_22903();
            class_1159 mat = mStack.method_23760().method_23761();
            SelectionWidget.drawGradientRect(mat, 900, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
            SelectionWidget.drawGradientRect(mat, 900, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
            SelectionWidget.drawGradientRect(mat, 900, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            SelectionWidget.drawGradientRect(mat, 900, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            SelectionWidget.drawGradientRect(mat, 900, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            SelectionWidget.drawGradientRect(mat, 900, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            SelectionWidget.drawGradientRect(mat, 900, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            SelectionWidget.drawGradientRect(mat, 900, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
            SelectionWidget.drawGradientRect(mat, 900, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
            class_4597.class_4598 renderType = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            mStack.method_22904(0.0, 0.0, 900.0);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                class_5348 line;
                line = textLines.get(lineNumber);
                if (line != null) {
                    font.method_22942(class_2477.method_10517().method_30934(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (class_4597)renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.method_22993();
            mStack.method_22909();
            RenderSystem.enableDepthTest();
        }
    }

    public static void drawGradientRect(class_1159 mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(mat, (float)right, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(mat, (float)left, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha).method_1344();
        buffer.method_22918(mat, (float)left, (float)bottom, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        buffer.method_22918(mat, (float)right, (float)bottom, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }
}

