/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.hooks.ticking.TickHandler;
import appeng.items.parts.PartModels;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public class MEP2PTunnelPart
extends P2PTunnelPart<MEP2PTunnelPart>
implements IGridTickable {
    private static final P2PModels MODELS = new P2PModels(AppEng.makeId("part/p2p/p2p_tunnel_me"));
    private ConnectionUpdate pendingUpdate = ConnectionUpdate.NONE;
    private final Map<MEP2PTunnelPart, IGridConnection> connections = new IdentityHashMap<MEP2PTunnelPart, IGridConnection>();
    private final IManagedGridNode outerNode = GridHelper.createManagedNode(this, AEBasePart.NodeListener.INSTANCE).setTagName("outer").setInWorldNode(true).setFlags(GridFlags.DENSE_CAPACITY, GridFlags.CANNOT_CARRY_COMPRESSED);

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public MEP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.COMPRESSED_CHANNEL).addService(IGridTickable.class, this);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public void readFromNBT(class_2487 extra) {
        super.readFromNBT(extra);
        this.outerNode.loadFromNBT(extra);
    }

    @Override
    public void writeToNBT(class_2487 extra) {
        super.writeToNBT(extra);
        this.outerNode.saveToNBT(extra);
    }

    @Override
    public void onTunnelNetworkChange() {
        super.onTunnelNetworkChange();
        if (!this.isOutput() || !this.connections.isEmpty()) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
    }

    @Override
    public AECableType getExternalCableConnectionType() {
        return AECableType.DENSE_SMART;
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerNode.destroy();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerNode.create(this.getLevel(), this.getBlockEntity().method_11016());
    }

    @Override
    public void setPartHostInfo(class_2350 side, IPartHost host, class_2586 blockEntity) {
        super.setPartHostInfo(side, host, blockEntity);
        this.outerNode.setExposedOnSides(EnumSet.of(side));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerNode.getNode();
    }

    @Override
    public void onPlacement(class_1657 player) {
        super.onPlacement(player);
        this.outerNode.setOwningPlayer(player);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.METunnel, true, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.pendingUpdate = !node.isOnline() ? ConnectionUpdate.DISCONNECT : ConnectionUpdate.CONNECT;
        TickHandler.instance().addCallable((class_1936)this.getLevel(), this::updateConnections);
        return TickRateModulation.SLEEP;
    }

    private void updateConnections() {
        ConnectionUpdate operation = this.pendingUpdate;
        this.pendingUpdate = ConnectionUpdate.NONE;
        IGrid mainGrid = this.getMainNode().getGrid();
        if (this.isOutput()) {
            operation = ConnectionUpdate.DISCONNECT;
        } else if (mainGrid == null) {
            operation = ConnectionUpdate.DISCONNECT;
        }
        if (operation == ConnectionUpdate.DISCONNECT) {
            for (IGridConnection cw : this.connections.values()) {
                cw.destroy();
            }
            this.connections.clear();
        } else if (operation == ConnectionUpdate.CONNECT) {
            IGridConnection connection;
            List outputs = this.getOutputs();
            Iterator<Map.Entry<MEP2PTunnelPart, IGridConnection>> it = this.connections.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MEP2PTunnelPart, IGridConnection> entry = it.next();
                MEP2PTunnelPart output = entry.getKey();
                connection = entry.getValue();
                if (output.getMainNode().getGrid() == mainGrid && output.getMainNode().isOnline() && outputs.contains(output)) continue;
                connection.destroy();
                it.remove();
            }
            for (MEP2PTunnelPart output : outputs) {
                if (!output.getMainNode().isOnline() || this.connections.containsKey(output)) continue;
                try {
                    connection = GridHelper.createGridConnection(this.getExternalFacingNode(), output.getExternalFacingNode());
                    this.connections.put(output, connection);
                }
                catch (FailedConnectionException e) {
                    class_2586 start = this.getBlockEntity();
                    class_2586 end = output.getBlockEntity();
                    AELog.debug(e);
                    AELog.warn("Failed to establish a ME P2P Tunnel between the tunnels at [x=%d, y=%d, z=%d] and [x=%d, y=%d, z=%d]: %s", start.method_11016().method_10263(), start.method_11016().method_10264(), start.method_11016().method_10260(), end.method_11016().method_10263(), end.method_11016().method_10264(), end.method_11016().method_10260(), e);
                }
            }
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private static enum ConnectionUpdate {
        NONE,
        DISCONNECT,
        CONNECT;

    }
}

