/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.util.AECableType;
import appeng.items.parts.ColoredPartItem;
import appeng.parts.networking.CablePart;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public abstract class DenseCablePart
extends CablePart {
    public DenseCablePart(ColoredPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(GridFlags.DENSE_CAPACITY, GridFlags.PREFERRED);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.DENSE_CABLE;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.updateConnections();
        boolean noLadder = !bch.isBBCollision();
        double min = noLadder ? 3.0 : 4.9;
        double max = noLadder ? 13.0 : 11.1;
        bch.addBox(min, min, min, max, max, max);
        block16: for (class_2350 of : this.getConnections()) {
            if (this.isDense(of)) {
                switch (of) {
                    case field_11033: {
                        bch.addBox(min, 0.0, min, max, min, max);
                        continue block16;
                    }
                    case field_11034: {
                        bch.addBox(max, min, min, 16.0, max, max);
                        continue block16;
                    }
                    case field_11043: {
                        bch.addBox(min, min, 0.0, max, max, min);
                        continue block16;
                    }
                    case field_11035: {
                        bch.addBox(min, min, max, max, max, 16.0);
                        continue block16;
                    }
                    case field_11036: {
                        bch.addBox(min, max, min, max, 16.0, max);
                        continue block16;
                    }
                    case field_11039: {
                        bch.addBox(0.0, min, min, min, max, max);
                        continue block16;
                    }
                }
                continue;
            }
            switch (of) {
                case field_11033: {
                    bch.addBox(5.0, 0.0, 5.0, 11.0, 5.0, 11.0);
                    break;
                }
                case field_11034: {
                    bch.addBox(11.0, 5.0, 5.0, 16.0, 11.0, 11.0);
                    break;
                }
                case field_11043: {
                    bch.addBox(5.0, 5.0, 0.0, 11.0, 11.0, 5.0);
                    break;
                }
                case field_11035: {
                    bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 16.0);
                    break;
                }
                case field_11036: {
                    bch.addBox(5.0, 11.0, 5.0, 11.0, 16.0, 11.0);
                    break;
                }
                case field_11039: {
                    bch.addBox(0.0, 5.0, 5.0, 5.0, 11.0, 11.0);
                    break;
                }
            }
        }
    }

    private boolean isDense(class_2350 of) {
        class_2338 adjacentPos = this.getBlockEntity().method_11016().method_10093(of);
        if (!this.getLevel().method_22340(adjacentPos)) {
            return false;
        }
        IInWorldGridNodeHost adjacentHost = GridHelper.getNodeHost((class_1936)this.getBlockEntity().method_10997(), adjacentPos);
        if (adjacentHost != null) {
            AECableType t = adjacentHost.getCableConnectionType(of.method_10153());
            return t.isDense();
        }
        return false;
    }
}

