/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PickupSink;
import appeng.api.behaviors.PickupStrategy;
import appeng.api.config.Actionable;
import appeng.api.ids.AETags;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.AppEng;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.helpers.FluidContainerHelper;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FluidPickupStrategy
implements PickupStrategy {
    private final class_3218 level;
    private final class_2338 pos;
    private final class_2350 side;
    private long lastEffect;

    public FluidPickupStrategy(class_3218 level, class_2338 pos, class_2350 side, class_2586 host, Map<?, ?> enchantments) {
        this.level = level;
        this.pos = pos;
        this.side = side;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean canPickUpEntity(class_1297 entity) {
        return false;
    }

    @Override
    public boolean pickUpEntity(IEnergySource energySource, PickupSink sink, class_1297 entity) {
        return false;
    }

    @Override
    public PickupStrategy.Result tryPickup(IEnergySource energySource, PickupSink sink) {
        class_2680 blockstate = this.level.method_8320(this.pos);
        class_2248 class_22482 = blockstate.method_26204();
        if (class_22482 instanceof class_2263) {
            class_2263 bucketPickup = (class_2263)class_22482;
            class_3610 fluidState = blockstate.method_26227();
            class_3611 fluid = fluidState.method_15772();
            if (this.isFluidBlacklisted(fluid)) {
                return PickupStrategy.Result.CANT_PICKUP;
            }
            if (fluid != class_3612.field_15906 && fluidState.method_15771()) {
                AEFluidKey what = AEFluidKey.of(fluid);
                if (this.storeFluid(sink, what, 81000L, false)) {
                    AEKey aEKey;
                    class_1799 fluidContainer = bucketPickup.method_9700((class_1936)this.level, this.pos, blockstate);
                    GenericStack pickedUpStack = FluidContainerHelper.getContainedStack(fluidContainer);
                    if (pickedUpStack != null && (aEKey = pickedUpStack.what()) instanceof AEFluidKey) {
                        AEFluidKey fluidKey = (AEFluidKey)aEKey;
                        this.storeFluid(sink, fluidKey, pickedUpStack.amount(), true);
                    }
                    if (!this.throttleEffect()) {
                        AppEng.instance().sendToAllNearExcept(null, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), 64.0, (class_1937)this.level, new BlockTransitionEffectPacket(this.pos, blockstate, this.side, BlockTransitionEffectPacket.SoundMode.FLUID));
                    }
                    return PickupStrategy.Result.PICKED_UP;
                }
                return PickupStrategy.Result.CANT_STORE;
            }
        }
        return PickupStrategy.Result.CANT_PICKUP;
    }

    private boolean storeFluid(PickupSink sink, AEFluidKey what, long amount, boolean modulate) {
        return sink.insert(what, amount, modulate ? Actionable.MODULATE : Actionable.SIMULATE) >= amount;
    }

    private boolean isFluidBlacklisted(class_3611 fluid) {
        return fluid.method_40178().method_40220(AETags.ANNIHILATION_PLANE_FLUID_BLACKLIST);
    }

    private boolean throttleEffect() {
        long now = System.currentTimeMillis();
        if (now < this.lastEffect + 250L) {
            return true;
        }
        this.lastEffect = now;
        return false;
    }
}

