/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ITerminalHost;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfirmAutoCraftPacket;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.InaccessibleSlot;
import appeng.util.inv.AppEngInternalInventory;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class CraftAmountMenu
extends AEBaseMenu
implements ISubMenu {
    public static final class_3917<CraftAmountMenu> TYPE = MenuTypeBuilder.create(CraftAmountMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftamount");
    private final AppEngSlot craftingItem;
    private AEKey whatToCraft;
    private final ITerminalHost host;

    public CraftAmountMenu(int id, class_1661 ip, ITerminalHost host) {
        super(TYPE, id, ip, host);
        this.host = host;
        this.craftingItem = new InaccessibleSlot(new AppEngInternalInventory(1), 0);
        this.craftingItem.setHideAmount(true);
        this.addSlot(this.craftingItem, SlotSemantics.MACHINE_OUTPUT);
    }

    @Override
    public ITerminalHost getHost() {
        return this.host;
    }

    public static void open(class_3222 player, MenuLocator locator, AEKey whatToCraft, int initialAmount) {
        MenuOpener.open(TYPE, (class_1657)player, locator);
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof CraftAmountMenu) {
            CraftAmountMenu cca = (CraftAmountMenu)class_17032;
            cca.setWhatToCraft(whatToCraft, initialAmount);
            cca.method_7623();
        }
    }

    @Override
    public void method_7623() {
        super.method_7623();
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    public class_1937 getLevel() {
        return this.getPlayerInventory().field_7546.field_6002;
    }

    private void setWhatToCraft(AEKey whatToCraft, int initialAmount) {
        this.whatToCraft = Objects.requireNonNull(whatToCraft, "whatToCraft");
        this.craftingItem.method_7673(GenericStack.wrapInItemStack(whatToCraft, initialAmount));
    }

    public void confirm(int amount, boolean autoStart) {
        if (!this.isServerSide()) {
            NetworkHandler.instance().sendToServer(new ConfirmAutoCraftPacket(amount, autoStart));
            return;
        }
        if (this.whatToCraft == null) {
            return;
        }
        MenuLocator locator = this.getLocator();
        if (locator != null) {
            class_1657 player = this.getPlayerInventory().field_7546;
            MenuOpener.open(CraftConfirmMenu.TYPE, player, locator);
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof CraftConfirmMenu) {
                CraftConfirmMenu ccc = (CraftConfirmMenu)class_17032;
                ccc.setAutoStart(autoStart);
                ccc.planJob(this.whatToCraft, amount, CalculationStrategy.REPORT_MISSING_ITEMS);
                this.method_7623();
            }
        }
    }

    @Nullable
    public GenericStack getWhatToCraft() {
        return GenericStack.unwrapItemStack(this.craftingItem.method_7677());
    }
}

