/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.networking.pathing.IPathingService;
import appeng.api.parts.IPartHost;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.networking.ControllerBlockEntity;
import appeng.hooks.AEToolItem;
import appeng.hooks.ticking.TickHandler;
import appeng.items.AEBaseItem;
import appeng.me.Grid;
import appeng.me.GridNode;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.service.TickManagerService;
import appeng.parts.networking.CablePart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.google.common.collect.Iterables;
import com.google.common.math.StatsAccumulator;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;

public class DebugCardItem
extends AEBaseItem
implements AEToolItem {
    public DebugCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        if (InteractionUtil.isInAlternateUseMode(player) && !level.field_9236) {
            int grids = 0;
            StatsAccumulator stats = new StatsAccumulator();
            for (Grid g : TickHandler.instance().getGridList()) {
                ++grids;
                stats.add((double)g.size());
            }
            this.divider(player);
            this.outputMessage((class_1297)player, "Grids", class_124.field_1067);
            this.outputSecondaryMessage((class_1297)player, "Grids", Integer.toString(grids));
            if (stats.count() > 0L) {
                this.outputSecondaryMessage((class_1297)player, "Total Nodes", "" + (long)stats.sum());
                this.outputSecondaryMessage((class_1297)player, "Mean Nodes", "" + (long)stats.mean());
                this.outputSecondaryMessage((class_1297)player, "Max Nodes", "" + (long)stats.max());
            }
            this.divider(player);
            this.outputMessage((class_1297)player, "Ticking", class_124.field_1067);
            this.outputSecondaryMessage((class_1297)player, "Current Tick: ", Long.toString(TickHandler.instance().getCurrentTick()));
            for (class_2561 line : TickHandler.instance().getBlockEntityReport()) {
                player.method_9203(line, class_156.field_25140);
            }
        }
        return class_1271.method_29237((Object)player.method_5998(usedHand), (boolean)level.field_9236);
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        Object center;
        if (context.method_8045().method_8608()) {
            return class_1269.field_5811;
        }
        class_1657 player = context.method_8036();
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        if (player == null || InteractionUtil.isInAlternateUseMode(player)) {
            return class_1269.field_5811;
        }
        IInWorldGridNodeHost gh = GridHelper.getNodeHost((class_1936)level, pos);
        if (gh != null) {
            this.divider(player);
            GridNode node = (GridNode)gh.getGridNode(side);
            if (node == null && gh instanceof IGridConnectedBlockEntity) {
                IGridConnectedBlockEntity gridConnectedBlockEntity = (IGridConnectedBlockEntity)((Object)gh);
                node = (GridNode)gridConnectedBlockEntity.getMainNode().getNode();
                this.outputMessage((class_1297)player, "Main node of IGridConnectedBlockEntity");
            }
            if (node != null) {
                Object object;
                this.outputMessage((class_1297)player, "-- Grid Details");
                Grid g = node.getInternalGrid();
                center = g.getPivot();
                this.outputPrimaryMessage((class_1297)player, "Grid Powered", String.valueOf(g.getEnergyService().isNetworkPowered()));
                this.outputPrimaryMessage((class_1297)player, "Grid Booted", String.valueOf(!g.getPathingService().isNetworkBooting()));
                this.outputPrimaryMessage((class_1297)player, "Nodes in grid", String.valueOf(Iterables.size((Iterable)g.getNodes())));
                this.outputSecondaryMessage((class_1297)player, "Grid Pivot Node", String.valueOf(center));
                TickManagerService tmc = (TickManagerService)g.getTickManager();
                for (Class<?> c : g.getMachineClasses()) {
                    int o = 0;
                    long totalAverageTime = 0L;
                    long singleMaximumTime = 0L;
                    for (IGridNode oj : g.getMachineNodes(c)) {
                        ++o;
                        totalAverageTime += tmc.getAverageTime(oj);
                        singleMaximumTime = Math.max(singleMaximumTime, tmc.getMaximumTime(oj));
                    }
                    String message = "#: " + o;
                    if (totalAverageTime > 0L) {
                        message = message + "; average: " + Platform.formatTimeMeasurement(totalAverageTime);
                    }
                    if (singleMaximumTime > 0L) {
                        message = message + "; max: " + Platform.formatTimeMeasurement(singleMaximumTime);
                    }
                    this.outputSecondaryMessage((class_1297)player, c.getSimpleName(), message);
                }
                this.outputMessage((class_1297)player, "-- Node Details");
                this.outputPrimaryMessage((class_1297)player, "This Node", String.valueOf(node));
                this.outputPrimaryMessage((class_1297)player, "This Node Active", String.valueOf(node.isActive()));
                this.outputSecondaryMessage((class_1297)player, "Node exposed on side", side.method_10151());
                IPathingService pg = g.getPathingService();
                if (pg.getControllerState() == ControllerState.CONTROLLER_ONLINE) {
                    HashSet<IGridNode> next = new HashSet<IGridNode>();
                    next.add(node);
                    int maxLength = 10000;
                    int length = 0;
                    block2: while (!next.isEmpty()) {
                        HashSet<IGridNode> current = next;
                        next = new HashSet();
                        for (IGridNode n : current) {
                            if (n.getOwner() instanceof ControllerBlockEntity) break block2;
                            for (IGridConnection c : n.getConnections()) {
                                next.add(c.getOtherSide(n));
                            }
                        }
                        if (++length <= 10000) continue;
                        break;
                    }
                    this.outputSecondaryMessage((class_1297)player, "Cable Distance", Integer.toString(length));
                }
                if ((object = center.getOwner()) instanceof P2PTunnelPart) {
                    P2PTunnelPart tunnelPart = (P2PTunnelPart)object;
                    this.outputSecondaryMessage((class_1297)player, "Freq", Integer.toString(tunnelPart.getFrequency()));
                }
            } else {
                this.outputMessage((class_1297)player, "No Node Available.");
            }
        } else {
            this.outputMessage((class_1297)player, "Not Networked Block");
        }
        class_2586 te = level.method_8321(pos);
        if (te instanceof IPartHost) {
            IPartHost partHost = (IPartHost)te;
            this.outputMessage((class_1297)player, "-- CableBus Details");
            this.outputSecondaryMessage((class_1297)player, "In World", Boolean.toString(partHost.isInWorld()));
            this.outputSecondaryMessage((class_1297)player, "Has Redstone", Boolean.toString(partHost.hasRedstone()));
            center = partHost.getPart(null);
            partHost.markForUpdate();
            if (center != null) {
                GridNode n = (GridNode)center.getGridNode();
                this.outputSecondaryMessage((class_1297)player, "Node Channels", Integer.toString(n.usedChannels()));
                for (Map.Entry<class_2350, IGridConnection> entry : n.getInWorldConnections().entrySet()) {
                    this.outputSecondaryMessage((class_1297)player, "Channels " + entry.getKey().method_10151(), Integer.toString(entry.getValue().getUsedChannels()));
                }
            }
            if (center instanceof CablePart) {
                CablePart cablePart = (CablePart)center;
                class_2585 msg = new class_2585("");
                for (class_2350 v : class_2350.values()) {
                    msg.method_10852((class_2561)new class_2585(v.name().substring(0, 1)).method_27692(cablePart.isConnected(v) ? class_124.field_1060 : class_124.field_1063));
                }
                player.method_9203((class_2561)new class_2585("Connected Sides: ").method_27692(class_124.field_1080).method_10852((class_2561)msg), class_156.field_25140);
            }
        }
        if (te instanceof IAEPowerStorage) {
            IGridNode node;
            IAEPowerStorage ps = (IAEPowerStorage)te;
            this.outputMessage((class_1297)player, "-- EnergyStorage Details");
            this.outputSecondaryMessage((class_1297)player, "Energy", ps.getAECurrentPower() + " / " + ps.getAEMaxPower());
            if (gh != null && (node = gh.getGridNode(side)) != null) {
                IEnergyService eg = node.getGrid().getEnergyService();
                this.outputSecondaryMessage((class_1297)player, "GridEnergy", eg.getStoredPower() + " : " + eg.getEnergyDemand(Double.MAX_VALUE));
            }
        }
        if (te instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity be = (AEBaseBlockEntity)te;
            this.outputMessage((class_1297)player, "-- Delayed Init Details");
            this.outputSecondaryMessage((class_1297)player, "QueuedForReady", "" + be.getQueuedForReady());
            this.outputSecondaryMessage((class_1297)player, "ReadyInvoked", "" + be.getReadyInvoked());
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private void divider(class_1657 player) {
        this.outputMessage((class_1297)player, "---------------------------------------------", class_124.field_1067, class_124.field_1064);
    }

    private void outputMessage(class_1297 player, String string, class_124 ... chatFormattings) {
        player.method_9203((class_2561)new class_2585(string).method_27695(chatFormattings), class_156.field_25140);
    }

    private void outputMessage(class_1297 player, String string) {
        player.method_9203((class_2561)new class_2585(string), class_156.field_25140);
    }

    private void outputPrimaryMessage(class_1297 player, String label, String value) {
        this.outputLabeledMessage(player, label, value, class_124.field_1067, class_124.field_1076);
    }

    private void outputSecondaryMessage(class_1297 player, String label, String value) {
        this.outputLabeledMessage(player, label, value, class_124.field_1080);
    }

    private void outputLabeledMessage(class_1297 player, String label, String value, class_124 ... chatFormattings) {
        player.method_9203((class_2561)new class_2585("").method_10852((class_2561)new class_2585(label + ": ").method_27695(chatFormattings)).method_27693(value), class_156.field_25140);
    }
}

