/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.localization;

import appeng.api.config.PowerUnits;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEEntities;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.InGameTooltip;
import appeng.core.localization.ItemModText;
import appeng.core.localization.LocalizationEnum;
import appeng.core.localization.PlayerMessages;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.integration.modules.igtooltip.TooltipIds;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class LocalizationProvider
implements IAE2DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, String> localizations = new HashMap<String, String>();
    private final class_2403 generator;
    private boolean wasSaved = false;

    public LocalizationProvider(class_2403 generator) {
        this.generator = generator;
    }

    public final void method_10319(class_2408 cache) {
        for (BlockDefinition<?> blockDefinition : AEBlocks.getBlocks()) {
            this.add("block.ae2." + blockDefinition.id().method_12832(), blockDefinition.getEnglishName());
        }
        for (ItemDefinition itemDefinition : AEItems.getItems()) {
            this.add("item.ae2." + itemDefinition.id().method_12832(), itemDefinition.getEnglishName());
        }
        for (Map.Entry entry : AEEntities.ENTITY_ENGLISH_NAMES.entrySet()) {
            this.add("entity.ae2." + (String)entry.getKey(), (String)entry.getValue());
        }
        this.addEnum(GuiText.class);
        this.addEnum(ButtonToolTips.class);
        this.addEnum(PlayerMessages.class);
        this.addEnum(InGameTooltip.class);
        this.addEnum(ItemModText.class);
        for (Iterator<Object> iterator : PowerUnits.values()) {
            this.add(((PowerUnits)((Object)iterator)).unlocalizedName, ((PowerUnits)((Object)iterator)).symbolName);
        }
        this.generateJadeLocalizations();
        this.generateLocalizations();
        this.save(cache, this.localizations);
    }

    private void generateJadeLocalizations() {
        this.addJadeProviderDisplayName(TooltipIds.DEBUG, "AE2 Debug Info");
        this.addJadeProviderDisplayName(TooltipIds.GRID_NODE_STATE, "AE2 Network State");
        this.addJadeProviderDisplayName(TooltipIds.POWER_STORAGE, "AE2 Power State");
        this.addJadeProviderDisplayName(TooltipIds.CRAFTING_MONITOR, "AE2 Crafting Monitor");
        this.addJadeProviderDisplayName(TooltipIds.PATTERN_PROVIDER, "AE2 Pattern Provider");
        this.addJadeProviderDisplayName(TooltipIds.CHARGER, "AE2 Charger");
        this.addJadeProviderDisplayName(TooltipIds.PART_NAME, "AE2 Part Name");
        this.addJadeProviderDisplayName(TooltipIds.PART_ICON, "AE2 Part Icon");
        this.addJadeProviderDisplayName(TooltipIds.PART_MOD_NAME, "AE2 Mod Name");
        this.addJadeProviderDisplayName(TooltipIds.PART_TOOLTIP, "AE2 Part Tooltip");
    }

    private void addJadeProviderDisplayName(class_2960 providerId, String name) {
        this.add("config.jade.plugin_" + providerId.method_12836() + "." + providerId.method_12832(), name);
    }

    public <T extends Enum<T>> void addEnum(Class<T> localizedEnum) {
        for (Enum enumConstant : (Enum[])localizedEnum.getEnumConstants()) {
            this.add(((LocalizationEnum)((Object)enumConstant)).getTranslationKey(), ((LocalizationEnum)((Object)enumConstant)).getEnglishText());
        }
    }

    public class_2561 component(String key, String text) {
        this.add(key, text);
        return new class_2588(key);
    }

    public void add(String key, String text) {
        Preconditions.checkState((!this.wasSaved ? 1 : 0) != 0, (Object)"Cannot add more translations after they were already saved");
        String previous = this.localizations.put(key, text);
        if (previous != null) {
            throw new IllegalStateException("Localization key " + key + " is already translated to: " + previous);
        }
    }

    private void generateLocalizations() {
        this.add("ae2.permission_denied", "You lack permission to access this.");
        this.add("biome.ae2.spatial_storage", "Spatial Storage");
        this.add("commands.ae2.ChunkLoggerOff", "Chunk Logging is now off");
        this.add("commands.ae2.ChunkLoggerOn", "Chunk Logging is now on");
        this.add("commands.ae2.permissions", "You do not have adequate permissions to run this command.");
        this.add("commands.ae2.usage", "Commands provided by Applied Energistics 2 - use /ae2 list for a list, and /ae2 help _____ for help with a command.");
        this.add("gui.ae2.PatternEncoding.primary_processing_result_hint", "Can be requested through the automated crafting system.");
        this.add("gui.ae2.PatternEncoding.primary_processing_result_tooltip", "Primary Processing Result");
        this.add("gui.ae2.PatternEncoding.secondary_processing_result_hint", "Can not be directly requested through the automated crafting system, but will be used before stored items in multi-step recipes.");
        this.add("gui.ae2.PatternEncoding.secondary_processing_result_tooltip", "Secondary Processing Result");
        this.add("gui.ae2.security.build.name", "Build");
        this.add("gui.ae2.security.build.tip", "User can modify the physical structure of the network, and make configuration changes.");
        this.add("gui.ae2.security.craft.name", "Craft");
        this.add("gui.ae2.security.craft.tip", "User can initiate new crafting jobs.");
        this.add("gui.ae2.security.extract.name", "Withdraw");
        this.add("gui.ae2.security.extract.tip", "User is allowed to remove items from storage.");
        this.add("gui.ae2.security.inject.name", "Deposit");
        this.add("gui.ae2.security.inject.tip", "User is allowed to store new items into storage.");
        this.add("gui.ae2.security.security.name", "Security");
        this.add("gui.ae2.security.security.tip", "User can access and modify the security terminal of the network.");
        this.add("itemGroup.ae2.facades", "Applied Energistics 2 - Facades");
        this.add("itemGroup.ae2.main", "Applied Energistics 2");
        this.add("key.ae2.category", "Applied Energistics 2");
        this.add("key.ae2.portable_fluid_cell", "Open Portable Fluid Cell");
        this.add("key.ae2.portable_item_cell", "Open Portable Item Cell");
        this.add("key.ae2.wireless_terminal", "Open Wireless Terminal");
        this.add("key.toggle_focus.desc", "Toggle search box focus");
        this.add("stat.ae2.items_extracted", "Items extracted from ME Storage");
        this.add("stat.ae2.items_inserted", "Items added to ME Storage");
        this.add("theoneprobe.ae2.channels", "%1$d Channels");
        this.add("theoneprobe.ae2.channels_of", "%1$d of %2$d Channels");
        this.add("theoneprobe.ae2.contains", "Contains");
        this.add("theoneprobe.ae2.crafting", "Crafting: %1$s");
        this.add("theoneprobe.ae2.device_missing_channel", "Device Missing Channel");
        this.add("theoneprobe.ae2.device_offline", "Device Offline");
        this.add("theoneprobe.ae2.device_online", "Device Online");
        this.add("theoneprobe.ae2.locked", "Locked");
        this.add("theoneprobe.ae2.nested_p2p_tunnel", "Error: Nested P2P Tunnel");
        this.add("theoneprobe.ae2.p2p_frequency", "Frequency: %1$s");
        this.add("theoneprobe.ae2.p2p_input_many_outputs", "Linked (Input Side) - %d Outputs");
        this.add("theoneprobe.ae2.p2p_input_one_output", "Linked (Input Side)");
        this.add("theoneprobe.ae2.p2p_output", "Linked (Output Side)");
        this.add("theoneprobe.ae2.p2p_unlinked", "Unlinked");
        this.add("theoneprobe.ae2.showing", "Showing");
        this.add("theoneprobe.ae2.stored_energy", "%1$d / %2$d");
        this.add("theoneprobe.ae2.unlocked", "Unlocked");
    }

    private void save(class_2408 cache, Map<String, String> localizations) {
        this.wasSaved = true;
        try {
            Path path = this.generator.method_10313().resolve("assets/ae2/lang/en_us.json");
            TreeMap<String, String> sorted = new TreeMap<String, String>(localizations);
            JsonObject jsonLocalization = new JsonObject();
            for (Map.Entry<String, String> entry : sorted.entrySet()) {
                jsonLocalization.addProperty(entry.getKey(), entry.getValue());
            }
            class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)jsonLocalization, (Path)path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String method_10321() {
        return "Localization (en_us)";
    }
}

