/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.advancements;

import appeng.api.util.AEColor;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.stats.AdvancementTriggers;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.localization.LocalizationProvider;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.loot.NeededPressType;
import appeng.loot.NeedsPressCondition;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;

public class AdvancementGenerator
implements IAE2DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 generator;
    private final LocalizationProvider localization;

    public AdvancementGenerator(class_2403 generator, LocalizationProvider localization) {
        this.generator = generator;
        this.localization = localization;
    }

    public void method_10319(class_2408 cache) {
        Path path = this.generator.method_10313();
        HashSet set = Sets.newHashSet();
        Consumer<class_161> consumer = advancement -> {
            if (!set.add(advancement.method_688())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.method_688());
            }
            Path path1 = AdvancementGenerator.createPath(path, advancement);
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)advancement.method_689().method_698(), (Path)path1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        this.generateAdvancements(consumer);
    }

    private void generateAdvancements(Consumer<class_161> consumer) {
        class_161 root = class_161.class_162.method_707().method_697(AEItems.CERTUS_QUARTZ_DUST, this.localization.component("achievement.ae2.Root", "Applied Energistics"), this.localization.component("achievement.ae2.Root.desc", "When a chest is simply not enough."), AppEng.makeId("textures/block/sky_stone_brick.png"), class_189.field_1254, false, false, false).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.CERTUS_QUARTZ_DUST})).method_694(consumer, "ae2:main/root");
        class_161 quartzCrystal = class_161.class_162.method_707().method_697(AEItems.CERTUS_QUARTZ_CRYSTAL, this.localization.component("achievement.ae2.QuartzCrystal", "Applied Energistics 2"), this.localization.component("achievement.ae2.QuartzCrystal.desc", "Obtain your first Certus Quartz Crystal."), null, class_189.field_1254, true, true, false).method_701(root).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.CERTUS_QUARTZ_CRYSTAL})).method_694(consumer, "ae2:main/quartz_crystal");
        class_161 chargedQuartz = class_161.class_162.method_707().method_697(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, this.localization.component("achievement.ae2.ChargedQuartz", "Shocking"), this.localization.component("achievement.ae2.ChargedQuartz.desc", "Charge Quartz with a Charger"), null, class_189.field_1254, true, true, false).method_701(quartzCrystal).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED})).method_694(consumer, "ae2:main/charged_quartz");
        class_161 charger = class_161.class_162.method_707().method_697(AEBlocks.CHARGER, this.localization.component("achievement.ae2.Charger", "Fluix Production"), this.localization.component("achievement.ae2.Charger.desc", "Craft a Charger"), null, class_189.field_1254, true, true, false).method_701(chargedQuartz).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEBlocks.CHARGER})).method_694(consumer, "ae2:main/charger");
        class_161 compass = class_161.class_162.method_707().method_697(AEBlocks.SKY_COMPASS, this.localization.component("achievement.ae2.Compass", "Meteorite Hunter"), this.localization.component("achievement.ae2.Compass.desc", "Craft a Meteorite Compass"), null, class_189.field_1254, true, true, false).method_701(quartzCrystal).method_709("compass", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEBlocks.SKY_COMPASS})).method_694(consumer, "ae2:main/compass");
        class_161.class_162 pressesBuilder = class_161.class_162.method_707().method_697(AEItems.LOGIC_PROCESSOR_PRESS, this.localization.component("achievement.ae2.Presses", "Unknown Technology"), this.localization.component("achievement.ae2.Presses.desc", "Find all Processor Presses"), null, class_189.field_1254, true, true, false).method_701(root).method_704(class_193.field_16882);
        for (NeededPressType neededPress : NeededPressType.values()) {
            pressesBuilder.method_709(neededPress.getCriterionName(), (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{neededPress.getItem()}));
        }
        class_161 presses = pressesBuilder.method_694(consumer, NeedsPressCondition.ADVANCEMENT_ID.toString());
        class_161 controller = class_161.class_162.method_707().method_697(AEBlocks.CONTROLLER, this.localization.component("achievement.ae2.Controller", "Networking Switchboard"), this.localization.component("achievement.ae2.Controller.desc", "Craft a Controller"), null, class_189.field_1254, true, true, false).method_701(presses).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEBlocks.CONTROLLER})).method_694(consumer, "ae2:main/controller");
        class_161 storageCell = class_161.class_162.method_707().method_697(AEItems.ITEM_CELL_64K, this.localization.component("achievement.ae2.StorageCell", "Better Than Chests"), this.localization.component("achievement.ae2.StorageCell.desc", "Craft a Storage Cell"), null, class_189.field_1254, false, false, false).method_701(controller).method_709("c1k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.ITEM_CELL_1K})).method_709("c4k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.ITEM_CELL_4K})).method_709("c16k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.ITEM_CELL_16K})).method_709("c64k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.ITEM_CELL_64K})).method_709("c256k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.ITEM_CELL_256K})).method_704(class_193.field_1257).method_694(consumer, "ae2:main/storage_cell");
        class_161 ioport = class_161.class_162.method_707().method_697(AEBlocks.IO_PORT, this.localization.component("achievement.ae2.IOPort", "Storage Cell Shuffle"), this.localization.component("achievement.ae2.IOPort.desc", "Craft an IO Port"), null, class_189.field_1254, true, true, false).method_701(storageCell).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEBlocks.IO_PORT})).method_694(consumer, "ae2:main/ioport");
        class_161 craftingTerminal = class_161.class_162.method_707().method_697(AEParts.CRAFTING_TERMINAL, this.localization.component("achievement.ae2.CraftingTerminal", "A (Much) Bigger Table"), this.localization.component("achievement.ae2.CraftingTerminal.desc", "Craft a Crafting Terminal"), null, class_189.field_1254, true, true, false).method_701(controller).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEParts.CRAFTING_TERMINAL})).method_694(consumer, "ae2:main/crafting_terminal");
        class_161 patternTerminal = class_161.class_162.method_707().method_697(AEParts.PATTERN_ENCODING_TERMINAL, this.localization.component("achievement.ae2.PatternTerminal", "Crafting Maestro"), this.localization.component("achievement.ae2.PatternTerminal.desc", "Craft a Pattern Encoding Terminal"), null, class_189.field_1254, true, true, false).method_701(craftingTerminal).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEParts.PATTERN_ENCODING_TERMINAL})).method_694(consumer, "ae2:main/pattern_encoding_terminal");
        class_161 craftingCpu = class_161.class_162.method_707().method_697(AEBlocks.CRAFTING_STORAGE_64K, this.localization.component("achievement.ae2.CraftingCPU", "Next Gen Crafting"), this.localization.component("achievement.ae2.CraftingCPU.desc", "Craft a Crafting Unit"), null, class_189.field_1254, false, false, false).method_701(patternTerminal).method_709("cu", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEBlocks.CRAFTING_UNIT})).method_704(class_193.field_1257).method_694(consumer, "ae2:main/crafting_cpu");
        class_161 fluix = class_161.class_162.method_707().method_697(AEItems.FLUIX_DUST, this.localization.component("achievement.ae2.Fluix", "Unnatural"), this.localization.component("achievement.ae2.Fluix.desc", "Create Fluix Dust"), null, class_189.field_1254, true, true, false).method_701(chargedQuartz).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.FLUIX_DUST})).method_694(consumer, "ae2:main/fluix");
        class_161 glassCable = class_161.class_162.method_707().method_697(AEParts.GLASS_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.GlassCable", "Fluix Energy Connection"), this.localization.component("achievement.ae2.GlassCable.desc", "Craft ME Glass Cable"), null, class_189.field_1254, true, true, false).method_701(fluix).method_709("certus", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(ConventionTags.GLASS_CABLE).method_8976()})).method_694(consumer, "ae2:main/glass_cable");
        class_161 facade = class_161.class_162.method_707().method_20416(AEItems.FACADE.method_8389().createFacadeForItemUnchecked(new class_1799((class_1935)class_1802.field_20391)), this.localization.component("achievement.ae2.Facade", "Network Aesthetics"), this.localization.component("achievement.ae2.Facade.desc", "Craft a Cable Facade"), null, class_189.field_1254, true, true, false).method_701(glassCable).method_709("facade", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.FACADE})).method_694(consumer, "ae2:main/facade");
        class_161 growthAccelerator = class_161.class_162.method_707().method_697(AEBlocks.QUARTZ_GROWTH_ACCELERATOR, this.localization.component("achievement.ae2.CrystalGrowthAccelerator", "Accelerator is an understatement"), this.localization.component("achievement.ae2.CrystalGrowthAccelerator.desc", "Craft a Crystal Growth Accelerator"), null, class_189.field_1254, true, true, false).method_701(fluix).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEBlocks.QUARTZ_GROWTH_ACCELERATOR})).method_694(consumer, "ae2:main/growth_accelerator");
        class_161 network1 = class_161.class_162.method_707().method_697(AEParts.COVERED_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking1", "Network Apprentice"), this.localization.component("achievement.ae2.Networking1.desc", "Reach 8 channels using devices on a network."), null, class_189.field_1254, true, true, false).method_701(glassCable).method_709("cable", (class_184)AdvancementTriggers.NETWORK_APPRENTICE.instance()).method_694(consumer, "ae2:main/network1");
        class_161 network2 = class_161.class_162.method_707().method_697(AEParts.SMART_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking2", "Network Engineer"), this.localization.component("achievement.ae2.Networking2.desc", "Reach 128 channels using devices on a network."), null, class_189.field_1254, true, true, false).method_701(network1).method_709("cable", (class_184)AdvancementTriggers.NETWORK_ENGINEER.instance()).method_694(consumer, "ae2:main/network2");
        class_161 network3 = class_161.class_162.method_707().method_697(AEParts.SMART_DENSE_CABLE.item(AEColor.TRANSPARENT), this.localization.component("achievement.ae2.Networking3", "Network Administrator"), this.localization.component("achievement.ae2.Networking3.desc", "Reach 2048 channels using devices on a network."), null, class_189.field_1254, true, true, false).method_701(network2).method_709("cable", (class_184)AdvancementTriggers.NETWORK_ADMIN.instance()).method_694(consumer, "ae2:main/network3");
        class_161 networkTool = class_161.class_162.method_707().method_697(AEItems.NETWORK_TOOL, this.localization.component("achievement.ae2.NetworkTool", "Network Diagnostics"), this.localization.component("achievement.ae2.NetworkTool.desc", "Craft a Network Tool"), null, class_189.field_1254, true, true, false).method_701(controller).method_709("network_tool", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.NETWORK_TOOL})).method_694(consumer, "ae2:main/network_tool");
        class_161 p2p = class_161.class_162.method_707().method_697(AEParts.ME_P2P_TUNNEL, this.localization.component("achievement.ae2.P2P", "Point to Point Networking"), this.localization.component("achievement.ae2.P2P.desc", "Craft a P2P Tunnel"), null, class_189.field_1254, true, true, false).method_701(glassCable).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEParts.ME_P2P_TUNNEL})).method_694(consumer, "ae2:main/p2p");
        class_161 portableCell = class_161.class_162.method_707().method_697(AEItems.PORTABLE_ITEM_CELL1K, this.localization.component("achievement.ae2.PortableCell", "Storage Nomad"), this.localization.component("achievement.ae2.PortableCell.desc", "Craft a Portable Cell"), null, class_189.field_1254, false, false, false).method_701(storageCell).method_709("pc_1k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.PORTABLE_ITEM_CELL1K})).method_709("pc_4k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.PORTABLE_ITEM_CELL4K})).method_709("pc_16k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.PORTABLE_ITEM_CELL16K})).method_709("pc_64k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.PORTABLE_ITEM_CELL64K})).method_709("pc_256k", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEItems.PORTABLE_ITEM_CELL256K})).method_704(class_193.field_1257).method_694(consumer, "ae2:main/portable_cell");
        class_161 qnb = class_161.class_162.method_707().method_697(AEBlocks.QUANTUM_LINK, this.localization.component("achievement.ae2.QNB", "Quantum Tunneling"), this.localization.component("achievement.ae2.QNB.desc", "Craft a Quantum Link"), null, class_189.field_1254, true, true, false).method_701(p2p).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEBlocks.QUANTUM_LINK})).method_694(consumer, "ae2:main/qnb");
        class_161 spatialIoport = class_161.class_162.method_707().method_697(AEBlocks.SPATIAL_IO_PORT, this.localization.component("achievement.ae2.SpatialIO", "Spatial Coordination"), this.localization.component("achievement.ae2.SpatialIO.desc", "Craft a Spatial IO Port"), null, class_189.field_1254, true, true, false).method_701(ioport).method_709("certus", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEBlocks.SPATIAL_IO_PORT})).method_694(consumer, "ae2:main/spatial_ioport");
        class_161 spatialExplorer = class_161.class_162.method_707().method_697(AEItems.SPATIAL_128_CELL_COMPONENT, this.localization.component("achievement.ae2.SpatialIOExplorer", "To boldly go"), this.localization.component("achievement.ae2.SpatialIOExplorer.desc", "Get stored in a spatial storage cell"), null, class_189.field_1254, false, false, false).method_701(spatialIoport).method_709("explorer", (class_184)AdvancementTriggers.SPATIAL_EXPLORER.instance()).method_694(consumer, "ae2:main/spatial_explorer");
        class_161 storageBus = class_161.class_162.method_707().method_697(AEParts.STORAGE_BUS, this.localization.component("achievement.ae2.StorageBus", "Limitless Potential"), this.localization.component("achievement.ae2.StorageBus.desc", "Craft a Storage Bus"), null, class_189.field_1254, true, true, false).method_701(glassCable).method_709("part", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{AEParts.STORAGE_BUS})).method_694(consumer, "ae2:main/storage_bus");
        class_161 storageBusOnInterface = class_161.class_162.method_707().method_697(AEBlocks.INTERFACE, this.localization.component("achievement.ae2.Recursive", "Recursive Networking"), this.localization.component("achievement.ae2.Recursive.desc", "Place a Storage Bus on an Interface."), null, class_189.field_1254, true, true, false).method_701(storageBus).method_709("recursive", (class_184)AdvancementTriggers.RECURSIVE.instance()).method_694(consumer, "ae2:main/recursive");
    }

    private static Path createPath(Path basePath, class_161 advancement) {
        return basePath.resolve("data/" + advancement.method_688().method_12836() + "/advancements/" + advancement.method_688().method_12832() + ".json");
    }

    public String method_10321() {
        return "Advancements";
    }
}

