/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import appeng.core.AELog;
import appeng.crafting.pattern.AESmithingTablePattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.SmithingTablePatternEncoding;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5357;

public class SmithingTablePatternItem
extends EncodedPatternItem {
    public SmithingTablePatternItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    @Nullable
    public AESmithingTablePattern decode(class_1799 stack, class_1937 level, boolean tryRecovery) {
        class_2487 tag;
        if (stack.method_7909() != this || !stack.method_7985() || level == null) {
            return null;
        }
        AESmithingTablePattern result = this.decode(AEItemKey.of(stack), level);
        if (tryRecovery && result == null && this.attemptRecovery(tag = stack.method_7948(), level)) {
            result = this.decode(stack, level, false);
        }
        return result;
    }

    @Override
    public AESmithingTablePattern decode(AEItemKey what, class_1937 level) {
        if (what == null || !what.hasTag()) {
            return null;
        }
        try {
            return new AESmithingTablePattern(what, level);
        }
        catch (Exception e) {
            AELog.warn("Could not decode an invalid crafting pattern %s: %s", what.getTag(), e);
            return null;
        }
    }

    public class_1799 encode(class_5357 recipe, AEItemKey base, AEItemKey addition, AEItemKey out, boolean allowSubstitutes) {
        class_1799 stack = new class_1799((class_1935)this);
        SmithingTablePatternEncoding.encode(stack.method_7948(), recipe, base, addition, out, allowSubstitutes);
        return stack;
    }

    private boolean attemptRecovery(class_2487 tag, class_1937 level) {
        class_1863 recipeManager = level.method_8433();
        AEItemKey base = SmithingTablePatternEncoding.getBase(tag);
        AEItemKey addition = SmithingTablePatternEncoding.getAddition(tag);
        AEItemKey output = SmithingTablePatternEncoding.getOutput(tag);
        if (base == null || addition == null || output == null) {
            return false;
        }
        class_2960 recipeId = SmithingTablePatternEncoding.getRecipeId(tag);
        class_1277 testInventory = new class_1277(2);
        testInventory.method_5447(0, base.toStack());
        testInventory.method_5447(1, addition.toStack());
        class_5357 recipe = recipeManager.method_8132(class_3956.field_25388, (class_1263)testInventory, level).orElse(null);
        if (recipe == null) {
            AELog.info("Failed to recover encoded stonecutting pattern for recipe %s (no recipe for inputs)", recipeId);
            return false;
        }
        if (!AEItemKey.matches(output, recipe.method_8110())) {
            AELog.info("Failed to recover encoded stonecutting pattern for recipe %s (output mismatch)", recipeId);
            return false;
        }
        AELog.debug("Re-Encoding pattern from %s -> %s", recipeId, recipe.method_8114());
        SmithingTablePatternEncoding.encode(tag, recipe, base, addition, output, SmithingTablePatternEncoding.canSubstitute(tag));
        return true;
    }
}

