/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.config;

import appeng.core.config.BaseOption;
import appeng.core.config.ConfigSection;
import appeng.core.config.ConfigValidationException;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class DoubleOption
extends BaseOption {
    private final double defaultValue;
    private final double minValue;
    private final double maxValue;
    private double currentValue;

    public DoubleOption(ConfigSection parent, String id, String comment, double defaultValue, double minValue, double maxValue) {
        super(parent, id, comment);
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public double get() {
        return this.currentValue;
    }

    public void set(double value) {
        if (value == this.currentValue) {
            return;
        }
        this.checkValue(value);
        this.currentValue = value;
        this.parent.markDirty();
    }

    private void checkValue(double value) {
        if (value < this.minValue || value > this.maxValue) {
            StringBuilder rangeDescription = new StringBuilder();
            if (this.minValue != Double.MIN_VALUE) {
                rangeDescription.append("min: ").append(this.minValue);
            }
            if (this.maxValue != Double.MAX_VALUE) {
                if (rangeDescription.length() > 0) {
                    rangeDescription.append(", ");
                }
                rangeDescription.append("max: ").append(this.maxValue);
            }
            throw new ConfigValidationException(this, "Value out of range: " + value + " (" + rangeDescription + ")");
        }
    }

    @Override
    protected JsonElement write() {
        return new JsonPrimitive((Number)this.currentValue);
    }

    @Override
    protected void read(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            throw new ConfigValidationException(this, "Expected a JSON primitive, but found: " + element);
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!primitive.isNumber()) {
            throw new ConfigValidationException(this, "Expected a JSON number, but found: " + primitive);
        }
        double value = primitive.getAsDouble();
        this.checkValue(value);
        this.currentValue = value;
    }

    @Override
    public boolean isDifferentFromDefault() {
        return this.currentValue != this.defaultValue;
    }

    @Override
    public String getDefaultAsString() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public String getCurrentValueAsString() {
        return String.valueOf(this.currentValue);
    }
}

