/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.parts.CableRenderMode;
import appeng.api.parts.PartHelper;
import appeng.client.EffectType;
import appeng.client.Hotkeys;
import appeng.client.gui.me.common.PendingCraftingJobs;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.client.gui.style.StyleManager;
import appeng.client.render.StorageCellClientTooltipComponent;
import appeng.client.render.effects.EnergyParticleData;
import appeng.client.render.effects.ParticleTypes;
import appeng.client.render.overlay.OverlayManager;
import appeng.client.render.tesr.InscriberTESR;
import appeng.client.render.tesr.SkyChestTESR;
import appeng.core.AEConfig;
import appeng.core.AppEngBase;
import appeng.core.sync.network.ClientNetworkHandler;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MouseWheelPacket;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.BlockAttackHook;
import appeng.hooks.ICustomPickBlock;
import appeng.hooks.MouseWheelScrolled;
import appeng.hooks.RenderBlockOutlineHook;
import appeng.hotkeys.HotkeyActions;
import appeng.init.client.InitAdditionalModels;
import appeng.init.client.InitAutoRotatingModel;
import appeng.init.client.InitBlockColors;
import appeng.init.client.InitBlockEntityRenderers;
import appeng.init.client.InitBuiltInModels;
import appeng.init.client.InitEntityLayerDefinitions;
import appeng.init.client.InitEntityRendering;
import appeng.init.client.InitItemColors;
import appeng.init.client.InitItemModelsProperties;
import appeng.init.client.InitParticleFactories;
import appeng.init.client.InitRenderTypes;
import appeng.init.client.InitScreens;
import appeng.init.client.InitStackRenderHandlers;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.siteexport.SiteExporter;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4066;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class AppEngClient
extends AppEngBase {
    private static AppEngClient INSTANCE;
    private CableRenderMode prevCableRenderMode = CableRenderMode.STANDARD;

    public AppEngClient() {
        this.registerParticleFactories();
        this.registerTextures();
        this.modelRegistryEvent();
        this.registerBlockColors();
        this.registerItemColors();
        this.registerEntityRenderers();
        this.registerEntityLayerDefinitions();
        this.registerClientTooltipComponents();
        ClientPickBlockGatherCallback.EVENT.register(this::onPickBlock);
        ClientTickEvents.START_CLIENT_TICK.register(this::updateCableRenderMode);
        InitAutoRotatingModel.init();
        BlockAttackHook.install();
        RenderBlockOutlineHook.install();
        ClientLifecycleEvents.CLIENT_STARTED.register(this::clientSetup);
        INSTANCE = this;
        this.notifyAddons("client");
        HotkeyActions.init();
        ClientTickEvents.END_CLIENT_TICK.register(c -> Hotkeys.checkHotkeys());
        ClientTickEvents.END_CLIENT_TICK.register(this::tickPinnedKeys);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            PendingCraftingJobs.clearPendingJobs();
            PinnedKeys.clearPinnedKeys();
        });
        AppEngClient.registerTests();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            SiteExporter.initialize();
        }
    }

    private void tickPinnedKeys(class_310 minecraft) {
        if (minecraft.field_1755 == null) {
            PinnedKeys.prune();
        }
    }

    @Override
    public class_1937 getClientLevel() {
        return class_310.method_1551().field_1687;
    }

    @Override
    public void registerHotkey(String id) {
        Hotkeys.registerHotkey(id);
    }

    public static AppEngClient instance() {
        return Objects.requireNonNull(INSTANCE, "AppEngClient is not initialized");
    }

    public void registerParticleFactories() {
        InitParticleFactories.init();
    }

    public void registerTextures() {
        Stream<Collection> sprites = Stream.of(SkyChestTESR.SPRITES, InscriberTESR.SPRITES);
        Map<class_2960, List<class_4730>> groupedByAtlas = sprites.flatMap(Collection::stream).collect(Collectors.groupingBy(class_4730::method_24144));
        for (Map.Entry<class_2960, List<class_4730>> entry : groupedByAtlas.entrySet()) {
            ClientSpriteRegistryCallback.event((class_2960)entry.getKey()).register((spriteAtlasTexture, registry) -> {
                for (class_4730 spriteIdentifier : (List)entry.getValue()) {
                    registry.register(spriteIdentifier.method_24147());
                }
            });
        }
    }

    public void registerBlockColors() {
        InitBlockColors.init((arg_0, arg_1) -> ((ColorProviderRegistry)ColorProviderRegistry.BLOCK).register(arg_0, arg_1));
    }

    public void registerItemColors() {
        InitItemColors.init((arg_0, arg_1) -> ((ColorProviderRegistry)ColorProviderRegistry.ITEM).register(arg_0, arg_1));
    }

    private void registerClientTooltipComponents() {
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof StorageCellTooltipComponent) {
                StorageCellTooltipComponent cellTooltipComponent = (StorageCellTooltipComponent)data;
                return new StorageCellClientTooltipComponent(cellTooltipComponent);
            }
            return null;
        });
    }

    private void clientSetup(class_310 client) {
        this.postClientSetup(client);
        MouseWheelScrolled.EVENT.register(this::wheelEvent);
        WorldRenderEvents.LAST.register(OverlayManager.getInstance()::renderWorldLastEvent);
    }

    private void registerEntityRenderers() {
        InitEntityRendering.init((arg_0, arg_1) -> ((EntityRendererRegistry)EntityRendererRegistry.INSTANCE).register(arg_0, arg_1));
    }

    private void registerEntityLayerDefinitions() {
        InitEntityLayerDefinitions.init((modelLayerLocation, layerDefinition) -> EntityModelLayerRegistry.registerModelLayer((class_5601)modelLayerLocation, () -> layerDefinition));
    }

    private void postClientSetup(class_310 minecraft) {
        StyleManager.initialize(minecraft.method_1478());
        InitScreens.init();
        InitStackRenderHandlers.init();
    }

    @Environment(value=EnvType.CLIENT)
    public void modelRegistryEvent() {
        InitAdditionalModels.init();
        InitBlockEntityRenderers.init();
        InitItemModelsProperties.init();
        InitRenderTypes.init();
        InitBuiltInModels.init();
    }

    private boolean wheelEvent(double verticalAmount) {
        if (verticalAmount == 0.0) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (InteractionUtil.isInAlternateUseMode((class_1657)player)) {
            boolean mainHand = player.method_5998(class_1268.field_5808).method_7909() instanceof IMouseWheelItem;
            boolean offHand = player.method_5998(class_1268.field_5810).method_7909() instanceof IMouseWheelItem;
            if (mainHand || offHand) {
                NetworkHandler.instance().sendToServer(new MouseWheelPacket(verticalAmount > 0.0));
                return true;
            }
        }
        return false;
    }

    public boolean shouldAddParticles(Random r) {
        return switch (class_310.method_1551().field_1690.field_1882) {
            default -> throw new IncompatibleClassChangeError();
            case class_4066.field_18197 -> true;
            case class_4066.field_18198 -> r.nextBoolean();
            case class_4066.field_18199 -> false;
        };
    }

    @Override
    public class_239 getCurrentMouseOver() {
        return class_310.method_1551().field_1765;
    }

    @Override
    public void spawnEffect(EffectType effect, class_1937 level, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance().isEnableEffects()) {
            switch (effect) {
                case Vibrant: {
                    this.spawnVibrant(level, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(level, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(level, posX, posY, posZ);
                    return;
                }
            }
        }
    }

    private void spawnVibrant(class_1937 level, double x, double y, double z) {
        if (AppEngClient.instance().shouldAddParticles(Platform.getRandom())) {
            double d0 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d1 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d2 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            class_310.method_1551().field_1713.method_3056((class_2394)ParticleTypes.VIBRANT, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
        }
    }

    private void spawnEnergy(class_1937 level, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        class_310.method_1551().field_1713.method_3056((class_2394)EnergyParticleData.FOR_BLOCK, posX + (double)x, posY + (double)y, posZ + (double)z, (double)(-x) * 0.1, (double)(-y) * 0.1, (double)(-z) * 0.1);
    }

    private void spawnLightning(class_1937 level, double posX, double posY, double posZ) {
        class_310.method_1551().field_1713.method_3056((class_2394)ParticleTypes.LIGHTNING, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
    }

    private void updateCableRenderMode(class_310 mc) {
        CableRenderMode currentMode = PartHelper.getCableRenderMode();
        if (currentMode == this.prevCableRenderMode) {
            return;
        }
        this.prevCableRenderMode = currentMode;
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        class_746 player = mc.field_1724;
        int x = (int)player.method_23317();
        int y = (int)player.method_23318();
        int z = (int)player.method_23321();
        int range = 256;
        mc.field_1769.method_18146(x - 256, y - 256, z - 256, x + 256, y + 256, z + 256);
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        if (Platform.isServer()) {
            return super.getCableRenderMode();
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        return this.getCableRenderModeForPlayer((class_1657)player);
    }

    @Override
    protected void initNetworkHandler() {
        new ClientNetworkHandler();
    }

    private class_1799 onPickBlock(class_1657 player, class_239 hitResult) {
        class_3965 blockHitResult;
        class_2338 blockPos;
        class_2680 blockState;
        class_2248 class_22482;
        if (hitResult instanceof class_3965 && (class_22482 = (blockState = player.field_6002.method_8320(blockPos = (blockHitResult = (class_3965)hitResult).method_17777())).method_26204()) instanceof ICustomPickBlock) {
            ICustomPickBlock customPickBlock = (ICustomPickBlock)class_22482;
            return customPickBlock.getPickBlock(blockState, hitResult, (class_1922)player.field_6002, blockPos, player);
        }
        return class_1799.field_8037;
    }
}

