/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.util.AECableType;
import appeng.block.networking.EnergyCellBlock;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.hooks.ticking.TickHandler;
import appeng.util.SettingsFrom;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class EnergyCellBlockEntity
extends AENetworkBlockEntity
implements IAEPowerStorage {
    private double internalCurrentPower = 0.0;
    private final double internalMaxPower;
    private byte currentMeta = (byte)-1;
    private boolean neighborChangePending;

    public EnergyCellBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IAEPowerStorage.class, this);
        EnergyCellBlock cellBlock = (EnergyCellBlock)this.method_11010().method_26204();
        this.internalMaxPower = cellBlock.getMaxPower();
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        super.onReady();
        int value = (Integer)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)EnergyCellBlock.ENERGY_STORAGE);
        this.currentMeta = (byte)value;
        this.updateStateForPowerLevel();
    }

    public static int getStorageLevelFromFillFactor(double fillFactor) {
        return (int)Math.floor(4.0 * class_3532.method_15350((double)(fillFactor + 0.01), (double)0.0, (double)1.0));
    }

    private void updateStateForPowerLevel() {
        if (this.method_11015()) {
            return;
        }
        int storageLevel = EnergyCellBlockEntity.getStorageLevelFromFillFactor(this.internalCurrentPower / this.internalMaxPower);
        if (this.currentMeta != storageLevel) {
            this.currentMeta = (byte)storageLevel;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(storageLevel)));
        }
    }

    private void onAmountChanged() {
        if (!this.neighborChangePending) {
            this.neighborChangePending = true;
            TickHandler.instance().addCallable((class_1936)this.field_11863, () -> {
                if (!this.method_11015() && this.neighborChangePending) {
                    this.neighborChangePending = false;
                    this.updateStateForPowerLevel();
                    this.method_5431();
                }
            });
        }
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10549("internalCurrentPower", this.internalCurrentPower);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.internalCurrentPower = data.method_10574("internalCurrentPower");
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.internalCurrentPower = input.method_10574("internalCurrentPower");
        }
    }

    @Override
    public void exportSettings(SettingsFrom from, class_2487 data, @Nullable class_1657 player) {
        super.exportSettings(from, data, player);
        if (from == SettingsFrom.DISMANTLE_ITEM && this.internalCurrentPower > 1.0E-4) {
            data.method_10549("internalCurrentPower", this.internalCurrentPower);
            data.method_10549("internalMaxPower", this.internalMaxPower);
        }
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            double fakeBattery = this.internalCurrentPower + amt;
            if (fakeBattery > this.internalMaxPower) {
                return fakeBattery - this.internalMaxPower;
            }
            return 0.0;
        }
        if (this.internalCurrentPower < 0.01 && amt > 0.01) {
            this.getMainNode().getNode().getGrid().postEvent(new GridPowerStorageStateChanged(this, GridPowerStorageStateChanged.PowerEventType.PROVIDE_POWER));
        }
        this.internalCurrentPower += amt;
        if (this.internalCurrentPower > this.internalMaxPower) {
            amt = this.internalCurrentPower - this.internalMaxPower;
            this.internalCurrentPower = this.internalMaxPower;
            this.onAmountChanged();
            return amt;
        }
        this.onAmountChanged();
        return 0.0;
    }

    @Override
    public double getAEMaxPower() {
        return this.internalMaxPower;
    }

    @Override
    public double getAECurrentPower() {
        return this.internalCurrentPower;
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    @Override
    public int getPriority() {
        return ((EnergyCellBlock)this.method_11010().method_26204()).getPriority();
    }

    private double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.internalCurrentPower > amt) {
                return amt;
            }
            return this.internalCurrentPower;
        }
        boolean bl = wasFull = this.internalCurrentPower >= this.internalMaxPower - 0.001;
        if (wasFull && amt > 0.001) {
            this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, GridPowerStorageStateChanged.PowerEventType.REQUEST_POWER)));
        }
        if (this.internalCurrentPower > amt) {
            this.internalCurrentPower -= amt;
            this.onAmountChanged();
            return amt;
        }
        amt = this.internalCurrentPower;
        this.internalCurrentPower = 0.0;
        this.onAmountChanged();
        return amt;
    }
}

