/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class ChargerBlockEntity
extends AENetworkPowerBlockEntity
implements IGridTickable {
    private static final int POWER_MAXIMUM_AMOUNT = 1600;
    private static final int POWER_THRESHOLD = 1599;
    private boolean working;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1, 1, new ChargerInvFilter());

    public ChargerBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(class_2350.class)).setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, this);
        this.setInternalMaxPower(1600.0);
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        EnumSet<class_2350> validSides = EnumSet.allOf(class_2350.class);
        validSides.remove(this.getForward());
        this.getMainNode().setExposedOnSides(validSides);
        super.onReady();
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        this.working = data.readBoolean();
        if (data.readBoolean()) {
            AEItemKey item = AEItemKey.fromPacket(data);
            this.inv.setItemDirect(0, item.toStack());
        } else {
            this.inv.setItemDirect(0, class_1799.field_8037);
        }
        return changed;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.working);
        AEItemKey is = AEItemKey.of(this.inv.getStackInSlot(0));
        data.writeBoolean(is != null);
        if (is != null) {
            is.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        EnumSet<class_2350> validSides = EnumSet.allOf(class_2350.class);
        validSides.remove(this.getForward());
        this.getMainNode().setExposedOnSides(validSides);
        this.setPowerSides(validSides);
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        this.markForUpdate();
    }

    public void activate(class_1657 player) {
        if (!Platform.hasPermissions(new DimensionalBlockPos(this), player)) {
            return;
        }
        class_1799 myItem = this.inv.getStackInSlot(0);
        if (myItem.method_7960()) {
            class_1799 held = player.method_31548().method_7391();
            if (AEItems.CERTUS_QUARTZ_CRYSTAL.isSameAs(held) || Platform.isChargeable(held)) {
                held = player.method_31548().method_5434(player.method_31548().field_7545, 1);
                this.inv.setItemDirect(0, held);
            }
        } else {
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            drops.add(myItem);
            this.inv.setItemDirect(0, class_1799.field_8037);
            Platform.spawnDrops(this.field_11863, this.field_11867.method_10093(this.getForward()), drops);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger, false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.doWork(ticksSinceLastCall);
        return TickRateModulation.FASTER;
    }

    private void doWork(int ticksSinceLastCall) {
        boolean wasWorking = this.working;
        this.working = false;
        boolean changed = false;
        class_1799 myItem = this.inv.getStackInSlot(0);
        if (!myItem.method_7960()) {
            if (Platform.isChargeable(myItem)) {
                double maxPower;
                IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.method_7909();
                double currentPower = ps.getAECurrentPower(myItem);
                if (currentPower < (maxPower = ps.getAEMaxPower(myItem))) {
                    double chargeRate = ps.getChargeRate(myItem) * (double)ticksSinceLastCall * AEConfig.instance().getChargerChargeRate();
                    double extractedAmount = this.extractAEPower(chargeRate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    double missingChargeRate = chargeRate - extractedAmount;
                    double missingAEPower = maxPower - currentPower;
                    double toExtract = Math.min(missingChargeRate, missingAEPower);
                    IGrid grid2 = this.getMainNode().getGrid();
                    if (grid2 != null) {
                        extractedAmount += grid2.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                    }
                    if (extractedAmount > 0.0) {
                        double adjustment = ps.injectAEPower(myItem, extractedAmount, Actionable.MODULATE);
                        this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                        this.working = true;
                        changed = true;
                    }
                }
            } else if (this.getInternalCurrentPower() > 1599.0 && AEItems.CERTUS_QUARTZ_CRYSTAL.isSameAs(myItem)) {
                this.working = true;
                if (Platform.getRandomFloat() > 0.8f) {
                    this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                    class_1799 charged = AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.stack(myItem.method_7947());
                    this.inv.setItemDirect(0, charged);
                    changed = true;
                }
            }
        }
        if (this.getInternalCurrentPower() < 1599.0) {
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(800.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            });
            changed = true;
        }
        if (changed || this.working != wasWorking) {
            this.markForUpdate();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    private static class ChargerInvFilter
    implements IAEItemFilter {
        private ChargerInvFilter() {
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int i, class_1799 itemstack) {
            return Platform.isChargeable(itemstack) || AEItems.CERTUS_QUARTZ_CRYSTAL.isSameAs(itemstack);
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slotIndex, int amount) {
            IAEItemPowerStorage ips;
            class_1799 extractedItem = inv.getStackInSlot(slotIndex);
            if (Platform.isChargeable(extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.method_7909()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
                return true;
            }
            return AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.isSameAs(extractedItem);
        }
    }
}

