/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.AELog;
import appeng.items.misc.WrappedGenericStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Contract;

public abstract class AEKey {
    private volatile class_2561 cachedDisplayName;

    public AEKey() {
    }

    @Deprecated(forRemoval=true)
    public AEKey(class_2561 displayName) {
        this.cachedDisplayName = displayName;
    }

    @Nullable
    public static AEKey fromTagGeneric(class_2487 tag) {
        AEKeyType channel;
        String channelId = tag.method_10558("#c");
        if (channelId.isEmpty()) {
            AELog.warn("Cannot deserialize generic key from %s because key '#c' is missing.", tag);
            return null;
        }
        try {
            channel = AEKeyTypes.get(new class_2960(channelId));
        }
        catch (IllegalArgumentException | class_151 e) {
            AELog.warn("Cannot deserialize generic key from %s because channel '%s' is missing.", tag, channelId);
            return null;
        }
        return channel.loadKeyFromTag(tag);
    }

    public static void writeOptionalKey(class_2540 buffer, @Nullable AEKey key) {
        buffer.writeBoolean(key != null);
        if (key != null) {
            AEKey.writeKey(buffer, key);
        }
    }

    public static void writeKey(class_2540 buffer, AEKey key) {
        byte id = key.getType().getRawId();
        buffer.method_10804((int)id);
        key.writeToPacket(buffer);
    }

    @Nullable
    public static AEKey readOptionalKey(class_2540 buffer) {
        if (!buffer.readBoolean()) {
            return null;
        }
        return AEKey.readKey(buffer);
    }

    @Nullable
    public static AEKey readKey(class_2540 buffer) {
        int id = buffer.method_10816();
        AEKeyType type = AEKeyType.fromRawId(id);
        if (type == null) {
            AELog.error("Received unknown key space id %d", id);
            return null;
        }
        return type.readFromPacket(buffer);
    }

    public final class_2487 toTagGeneric() {
        class_2487 tag = this.toTag();
        tag.method_10582("#c", this.getType().getId().toString());
        return tag;
    }

    public final int getAmountPerUnit() {
        return this.getType().getAmountPerUnit();
    }

    @Nullable
    public final String getUnitSymbol() {
        return this.getType().getUnitSymbol();
    }

    public final int getAmountPerOperation() {
        return this.getType().getAmountPerOperation();
    }

    public final int getAmountPerByte() {
        return this.getType().getAmountPerByte();
    }

    public String formatAmount(long amount, AmountFormat format) {
        return this.getType().formatAmount(amount, format);
    }

    public abstract AEKeyType getType();

    public abstract AEKey dropSecondary();

    public abstract class_2487 toTag();

    public abstract Object getPrimaryKey();

    public int getFuzzySearchValue() {
        return 0;
    }

    public int getFuzzySearchMaxValue() {
        return 0;
    }

    public final boolean fuzzyEquals(AEKey other, FuzzyMode fuzzyMode) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this.getPrimaryKey() != other.getPrimaryKey()) {
            return false;
        }
        if (!this.supportsFuzzyRangeSearch()) {
            return true;
        }
        if (fuzzyMode == FuzzyMode.IGNORE_ALL) {
            return true;
        }
        if (fuzzyMode == FuzzyMode.PERCENT_99) {
            return this.getFuzzySearchValue() > 0 == other.getFuzzySearchValue() > 0;
        }
        float percentA = (float)this.getFuzzySearchValue() / (float)this.getFuzzySearchMaxValue();
        float percentB = (float)other.getFuzzySearchValue() / (float)other.getFuzzySearchMaxValue();
        return percentA > fuzzyMode.breakPoint == percentB > fuzzyMode.breakPoint;
    }

    @Contract(value="null -> false")
    public final boolean matches(@Nullable GenericStack stack) {
        return stack != null && stack.what().equals(this);
    }

    public String getModId() {
        return this.getId().method_12836();
    }

    public class_2960 getId() {
        return new class_2960("unknown");
    }

    public abstract void writeToPacket(class_2540 var1);

    public class_1799 wrapForDisplayOrFilter() {
        return GenericStack.wrapInItemStack(this, 0L);
    }

    @Deprecated(forRemoval=true)
    public class_1799 wrap(int amount) {
        return WrappedGenericStack.wrap(this, amount);
    }

    public final boolean supportsFuzzyRangeSearch() {
        return this.getType().supportsFuzzyRangeSearch();
    }

    public class_2561 getDisplayName() {
        class_2561 ret = this.cachedDisplayName;
        if (ret == null) {
            this.cachedDisplayName = ret = this.computeDisplayName();
        }
        return ret;
    }

    protected class_2561 computeDisplayName() {
        throw new UnsupportedOperationException("Must be overriden for lazy display name computation.");
    }

    public abstract void addDrops(long var1, List<class_1799> var3, class_1937 var4, class_2338 var5);

    public boolean isTagged(class_6862<?> tag) {
        return false;
    }
}

