/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.networking;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AEColor;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;

public interface IManagedGridNode {
    public void destroy();

    public void create(class_1937 var1, @Nullable class_2338 var2);

    public void loadFromNBT(class_2487 var1);

    public void saveToNBT(class_2487 var1);

    default public boolean ifPresent(Consumer<IGrid> action) {
        IGridNode node = this.getNode();
        if (node == null) {
            return false;
        }
        action.accept(node.getGrid());
        return true;
    }

    default public boolean ifPresent(BiConsumer<IGrid, IGridNode> action) {
        IGridNode node = this.getNode();
        if (node == null) {
            return false;
        }
        action.accept(node.getGrid(), node);
        return true;
    }

    @Nullable
    default public IGrid getGrid() {
        IGridNode node = this.getNode();
        if (node == null) {
            return null;
        }
        return node.getGrid();
    }

    public IManagedGridNode setFlags(GridFlags ... var1);

    public IManagedGridNode setExposedOnSides(Set<class_2350> var1);

    public IManagedGridNode setIdlePowerUsage(@Nonnegative double var1);

    public IManagedGridNode setVisualRepresentation(@Nullable AEItemKey var1);

    default public IManagedGridNode setVisualRepresentation(class_1799 visualRepresentation) {
        return this.setVisualRepresentation(AEItemKey.of(visualRepresentation));
    }

    default public IManagedGridNode setVisualRepresentation(class_1935 visualRepresentation) {
        return this.setVisualRepresentation(AEItemKey.of(visualRepresentation));
    }

    public IManagedGridNode setInWorldNode(boolean var1);

    public IManagedGridNode setTagName(String var1);

    public IManagedGridNode setGridColor(AEColor var1);

    public <T extends IGridNodeService> IManagedGridNode addService(Class<T> var1, T var2);

    public boolean isReady();

    public boolean isActive();

    public boolean isOnline();

    public boolean isPowered();

    public boolean hasGridBooted();

    public void setOwningPlayerId(int var1);

    public void setOwningPlayer(class_1657 var1);

    @Nullable
    public IGridNode getNode();
}

