/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.block;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.config.DropTypeConfig;
import com.b1n_ry.yigd.config.RetrievalTypeConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.GraveHelper;
import com.b1n_ry.yigd.item.KeyItem;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6760;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class GraveBlock
extends class_2237
implements class_2343,
class_3737 {
    public static JsonObject customModel;
    public static final class_2753 FACING;
    protected static class_265 SHAPE_NORTH;
    protected static final class_265 SHAPE_BASE_NORTH;
    protected static final class_265 SHAPE_FOOT_NORTH;
    protected static final class_265 SHAPE_CORE_NORTH;
    protected static final class_265 SHAPE_TOP_NORTH;
    protected static class_265 SHAPE_WEST;
    protected static final class_265 SHAPE_BASE_WEST;
    protected static final class_265 SHAPE_FOOT_WEST;
    protected static final class_265 SHAPE_CORE_WEST;
    protected static final class_265 SHAPE_TOP_WEST;
    protected static class_265 SHAPE_EAST;
    protected static final class_265 SHAPE_BASE_EAST;
    protected static final class_265 SHAPE_FOOT_EAST;
    protected static final class_265 SHAPE_CORE_EAST;
    protected static final class_265 SHAPE_TOP_EAST;
    protected static class_265 SHAPE_SOUTH;
    protected static final class_265 SHAPE_BASE_SOUTH;
    protected static final class_265 SHAPE_FOOT_SOUTH;
    protected static final class_265 SHAPE_CORE_SOUTH;
    protected static final class_265 SHAPE_TOP_SOUTH;
    protected static final class_2746 WATERLOGGED;

    public GraveBlock(class_4970.class_2251 settings) {
        super(settings.method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    public static void reloadVoxelShapes(JsonObject graveModel) {
        if (graveModel == null) {
            return;
        }
        JsonElement shapesArray = graveModel.get("elements");
        if (shapesArray == null || !shapesArray.isJsonArray()) {
            return;
        }
        class_265 groundShapeNorth = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        class_265 groundShapeWest = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        class_265 groundShapeSouth = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        class_265 groundShapeEast = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        ArrayList<class_265> shapesNorth = new ArrayList<class_265>();
        ArrayList<class_265> shapesWest = new ArrayList<class_265>();
        ArrayList<class_265> shapesSouth = new ArrayList<class_265>();
        ArrayList<class_265> shapesEast = new ArrayList<class_265>();
        for (JsonElement e : (JsonArray)shapesArray) {
            if (!e.isJsonObject()) continue;
            JsonObject o = e.getAsJsonObject();
            if (o.get("name") != null && o.get("name").getAsString().equals("Base_Layer")) {
                Map<String, class_265> groundShapes = GraveBlock.getShapeFromJson(o);
                groundShapeNorth = groundShapes.get("NORTH");
                groundShapeWest = groundShapes.get("WEST");
                groundShapeSouth = groundShapes.get("SOUTH");
                groundShapeEast = groundShapes.get("EAST");
                continue;
            }
            Map<String, class_265> directionShapes = GraveBlock.getShapeFromJson(o);
            shapesNorth.add(directionShapes.get("NORTH"));
            shapesWest.add(directionShapes.get("WEST"));
            shapesSouth.add(directionShapes.get("SOUTH"));
            shapesEast.add(directionShapes.get("EAST"));
        }
        SHAPE_NORTH = class_259.method_17786((class_265)groundShapeNorth, (class_265[])shapesNorth.toArray(new class_265[0]));
        SHAPE_WEST = class_259.method_17786((class_265)groundShapeWest, (class_265[])shapesWest.toArray(new class_265[0]));
        SHAPE_SOUTH = class_259.method_17786((class_265)groundShapeSouth, (class_265[])shapesSouth.toArray(new class_265[0]));
        SHAPE_EAST = class_259.method_17786((class_265)groundShapeEast, (class_265[])shapesEast.toArray(new class_265[0]));
    }

    private static Map<String, class_265> getShapeFromJson(JsonObject object) {
        HashMap<String, class_265> shapes = new HashMap<String, class_265>();
        JsonArray from = object.get("from").getAsJsonArray();
        float x1 = from.get(0).getAsFloat();
        float y1 = from.get(1).getAsFloat();
        float z1 = from.get(2).getAsFloat();
        JsonArray to = object.getAsJsonArray("to").getAsJsonArray();
        float x2 = to.get(0).getAsFloat();
        float y2 = to.get(1).getAsFloat();
        float z2 = to.get(2).getAsFloat();
        shapes.put("NORTH", class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
        shapes.put("EAST", class_2248.method_9541((double)(16.0f - z2), (double)y1, (double)x1, (double)(16.0f - z1), (double)y2, (double)x2));
        shapes.put("SOUTH", class_2248.method_9541((double)(16.0f - x2), (double)y1, (double)(16.0f - z2), (double)(16.0f - x1), (double)y2, (double)(16.0f - z1)));
        shapes.put("WEST", class_2248.method_9541((double)z1, (double)y1, (double)(16.0f - x2), (double)z2, (double)y2, (double)(16.0f - x1)));
        return shapes;
    }

    public class_2464 method_9604(class_2680 state) {
        YigdConfig.GraveRenderSettings renderSettings = YigdConfig.getConfig().graveSettings.graveRenderSettings;
        if (renderSettings.useRenderFeatures && renderSettings.useSpecialBlockRenderer) {
            return class_2464.field_11455;
        }
        return class_2464.field_11458;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481, WATERLOGGED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2487 nbt;
        YigdConfig.GraveSettings config = YigdConfig.getConfig().graveSettings;
        RetrievalTypeConfig retrievalType = config.retrievalType;
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof GraveBlockEntity)) {
            return super.method_9534(state, world, pos, player, hand, hit);
        }
        GraveBlockEntity grave = (GraveBlockEntity)be;
        if (!(retrievalType != RetrievalTypeConfig.ON_USE && retrievalType != RetrievalTypeConfig.ON_BREAK_OR_USE && retrievalType != null || grave.getGraveOwner() == null || grave.isClaimed())) {
            if (!config.retrievalRequireShovel || player.method_6047().method_7909() instanceof class_1821) {
                this.RetrieveItems(player, world, pos);
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)new class_2588("text.yigd.message.requires_shovel"), false);
            return class_1269.field_5814;
        }
        if (grave.getGraveOwner() != null && grave.isClaimed() && !world.field_9236) {
            if (hand == class_1268.field_5810) {
                return class_1269.field_5811;
            }
            UUID graveId = grave.getGraveId();
            UUID ownerId = grave.getGraveOwner().getId();
            List<DeadPlayerData> graves = DeathInfoManager.INSTANCE.data.get(ownerId);
            if (graves != null) {
                for (DeadPlayerData data : graves) {
                    if (!graveId.equals(data.id)) continue;
                    player.method_7353(data.deathSource.method_5506((class_1309)player), false);
                    player.method_7353((class_2561)new class_2588("text.yigd.word.day", new Object[]{(int)(data.deathTime / 24000L)}), false);
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5814;
        }
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_7909() == class_1802.field_8575 && (nbt = heldItem.method_7969()) != null) {
            GameProfile gameProfile = null;
            if (nbt.method_10573("SkullOwner", 10)) {
                gameProfile = class_2512.method_10683((class_2487)nbt.method_10562("SkullOwner"));
            } else if (nbt.method_10573("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)nbt.method_10558("SkullOwner"))) {
                gameProfile = new GameProfile(null, nbt.method_10558("SkullOwner"));
            }
            if (gameProfile != null) {
                if (grave.getGraveSkull() != null) {
                    grave.dropCosmeticSkull();
                }
                grave.setGraveSkull(gameProfile);
                heldItem.method_7934(1);
                return class_1269.field_5812;
            }
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_1657 player;
        if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_STAND && entity instanceof class_1657) {
            class_1657 player2 = (class_1657)entity;
            this.RetrieveItems(player2, world, pos);
        } else if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_SNEAK && entity instanceof class_1657 && (player = (class_1657)entity).method_18276()) {
            this.RetrieveItems(player, world, pos);
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 be, class_1799 stack) {
        boolean bs;
        GraveBlockEntity graveBlockEntity;
        if (!(be instanceof GraveBlockEntity) || (graveBlockEntity = (GraveBlockEntity)be).getGraveOwner() == null) {
            super.method_9556(world, player, pos, state, be, stack);
            return;
        }
        if (graveBlockEntity.isClaimed()) {
            if (class_1890.method_8222((class_1799)stack).containsKey(class_1893.field_9099)) {
                class_1799 itemStack = new class_1799((class_1935)Yigd.GRAVE_BLOCK);
                class_2487 nbtCompound = new class_2487();
                class_2487 blockNbt = new class_2487();
                graveBlockEntity.method_11007(blockNbt);
                nbtCompound.method_10566("BlockEntityTag", (class_2520)blockNbt);
                itemStack.method_7980(nbtCompound);
                itemStack.method_7977(class_2561.method_30163((String)graveBlockEntity.getCustomName()));
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)itemStack);
            } else {
                super.method_9556(world, player, pos, state, be, stack);
            }
            return;
        }
        YigdConfig.GraveSettings config = YigdConfig.getConfig().graveSettings;
        RetrievalTypeConfig retrievalType = config.retrievalType;
        if (retrievalType == RetrievalTypeConfig.ON_BREAK || retrievalType == RetrievalTypeConfig.ON_BREAK_OR_USE) {
            if (!config.retrievalRequireShovel || stack.method_7909() instanceof class_1821) {
                if (this.RetrieveItems(player, world, pos, be)) {
                    return;
                }
            } else {
                player.method_7353((class_2561)new class_2588("text.yigd.message.requires_shovel"), false);
            }
        }
        if (bs = world.method_8501(pos, state)) {
            world.method_8438(be);
        } else {
            Yigd.LOGGER.warn("Did not manage to safely replace grave data at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + ". If grave contained items they've been deleted as no data was found");
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        Yigd.LOGGER.info("Grave at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + " was replaced with " + newState.method_26204());
        super.method_9536(state, world, pos, newState, moved);
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GraveBlockEntity) {
            boolean canRobGrave;
            GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
            YigdConfig.GraveSettings config = YigdConfig.getConfig().graveSettings;
            YigdConfig.GraveRobbing graveRobbing = config.graveRobbing;
            boolean bl = canRobGrave = graveRobbing.enableRobbing && (!graveRobbing.onlyMurderer || graveEntity.getKiller() == player.method_5667());
            if ((config.retrievalType == RetrievalTypeConfig.ON_BREAK || config.retrievalType == RetrievalTypeConfig.ON_BREAK_OR_USE) && (player.method_7334().equals((Object)graveEntity.getGraveOwner()) || canRobGrave) || graveEntity.getGraveOwner() == null || graveEntity.isClaimed()) {
                return super.method_9594(state, player, world, pos);
            }
        }
        return 0.0f;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (itemStack.method_7938()) {
            String customName = itemStack.method_7964().getString();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof GraveBlockEntity) {
                GraveBlockEntity graveBlockEntity = (GraveBlockEntity)blockEntity;
                graveBlockEntity.setCustomName(customName);
            }
        }
    }

    private class_265 getShape(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11043 -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11039 -> SHAPE_WEST;
            default -> class_259.method_1077();
        };
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ct) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        return this.getShape(dir);
    }

    public class_2680 method_9605(class_1750 context) {
        class_2338 blockPos = context.method_8037();
        class_3610 fluidState = context.method_8045().method_8316(blockPos);
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_8405().method_39363(class_6760.method_39410((Object)class_3612.field_15910, (class_2338)pos));
        }
        return direction.method_10166().method_10179() ? state : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return GraveBlock.method_31618(type, Yigd.GRAVE_BLOCK_ENTITY, GraveBlockEntity::tick);
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        return false;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GraveBlockEntity(pos, state);
    }

    private void RetrieveItems(class_1657 player, class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        this.RetrieveItems(player, world, pos, blockEntity);
    }

    private boolean RetrieveItems(class_1657 player, class_1937 world, class_2338 pos, class_2586 blockEntity) {
        class_1799 stack2;
        if (world.field_9236) {
            return false;
        }
        if (player == null || player.method_29504()) {
            return false;
        }
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return false;
        }
        GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
        if (graveEntity.isClaimed()) {
            return false;
        }
        GameProfile graveOwner = graveEntity.getGraveOwner();
        if (graveOwner == null) {
            return false;
        }
        if (graveEntity.getGraveOwner() != null && graveEntity.getGraveOwner().getId().equals(player.method_5667()) && graveEntity.creationTime + 20L >= world.method_8510()) {
            player.method_7353((class_2561)new class_2588("text.yigd.message.too_fast"), false);
            return false;
        }
        int xp = graveEntity.getStoredXp();
        class_2371<class_1799> items = graveEntity.getStoredInventory();
        if (items == null) {
            return false;
        }
        UUID playerId = player.method_5667();
        YigdConfig config = YigdConfig.getConfig();
        YigdConfig.GraveRobbing graveRobbing = config.graveSettings.graveRobbing;
        boolean canRobGrave = graveRobbing.enableRobbing && (!graveRobbing.onlyMurderer || graveEntity.getKiller() == playerId);
        boolean unlocked = config.graveSettings.unlockableGraves && DeathInfoManager.INSTANCE.unlockedGraves.contains(graveEntity.getGraveId());
        long creationTime = graveEntity.creationTime;
        long requiredTime = creationTime + (long)graveRobbing.afterTime * (long)graveRobbing.timeType.tickFactor();
        long currentTime = world.method_8510();
        boolean isRobbing = false;
        boolean timePassed = currentTime >= requiredTime || creationTime > currentTime + 20L;
        boolean isGraveOwner = player.method_7334().getId().equals(graveOwner.getId());
        if (!isGraveOwner) {
            if (!(canRobGrave && timePassed || unlocked)) {
                if (config.utilitySettings.graveKeySettings.enableKeys) {
                    class_1799 heldStack = player.method_6047();
                    isRobbing = KeyItem.isKeyForGrave(heldStack, graveEntity);
                }
                if (canRobGrave && !isRobbing) {
                    double timeRemaining = ((double)requiredTime - (double)currentTime) / 20.0;
                    int hours = (int)(timeRemaining / 3600.0);
                    int minutes = (int)((timeRemaining %= 3600.0) / 60.0);
                    int seconds = (int)(timeRemaining %= 60.0);
                    player.method_7353((class_2561)new class_2588("text.yigd.message.retrieve.rob_cooldown", new Object[]{hours, minutes, seconds}), true);
                } else {
                    player.method_7353((class_2561)new class_2588("text.yigd.message.retrieve.missing_permission"), true);
                }
                if (!isRobbing) {
                    return false;
                }
            } else {
                isRobbing = true;
            }
        } else if (config.utilitySettings.graveKeySettings.alwaysRequire && !KeyItem.isKeyForGrave(stack2 = player.method_6047(), graveEntity)) {
            player.method_7353((class_2561)new class_2588("text.yigd.message.retrieve.missing_key"), true);
            return false;
        }
        Map<String, Object> graveModItems = graveEntity.getModdedInventories();
        DeadPlayerData data = DeathInfoManager.findUserGrave(graveOwner.getId(), graveEntity.getGraveId());
        if (data != null) {
            data.availability = 0;
            data.claimedBy = player.method_7334();
            DeathInfoManager.INSTANCE.method_80();
            graveEntity.setClaimed(true);
            graveEntity.method_5431();
            world.method_8413(pos, world.method_8320(pos), world.method_8320(pos), 3);
        } else {
            Yigd.LOGGER.warn("Tried to change status of grave for %s (%s) at %s, but grave was not found".formatted(graveOwner.getName(), graveOwner.getId(), pos));
        }
        if (config.graveSettings.dropType == DropTypeConfig.ON_GROUND) {
            class_2371 itemList = class_2371.method_10211();
            itemList.addAll(items);
            for (YigdApi yigdApi : Yigd.apiMods) {
                Object o = graveModItems.get(yigdApi.getModName());
                itemList.addAll(yigdApi.toStackList(o));
                if (!(world instanceof class_3218)) continue;
                class_3218 sWorld = (class_3218)world;
                yigdApi.dropOnGround(o, sWorld, class_243.method_24954((class_2382)pos));
            }
            if (world instanceof class_3218) {
                class_3218 sWorld = (class_3218)world;
                class_1303.method_31493((class_3218)sWorld, (class_243)class_243.method_24954((class_2382)pos), (int)graveEntity.getStoredXp());
            }
            class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)itemList);
            if (config.graveSettings.dropGraveBlock) {
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)Yigd.GRAVE_BLOCK.method_8389().method_7854());
            }
            if (!config.graveSettings.persistGraves) {
                if (config.graveSettings.replaceWhenClaimed) {
                    world.method_8501(pos, graveEntity.getPreviousState());
                } else {
                    world.method_8650(pos, false);
                }
            }
            return true;
        }
        if (!config.graveSettings.persistGraves) {
            if (config.graveSettings.dropGraveBlock) {
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)Yigd.GRAVE_BLOCK.method_8389().method_7854());
            }
            if (config.graveSettings.replaceWhenClaimed) {
                world.method_8501(pos, graveEntity.getPreviousState());
            } else {
                world.method_8650(pos, false);
            }
        }
        if (config.graveSettings.randomSpawnSettings.percentSpawnChance > 0 && config.graveSettings.randomSpawnSettings.percentSpawnChance > new Random().nextInt(100)) {
            String res;
            Pattern pattern;
            Matcher matcher;
            Pattern nbtPattern;
            Matcher nbtMatcher;
            String summonNbt = config.graveSettings.randomSpawnSettings.spawnNbt.replace("${name}", graveOwner.getName()).replace("${uuid}", graveOwner.getId().toString());
            while ((nbtMatcher = (nbtPattern = Pattern.compile("\\$\\{item\\[[0-9]{1,3}]}")).matcher(summonNbt)).find() && (matcher = (pattern = Pattern.compile("(?<=\\$\\{item\\[)[0-9]{1,3}(?=]})")).matcher(summonNbt)).find() && (res = matcher.group()).matches("[0-9]*")) {
                int itemNumber = Integer.parseInt(res);
                class_1799 item = (class_1799)items.get(itemNumber);
                class_2487 itemNbt = item.method_7969();
                class_2487 newNbt = new class_2487();
                newNbt.method_10566("tag", (class_2520)itemNbt);
                newNbt.method_10582("id", class_2378.field_11142.method_10221((Object)item.method_7909()).toString());
                newNbt.method_10569("Count", item.method_7947());
                boolean removeItem = summonNbt.contains("${!item[" + itemNumber + "]}");
                summonNbt = summonNbt.replaceAll("\\$\\{!?item\\[" + itemNumber + "]}", newNbt.method_10714());
                if (removeItem) {
                    items.set(itemNumber, (Object)class_1799.field_8037);
                }
                if (nbtMatcher.find()) continue;
            }
            try {
                class_2487 nbt = class_2512.method_32260((String)summonNbt);
                nbt.method_10582("id", config.graveSettings.randomSpawnSettings.spawnEntity);
                class_1297 entity = class_1299.method_17842((class_2487)nbt, (class_1937)world, e -> {
                    e.method_5725(pos, e.method_36454(), e.method_36455());
                    return e;
                });
                world.method_8649(entity);
            }
            catch (Exception e2) {
                Yigd.LOGGER.error("Failed spawning entity at grave", (Throwable)e2);
            }
        }
        if (config.utilitySettings.graveCompassSettings.tryDeleteOnClaim) {
            player.method_31548().method_29280(stack -> {
                class_2487 nbt = stack.method_7948();
                if (!nbt.method_10545("forGrave")) {
                    return false;
                }
                UUID graveId = nbt.method_25926("forGrave");
                return stack.method_31574(class_1802.field_8251) && graveEntity.getGraveId().equals(graveId);
            }, 1, (class_1263)player.method_31548());
        }
        String playerName = player.method_7334().getName();
        Yigd.LOGGER.info(playerName + " is retrieving " + (isRobbing ? "someone else's" : "their") + " grave at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260());
        MinecraftServer server = world.method_8503();
        if (isRobbing && server != null) {
            UUID ownerId = graveOwner.getId();
            class_3222 robbedPlayer = server.method_3760().method_14602(ownerId);
            if (config.graveSettings.graveRobbing.notifyWhenRobbed) {
                if (robbedPlayer != null) {
                    if (config.graveSettings.graveRobbing.tellRobber) {
                        robbedPlayer.method_7353((class_2561)new class_2588("text.yigd.message.robbed_by", new Object[]{playerName}), false);
                    } else {
                        robbedPlayer.method_7353((class_2561)new class_2588("text.yigd.message.robbed"), false);
                    }
                } else {
                    Yigd.notNotifiedRobberies.put(ownerId, playerName);
                }
            }
        }
        GraveHelper.RetrieveItems(player, items, graveModItems, xp, isRobbing);
        return true;
    }

    static {
        FACING = class_2383.field_11177;
        SHAPE_BASE_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_NORTH = class_2248.method_9541((double)2.0, (double)1.0, (double)10.0, (double)14.0, (double)3.0, (double)15.0);
        SHAPE_CORE_NORTH = class_2248.method_9541((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)15.0, (double)14.0);
        SHAPE_TOP_NORTH = class_2248.method_9541((double)4.0, (double)15.0, (double)11.0, (double)12.0, (double)16.0, (double)14.0);
        SHAPE_BASE_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_EAST = class_2248.method_9541((double)1.0, (double)1.0, (double)2.0, (double)6.0, (double)3.0, (double)14.0);
        SHAPE_CORE_EAST = class_2248.method_9541((double)2.0, (double)3.0, (double)3.0, (double)5.0, (double)15.0, (double)13.0);
        SHAPE_TOP_EAST = class_2248.method_9541((double)2.0, (double)15.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0);
        SHAPE_BASE_WEST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_WEST = class_2248.method_9541((double)10.0, (double)1.0, (double)2.0, (double)15.0, (double)3.0, (double)14.0);
        SHAPE_CORE_WEST = class_2248.method_9541((double)11.0, (double)3.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0);
        SHAPE_TOP_WEST = class_2248.method_9541((double)11.0, (double)15.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0);
        SHAPE_BASE_SOUTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_SOUTH = class_2248.method_9541((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)3.0, (double)6.0);
        SHAPE_CORE_SOUTH = class_2248.method_9541((double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)15.0, (double)5.0);
        SHAPE_TOP_SOUTH = class_2248.method_9541((double)4.0, (double)15.0, (double)2.0, (double)12.0, (double)16.0, (double)5.0);
        SHAPE_NORTH = class_259.method_17786((class_265)SHAPE_BASE_NORTH, (class_265[])new class_265[]{SHAPE_FOOT_NORTH, SHAPE_CORE_NORTH, SHAPE_TOP_NORTH});
        SHAPE_WEST = class_259.method_17786((class_265)SHAPE_BASE_WEST, (class_265[])new class_265[]{SHAPE_FOOT_WEST, SHAPE_CORE_WEST, SHAPE_TOP_WEST});
        SHAPE_EAST = class_259.method_17786((class_265)SHAPE_BASE_EAST, (class_265[])new class_265[]{SHAPE_FOOT_EAST, SHAPE_CORE_EAST, SHAPE_TOP_EAST});
        SHAPE_SOUTH = class_259.method_17786((class_265)SHAPE_BASE_SOUTH, (class_265[])new class_265[]{SHAPE_FOOT_SOUTH, SHAPE_CORE_SOUTH, SHAPE_TOP_SOUTH});
        WATERLOGGED = class_2741.field_12508;
    }
}

