/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class QueuedTooltip
implements Tooltip {
    private Point location;
    private List<TooltipEntryImpl> entries;
    private EntryStack<?> stack = EntryStack.empty();

    private QueuedTooltip(Point location, Collection<? extends Tooltip.Entry> entries) {
        this.location = location;
        if (this.location == null) {
            this.location = PointHelper.ofMouse();
        }
        this.entries = Lists.newArrayList(entries);
    }

    public static QueuedTooltip impl(Point location, Collection<Tooltip.Entry> text) {
        return new QueuedTooltip(location, text);
    }

    @Override
    public int getX() {
        return this.location.x;
    }

    @Override
    public int getY() {
        return this.location.y;
    }

    @Override
    public List<Tooltip.Entry> entries() {
        return this.entries;
    }

    @Override
    public List<class_5632> components() {
        return CollectionUtils.filterAndMap(this.entries, TooltipEntryImpl::isTooltipComponent, TooltipEntryImpl::getAsTooltipComponent);
    }

    @Override
    public Tooltip add(class_2561 text) {
        this.entries.add(new TooltipEntryImpl(text));
        return this;
    }

    @Override
    public Tooltip add(class_5684 component) {
        this.entries.add(new TooltipEntryImpl(component));
        return this;
    }

    @Override
    public Tooltip add(class_5632 component) {
        this.entries.add(new TooltipEntryImpl(component));
        return this;
    }

    @Override
    public void queue() {
        Tooltip.super.queue();
    }

    @Override
    public Tooltip copy() {
        QueuedTooltip tooltip = new QueuedTooltip(this.location.clone(), this.entries);
        tooltip.withContextStack(this.getContextStack());
        return tooltip;
    }

    @Override
    public EntryStack<?> getContextStack() {
        return this.stack;
    }

    @Override
    public Tooltip withContextStack(EntryStack<?> stack) {
        this.stack = stack.copy();
        return this;
    }

    public record TooltipEntryImpl(Object obj) implements Tooltip.Entry
    {
        @Override
        public class_2561 getAsText() {
            return (class_2561)this.obj;
        }

        @Override
        public boolean isText() {
            return this.obj instanceof class_2561;
        }

        @Override
        public boolean isTooltipComponent() {
            return this.obj instanceof class_5632;
        }

        @Override
        public class_5632 getAsTooltipComponent() {
            return (class_5632)this.obj;
        }

        @Override
        public class_5684 getAsComponent() {
            if (this.obj instanceof class_5684) {
                return (class_5684)this.obj;
            }
            if (this.isTooltipComponent()) {
                return class_5684.method_32663((class_5632)((class_5632)this.obj));
            }
            return (class_5684)this.obj;
        }

        public boolean isClientComponent() {
            return this.obj instanceof class_5684;
        }
    }
}

