/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.options;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ComparableValue<T> {
    private final T value;
    private final BiPredicate<T, Object> equals;

    private ComparableValue(T value, BiPredicate<T, Object> equals) {
        this.value = value;
        this.equals = equals;
    }

    public static <T> ComparableValue<T> of(T value, BiPredicate<T, Object> equals) {
        return new ComparableValue<T>(value, equals);
    }

    public static ComparableValue<Float> ofFloat(float value) {
        return ComparableValue.of(Float.valueOf(value), (a, b) -> {
            if (!(b instanceof Float)) return false;
            Float f = (Float)b;
            if (!(Math.abs(a.floatValue() - f.floatValue()) <= 0.001f)) return false;
            return true;
        });
    }

    public static ComparableValue<Double> ofDouble(double value) {
        return ComparableValue.of(value, (a, b) -> {
            if (!(b instanceof Double)) return false;
            Double d = (Double)b;
            if (!(Math.abs(a - d) <= 0.001)) return false;
            return true;
        });
    }

    public T value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComparableValue) {
            return this.equals.test(this.value, ((ComparableValue)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

