/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigOptionValueWidget;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigOptions;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import net.minecraft.class_1159;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class ConfigOptionWidget {
    public static <T> WidgetWithBounds create(final ConfigAccess access, final CompositeOption<T> option, final int width) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        final int[] stableHeight = new int[]{12};
        final int[] height = new int[]{12};
        Label fieldNameLabel = Widgets.createLabel(new Point(0, 0), (class_2561)TextTransformations.highlightText(option.getName().method_27661(), option.getOptionNameHighlight(), style -> style.method_36139(-4144960))).leftAligned().rainbow(Objects.equals(option.getId(), AllREIConfigOptions.RAINBOW.getId()));
        widgets.add(fieldNameLabel);
        WidgetWithBounds optionValue = ConfigOptionValueWidget.create(access, option, width - 10 - fieldNameLabel.getBounds().width);
        widgets.add(Widgets.withTranslate((Widget)optionValue, () -> class_1159.method_24021((float)(width - optionValue.getBounds().width - optionValue.getBounds().x), (float)0.0f, (float)0.0f)));
        widgets.add(new WidgetWithBounds(){
            final class_5250 description = (class_5250)class_156.method_656(() -> {
                class_5250 description = option.getDescription().method_27661();
                if (description.getString().endsWith(".desc")) {
                    return ConfigUtils.literal("");
                }
                return TextTransformations.highlightText(description, option.getOptionDescriptionHighlight(), style -> style.method_36139(-9079435));
            });
            final List<class_5481> split;
            final boolean hasPreview;
            final Label previewLabel;
            @Nullable
            WidgetWithBounds preview;
            boolean previewVisible;
            class_1159 previewTranslation;
            final NumberAnimator<Float> previewHeight;
            boolean nextLinePreview;
            {
                int lastWidth;
                this.split = class_310.method_1551().field_1772.method_1728((class_5348)this.description, width);
                this.hasPreview = option.hasPreview();
                this.previewLabel = Widgets.createLabel(new Point(), (class_2561)ConfigUtils.translatable("config.rei.texts.preview")).color(-5901057).hoveredColor(-3015937).noShadow().clickable().onClick($ -> this.clickPreview()).rightAligned();
                this.preview = null;
                this.previewVisible = false;
                this.previewTranslation = new class_1159();
                this.previewHeight = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(this.previewVisible ? (float)this.preview.getBounds().getHeight() : 0.0f), ValueAnimator.typicalTransitionTime());
                this.nextLinePreview = false;
                stableHeight[0] = stableHeight[0] + 12 * this.split.size();
                if (this.hasPreview && (lastWidth = class_310.method_1551().field_1772.method_30880(this.split.get(this.split.size() - 1))) + this.previewLabel.getBounds().width + 10 > width) {
                    this.nextLinePreview = true;
                    stableHeight[0] = stableHeight[0] + 12;
                }
            }

            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, 12, width, 12 + 12 * this.split.size());
            }

            public void method_25394(class_4587 poses, int mouseX, int mouseY, float delta) {
                this.previewHeight.update((double)delta);
                if (ConfigUtils.isReducedMotion()) {
                    this.previewHeight.completeImmediately();
                }
                height[0] = stableHeight[0] + Math.round(((Float)this.previewHeight.value()).floatValue());
                for (int i = 0; i < this.split.size(); ++i) {
                    class_310.method_1551().field_1772.method_27528(poses, this.split.get(i), 0.0f, (float)(12 + 12 * i), -1);
                }
                if (this.hasPreview) {
                    if (this.nextLinePreview) {
                        this.previewLabel.setPoint(new Point(width, 12 + 12 * this.split.size()));
                    } else {
                        this.previewLabel.setPoint(new Point(width, 12 + 12 * this.split.size() - 12));
                    }
                    this.previewLabel.method_25394(poses, mouseX, mouseY, delta);
                    if (this.preview != null && ((Float)this.previewHeight.value()).floatValue() > 0.1f) {
                        ScissorsHandler.INSTANCE.scissor(MatrixUtils.transform(poses.method_23760().method_23761(), new Rectangle(0.0, (double)(24 + 12 * this.split.size() - (this.nextLinePreview ? 0 : 12)), (double)width, (double)((Float)this.previewHeight.value()).floatValue())));
                        this.previewTranslation = class_1159.method_24021((float)0.0f, (float)(12 + 12 * this.split.size()), (float)100.0f);
                        this.preview.method_25394(poses, mouseX, mouseY, delta);
                        ScissorsHandler.INSTANCE.removeLastScissor();
                    }
                }
            }

            private void clickPreview() {
                if (this.preview == null) {
                    this.preview = option.getPreviewer().preview(width, () -> access.get(option));
                    this.preview = Widgets.withTranslate((Widget)this.preview, () -> this.previewTranslation);
                }
                this.previewVisible = !this.previewVisible;
            }

            public List<? extends class_364> method_25396() {
                if (this.preview != null && ((Float)this.previewHeight.value()).floatValue() > 0.1f) {
                    return List.of(this.previewLabel, this.preview);
                }
                return List.of(this.previewLabel);
            }
        });
        height[0] = stableHeight[0];
        return Widgets.concatWithBounds(() -> new Rectangle(0, 0, width, height[0]), widgets);
    }
}

