/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.components;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigOptionWidget;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigGroups;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.OptionGroup;
import me.shedaniel.rei.impl.client.gui.config.options.preview.AccessibilityDisplayPreviewer;
import me.shedaniel.rei.impl.client.gui.config.options.preview.InterfacePreviewer;
import me.shedaniel.rei.impl.client.gui.config.options.preview.TooltipPreviewer;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ConfigGroupWidget {
    private static final Map<String, Pair<PreviewLocation, SpecialGroupConstructor>> SPECIAL_GROUPS = new HashMap<String, Pair<PreviewLocation, SpecialGroupConstructor>>();

    public static void addPreview(OptionGroup group, PreviewLocation location, SpecialGroupConstructor constructor) {
        SPECIAL_GROUPS.put(group.getId(), (Pair<PreviewLocation, SpecialGroupConstructor>)Pair.of((Object)((Object)location), (Object)constructor));
    }

    public static WidgetWithBounds create(ConfigAccess access, OptionGroup entry, int width, boolean applyPreview) {
        WidgetWithBounds contents;
        WidgetWithBounds groupTitle = Widgets.createLabel(new Point(0, 3), (class_2561)TextTransformations.highlightText(entry.getGroupName().method_27661(), entry.getGroupNameHighlight(), style -> style.method_36139(-4144960).method_30938(Boolean.valueOf(true)))).leftAligned().withPadding(0, 0, 0, 6);
        if (applyPreview) {
            boolean bl = applyPreview = REIRuntime.getInstance().getPreviousContainerScreen() != null && class_310.method_1551().method_1562() != null && class_310.method_1551().method_1562().method_2877() != null;
        }
        if (applyPreview && SPECIAL_GROUPS.containsKey(entry.getId())) {
            Pair<PreviewLocation, SpecialGroupConstructor> pair = SPECIAL_GROUPS.get(entry.getId());
            PreviewLocation location = (PreviewLocation)((Object)pair.getLeft());
            int halfWidth = width * 6 / 10 - 2;
            if (halfWidth <= 200 && location == PreviewLocation.RIGHT) {
                location = PreviewLocation.TOP;
            }
            if (location == PreviewLocation.RIGHT) {
                WidgetWithBounds original = ConfigGroupWidget._create(access, entry, halfWidth);
                Widget background = ConfigGroupWidget.createBackgroundSlot(() -> new Rectangle(halfWidth + 2, 0, width - halfWidth - 4, original.getBounds().height));
                WidgetWithBounds right = Widgets.withTranslate(((SpecialGroupConstructor)pair.getRight()).create(access, entry, width - halfWidth - 4, () -> original.getBounds().height), halfWidth + 2, 0.0, 0.0);
                contents = Widgets.concatWithBounds(() -> new Rectangle(0, 0, width, original.getBounds().height), original, background, right);
            } else {
                WidgetWithBounds original = ConfigGroupWidget._create(access, entry, width);
                WidgetWithBounds widget = ((SpecialGroupConstructor)pair.getRight()).create(access, entry, width, null);
                Widget background = ConfigGroupWidget.createBackgroundSlot(widget::getBounds);
                if (location == PreviewLocation.TOP) {
                    WidgetWithBounds translatedOriginal = Widgets.withTranslate((Widget)original, () -> class_1159.method_24021((float)0.0f, (float)(widget.getBounds().height + 4), (float)0.0f));
                    contents = Widgets.concatWithBounds(() -> new Rectangle(0, 0, width, widget.getBounds().height + 4 + translatedOriginal.getBounds().height), translatedOriginal, background, widget);
                } else {
                    contents = Widgets.concatWithBounds(() -> new Rectangle(0, 0, width, original.getBounds().getMaxY() + 2 + widget.getBounds().height), original, Widgets.withTranslate(Widgets.concat(background, widget), () -> class_1159.method_24021((float)0.0f, (float)(original.getBounds().getMaxY() + 4), (float)0.0f)));
                }
            }
        } else {
            contents = ConfigGroupWidget._create(access, entry, width);
        }
        return Widgets.concatWithBounds(() -> new Rectangle(0, 0, width, groupTitle.getBounds().getMaxY() + contents.getBounds().height), groupTitle, Widgets.withTranslate((Widget)contents, () -> class_1159.method_24021((float)0.0f, (float)groupTitle.getBounds().getMaxY(), (float)0.0f)));
    }

    private static WidgetWithBounds _create(ConfigAccess access, OptionGroup entry, int width) {
        final ArrayList<WidgetComposite> widgets = new ArrayList<WidgetComposite>();
        int[] height = new int[]{0};
        for (CompositeOption<?> option : entry.getOptions()) {
            widgets.add(WidgetComposite.of(ConfigOptionWidget.create(access, option, width)));
            if (entry.getOptions().get(entry.getOptions().size() - 1) == option) continue;
            Widget separator = Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                for (int x = 0; x <= width; x += 4) {
                    class_332.method_25294((class_4587)matrices, (int)Math.min(width, x), (int)1, (int)Math.min(width, x + 2), (int)2, (int)-9079435);
                }
            });
            widgets.add(WidgetComposite.of(Widgets.withBounds(separator, new Rectangle(0, 0, 1, 7))));
        }
        widgets.add(WidgetComposite.ofNonAccounting(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> ConfigGroupWidget.recalculateHeight(widgets, i -> {
            height[0] = i;
        }))));
        ConfigGroupWidget.recalculateHeight(widgets, i -> {
            height[0] = i;
        });
        return Widgets.concatWithBounds(() -> new Rectangle(0, 0, width, height[0]), (List<Widget>)new AbstractList<Widget>(){

            @Override
            public Widget get(int index) {
                return ((WidgetComposite)widgets.get(index)).widget();
            }

            @Override
            public int size() {
                return widgets.size();
            }
        });
    }

    private static void recalculateHeight(List<WidgetComposite> widgets, IntConsumer setHeight) {
        int height = 0;
        for (WidgetComposite widget : widgets) {
            widget.translation().method_35434(class_1159.method_24021((float)0.0f, (float)height, (float)0.0f));
            height = Math.max(height, widget.bounds().get().getMaxY());
        }
        setHeight.accept(height);
    }

    private static Widget createBackgroundSlot(Supplier<Rectangle> bounds) {
        return Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            Rectangle rectangle = (Rectangle)bounds.get();
            class_332.method_25294((class_4587)matrices, (int)rectangle.x, (int)rectangle.y, (int)rectangle.getMaxX(), (int)rectangle.getMaxY(), (int)-13421773);
            class_332.method_25294((class_4587)matrices, (int)(rectangle.x + 1), (int)(rectangle.y + 1), (int)(rectangle.getMaxX() - 1), (int)(rectangle.getMaxY() - 1), (int)-16777216);
        });
    }

    static {
        ConfigGroupWidget.addPreview(AllREIConfigGroups.APPEARANCE_INTERFACE, PreviewLocation.RIGHT, (access, entry, width, height) -> InterfacePreviewer.create(access, width, height));
        ConfigGroupWidget.addPreview(AllREIConfigGroups.APPEARANCE_TOOLTIPS, PreviewLocation.RIGHT, (access, entry, width, height) -> TooltipPreviewer.create(access, width, height));
        ConfigGroupWidget.addPreview(AllREIConfigGroups.ACCESSIBILITY_DISPLAY, PreviewLocation.BOTTOM, (access, entry, width, height) -> AccessibilityDisplayPreviewer.create(access, width));
    }

    public static enum PreviewLocation {
        RIGHT,
        TOP,
        BOTTOM;

    }

    @FunctionalInterface
    public static interface SpecialGroupConstructor {
        public WidgetWithBounds create(ConfigAccess var1, OptionGroup var2, int var3, @Nullable IntSupplier var4);
    }

    private record WidgetComposite(Widget widget, Supplier<Rectangle> bounds, class_1159 translation) {
        public static WidgetComposite of(WidgetWithBounds widget) {
            class_1159 translation = new class_1159();
            return new WidgetComposite(Widgets.withTranslate((Widget)widget, translation), () -> MatrixUtils.transform(translation, widget.getBounds()), translation);
        }

        public static WidgetComposite ofNonAccounting(Widget widget) {
            return new WidgetComposite(widget, Rectangle::new, new class_1159());
        }
    }
}

