/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.util;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.data.Planet;
import com.github.alexnijjar.ad_astra.entities.vehicles.LanderEntity;
import com.github.alexnijjar.ad_astra.entities.vehicles.RocketEntity;
import com.github.alexnijjar.ad_astra.entities.vehicles.VehicleEntity;
import com.github.alexnijjar.ad_astra.items.vehicles.VehicleItem;
import com.github.alexnijjar.ad_astra.registry.ModCriteria;
import com.github.alexnijjar.ad_astra.registry.ModEntityTypes;
import com.github.alexnijjar.ad_astra.registry.ModTags;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.github.alexnijjar.ad_astra.util.algorithms.LandFinder;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3862;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_6862;

public class ModUtils {
    public static final class_5321<class_1937> MOON_KEY = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new ModIdentifier("moon"));
    public static final class_5321<class_1937> MARS_KEY = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new ModIdentifier("mars"));
    public static final class_5321<class_1937> VENUS_KEY = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new ModIdentifier("venus"));
    public static final class_5321<class_1937> MERCURY_KEY = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new ModIdentifier("mercury"));
    public static final class_5321<class_1937> GLACIO_KEY = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new ModIdentifier("glacio"));
    public static final float VANILLA_GRAVITY = 9.806f;
    public static final float ORBIT_TEMPERATURE = -270.0f;

    public static boolean modLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static void teleportToWorld(class_5321<class_1937> targetWorld, class_1297 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 oldWorld = (class_3218)class_19372;
            class_3218 world = oldWorld.method_8503().method_3847(targetWorld);
            LinkedHashSet<Object> entitiesToTeleport = new LinkedHashSet<Object>();
            class_243 targetPos = new class_243(entity.method_23317(), (double)AdAstra.CONFIG.rocket.atmosphereLeave, entity.method_23321());
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                class_1297 class_12972 = player.method_5854();
                if (class_12972 instanceof RocketEntity) {
                    RocketEntity rocket = (RocketEntity)class_12972;
                    player.method_7353((class_2561)new class_2588("message.ad_astra.hold_space"), false);
                    entity = ModUtils.createLander(rocket, world, targetPos);
                    rocket.method_31472();
                    entitiesToTeleport.add(entity);
                    entitiesToTeleport.add(player);
                } else if (player.method_5854() == null || player.method_5854().method_5685().size() <= 0) {
                    entitiesToTeleport.add(entity);
                }
            } else {
                entitiesToTeleport.add(entity);
            }
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                ModUtils.cookFood(itemEntity);
            }
            entitiesToTeleport.addAll(entity.method_5685());
            for (Object entityToTeleport : entitiesToTeleport) {
                if (!(entityToTeleport instanceof class_3222)) continue;
                class_1923 class_19232 = new class_1923(new class_2338(targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215()));
                world.method_14178().method_17297(class_3230.field_19347, class_19232, 1, (Object)entityToTeleport.method_5628());
                break;
            }
            LinkedList<class_1297> teleportedEntities = new LinkedList<class_1297>();
            for (class_1297 class_12972 : entitiesToTeleport) {
                class_5454 target = new class_5454(targetPos, class_12972.method_18798(), class_12972.method_36454(), class_12972.method_36455());
                teleportedEntities.add(FabricDimensions.teleport((class_1297)class_12972, (class_3218)world, (class_5454)target));
            }
            class_1297 first = (class_1297)teleportedEntities.poll();
            if (first instanceof LanderEntity) {
                class_243 class_2432 = LandFinder.findNearestLand(first.method_37908(), new class_243(first.method_23317(), (double)AdAstra.CONFIG.rocket.atmosphereLeave, first.method_23321()), 70);
                first.method_5808(class_2432.method_10216(), class_2432.method_10214(), class_2432.method_10215(), first.method_36454(), first.method_36455());
            }
            for (class_1297 teleportedEntity : teleportedEntities) {
                if (first instanceof LanderEntity) {
                    class_243 nearestLand = LandFinder.findNearestLand(teleportedEntity.method_37908(), new class_243(teleportedEntity.method_23317(), (double)AdAstra.CONFIG.rocket.atmosphereLeave, teleportedEntity.method_23321()), 70);
                    teleportedEntity.method_5808(nearestLand.method_10216(), nearestLand.method_10214(), nearestLand.method_10215(), teleportedEntity.method_36454(), teleportedEntity.method_36455());
                }
                teleportedEntity.method_5873(first, true);
            }
        }
    }

    public static void teleportPlayer(class_5321<class_1937> targetWorld, class_3222 player) {
        class_3218 world = player.method_5682().method_3847(targetWorld);
        class_243 targetPos = new class_243((double)player.method_24515().method_10263(), (double)AdAstra.CONFIG.rocket.atmosphereLeave, (double)player.method_24515().method_10260());
        class_1923 chunkPos = new class_1923(new class_2338(targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215()));
        world.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)player.method_5628());
        class_5454 target = new class_5454(targetPos, player.method_18798(), player.method_36454(), player.method_36455());
        player = (class_3222)FabricDimensions.teleport((class_1297)player, (class_3218)world, (class_5454)target);
    }

    public static LanderEntity createLander(RocketEntity rocket, class_3218 targetWorld, class_243 target) {
        LanderEntity lander = new LanderEntity(ModEntityTypes.LANDER, (class_1937)targetWorld);
        lander.method_33574(target);
        for (int i = 0; i < rocket.getInventorySize(); ++i) {
            lander.getInventory().method_5447(i, rocket.getInventory().method_5438(i));
        }
        class_1799 stack = rocket.getDropStack();
        ((VehicleItem)stack.method_7909()).setFluid(stack, rocket.getFluidVariant());
        ((VehicleItem)stack.method_7909()).setAmount(stack, rocket.getFluidAmount());
        lander.getInventory().method_5447(10, stack);
        targetWorld.method_8649((class_1297)lander);
        return lander;
    }

    public static void cookFood(class_1542 itemEntity) {
        class_1799 stack = itemEntity.method_6983();
        class_1799 foodOutput = null;
        for (class_3862 recipe : itemEntity.method_37908().method_8433().method_30027(class_3956.field_17548)) {
            for (class_1856 ingredient : recipe.method_8117()) {
                if (!ingredient.method_8093(stack)) continue;
                foodOutput = recipe.method_8110();
            }
        }
        if (foodOutput != null) {
            itemEntity.method_6979(new class_1799((class_1935)foodOutput.method_7909(), stack.method_7947()));
            class_3222 playerEntity = (class_3222)itemEntity.field_6002.method_18470(itemEntity.method_6978());
            if (playerEntity != null) {
                ModCriteria.FOOD_COOKED_IN_ATMOSPHERE.trigger(playerEntity);
            }
        }
    }

    public static class_5321<class_1937> getPlanetOrbit(class_1937 world) {
        return AdAstra.planets.stream().filter(p -> p.orbitWorld().equals((Object)world.method_27983())).map(Planet::world).findFirst().orElse(class_1937.field_25179);
    }

    public static float getPlanetGravity(class_1937 world) {
        if (!ModUtils.isSpaceWorld(world)) {
            return 1.0f;
        }
        if (ModUtils.isOrbitWorld(world)) {
            return 0.30593514f;
        }
        return AdAstra.planets.stream().filter(p -> p.world().equals((Object)world.method_27983())).map(Planet::gravity).findFirst().orElse(Float.valueOf(9.806f)).floatValue() / 9.806f;
    }

    public static boolean planetHasAtmosphere(class_1937 world) {
        return AdAstra.planets.stream().filter(p -> p.world().equals((Object)world.method_27983())).map(Planet::hasAtmosphere).findFirst().orElse(false);
    }

    public static float getWorldTemperature(class_1937 world) {
        if (ModUtils.isOrbitWorld(world)) {
            return -270.0f;
        }
        return AdAstra.planets.stream().filter(p -> p.world().equals((Object)world.method_27983())).map(Planet::temperature).findFirst().orElse(Float.valueOf(20.0f)).floatValue();
    }

    public static boolean isSpaceWorld(class_1937 world) {
        return ModUtils.isPlanet(world) || ModUtils.isOrbitWorld(world);
    }

    public static boolean isPlanet(class_1937 world) {
        if (class_1937.field_25179.equals(world.method_27983())) {
            return false;
        }
        return AdAstra.planetWorlds.contains(world.method_27983());
    }

    public static boolean isOrbitWorld(class_1937 world) {
        return AdAstra.orbitWorlds.contains(world.method_27983());
    }

    public static <T extends class_2394> void spawnForcedParticles(class_3218 world, T particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        for (class_3222 player : world.method_18456()) {
            world.method_14166(player, particle, true, x, y, z, count, deltaX, deltaY, deltaZ, speed);
        }
    }

    public static void rotateVehicleYaw(VehicleEntity vehicle, float newYaw) {
        vehicle.method_36456(newYaw);
        vehicle.method_5636(newYaw);
        vehicle.field_5982 = newYaw;
    }

    public static boolean checkTag(class_1297 entity, class_6862<class_1299<?>> tag) {
        return entity.method_5864().method_20210(tag);
    }

    public static boolean checkTag(class_1799 stack, class_6862<class_1792> tag) {
        return stack.method_31573(tag);
    }

    public static boolean armourIsFreezeResistant(class_1309 entity) {
        return StreamSupport.stream(entity.method_5661().spliterator(), false).allMatch(s -> s.method_31573(ModTags.FREEZE_RESISTANT));
    }

    public static boolean armourIsHeatResistant(class_1309 entity) {
        return StreamSupport.stream(entity.method_5661().spliterator(), false).allMatch(s -> s.method_31573(ModTags.HEAT_RESISTANT));
    }

    public static boolean armourIsOxygenated(class_1309 entity) {
        return StreamSupport.stream(entity.method_5661().spliterator(), false).allMatch(s -> s.method_31573(ModTags.OXYGENATED_ARMOR));
    }

    public static long getSolarEnergy(class_1937 world) {
        if (ModUtils.isOrbitWorld(world)) {
            return AdAstra.planets.stream().filter(p -> p.orbitWorld().equals((Object)world.method_27983())).map(Planet::orbitSolarPower).findFirst().orElse(15L);
        }
        if (ModUtils.isPlanet(world)) {
            return AdAstra.planets.stream().filter(p -> p.world().equals((Object)world.method_27983())).map(Planet::solarPower).findFirst().orElse(15L);
        }
        return 15L;
    }
}

