/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.util;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.client.registry.ClientModKeybindings;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_310;

public class ModKeyBindings {
    public static final HashMap<UUID, ModKeyBindings> PLAYER_KEYS = new HashMap();
    private boolean clickingJump;
    private boolean clickingSprint;
    private boolean clickingForward;
    private boolean clickingBack;
    private boolean clickingLeft;
    private boolean clickingRight;

    public static boolean jumpKeyDown(class_1657 player) {
        return player.field_6002.field_9236 ? ModKeyBindings.getClientKeyPressed(player, Key.JUMP) : ModKeyBindings.getServerKeyPressed(player, Key.JUMP);
    }

    public static boolean sprintKeyDown(class_1657 player) {
        return player.field_6002.field_9236 ? ModKeyBindings.getClientKeyPressed(player, Key.SPRINT) : ModKeyBindings.getServerKeyPressed(player, Key.SPRINT);
    }

    public static boolean forwardKeyDown(class_1657 player) {
        return player.field_6002.field_9236 ? ModKeyBindings.getClientKeyPressed(player, Key.FORWARD) : ModKeyBindings.getServerKeyPressed(player, Key.FORWARD);
    }

    public static boolean backKeyDown(class_1657 player) {
        return player.field_6002.field_9236 ? ModKeyBindings.getClientKeyPressed(player, Key.BACK) : ModKeyBindings.getServerKeyPressed(player, Key.BACK);
    }

    public static boolean leftKeyDown(class_1657 player) {
        return player.field_6002.field_9236 ? ModKeyBindings.getClientKeyPressed(player, Key.LEFT) : ModKeyBindings.getServerKeyPressed(player, Key.LEFT);
    }

    public static boolean rightKeyDown(class_1657 player) {
        return player.field_6002.field_9236 ? ModKeyBindings.getClientKeyPressed(player, Key.RIGHT) : ModKeyBindings.getServerKeyPressed(player, Key.RIGHT);
    }

    private static boolean getServerKeyPressed(class_1657 player, Key key) {
        PLAYER_KEYS.putIfAbsent(player.method_5667(), new ModKeyBindings());
        return switch (key) {
            case Key.JUMP -> ModKeyBindings.PLAYER_KEYS.get((Object)player.method_5667()).clickingJump;
            case Key.SPRINT -> ModKeyBindings.PLAYER_KEYS.get((Object)player.method_5667()).clickingSprint;
            case Key.FORWARD -> ModKeyBindings.PLAYER_KEYS.get((Object)player.method_5667()).clickingForward;
            case Key.BACK -> ModKeyBindings.PLAYER_KEYS.get((Object)player.method_5667()).clickingBack;
            case Key.LEFT -> ModKeyBindings.PLAYER_KEYS.get((Object)player.method_5667()).clickingLeft;
            case Key.RIGHT -> ModKeyBindings.PLAYER_KEYS.get((Object)player.method_5667()).clickingRight;
            default -> {
                AdAstra.LOGGER.warn("Invalid Keypress on server: " + key);
                yield false;
            }
        };
    }

    @Environment(value=EnvType.CLIENT)
    private static boolean getClientKeyPressed(class_1657 player, Key key) {
        class_310 client = class_310.method_1551();
        if (!player.method_5667().equals(client.field_1724.method_5667())) {
            return false;
        }
        return switch (key) {
            case Key.JUMP -> ClientModKeybindings.clickingJump;
            case Key.SPRINT -> ClientModKeybindings.clickingSprint;
            case Key.FORWARD -> ClientModKeybindings.clickingForward;
            case Key.BACK -> ClientModKeybindings.clickingBack;
            case Key.LEFT -> ClientModKeybindings.clickingLeft;
            case Key.RIGHT -> ClientModKeybindings.clickingRight;
            default -> {
                AdAstra.LOGGER.warn("Invalid Keypress on client: " + key);
                yield false;
            }
        };
    }

    public static void pressedKeyOnServer(UUID uuid, Key key, boolean keyDown) {
        PLAYER_KEYS.putIfAbsent(uuid, new ModKeyBindings());
        switch (key) {
            case JUMP: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingJump = keyDown;
                break;
            }
            case SPRINT: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingSprint = keyDown;
                break;
            }
            case FORWARD: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingForward = keyDown;
                break;
            }
            case BACK: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingBack = keyDown;
                break;
            }
            case LEFT: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingLeft = keyDown;
                break;
            }
            case RIGHT: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingRight = keyDown;
                break;
            }
            default: {
                AdAstra.LOGGER.warn("Invalid Keypress on server packet: " + key);
            }
        }
    }

    static {
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> PLAYER_KEYS.remove(handler.method_32311().method_5667()));
    }

    public static enum Key {
        JUMP,
        SPRINT,
        FORWARD,
        BACK,
        LEFT,
        RIGHT;

    }
}

