/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.util;

import com.github.alexnijjar.ad_astra.blocks.machines.entity.FluidMachineBlockEntity;
import com.github.alexnijjar.ad_astra.items.FluidContainingItem;
import com.github.alexnijjar.ad_astra.recipes.ConversionRecipe;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class FluidUtils {
    public static long dropletsToMillibuckets(long droplets) {
        return droplets / 81L;
    }

    public static long millibucketsToDroplets(long millibuckets) {
        return millibuckets * 81L;
    }

    public static float dropletsToMillibucketsFloat(long droplets) {
        return (float)droplets / 81.0f;
    }

    public static float millibucketsToDropletsFloat(long millibuckets) {
        return (float)millibuckets * 81.0f;
    }

    public static <T extends ConversionRecipe> SingleVariantStorage<FluidVariant> createTank(final FluidMachineBlockEntity blockEntity, final long tankSize, final boolean insert, final boolean extract) {
        return new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return tankSize * 81000L;
            }

            protected void onFinalCommit() {
                blockEntity.method_5431();
            }

            protected boolean canInsert(FluidVariant variant) {
                return insert;
            }

            protected boolean canExtract(FluidVariant variant) {
                return extract;
            }
        };
    }

    public static <T extends ConversionRecipe> SingleVariantStorage<FluidVariant> createTank(final long tankSize) {
        return new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return tankSize * 81000L;
            }
        };
    }

    public static <T extends ConversionRecipe> boolean convertFluid(FluidMachineBlockEntity inventory, List<T> recipes, int transferPerTick) {
        if (recipes == null) {
            return false;
        }
        FluidVariant inputTankFluid = (FluidVariant)inventory.inputTank.variant;
        for (ConversionRecipe recipe : recipes) {
            double conversionRatio = recipe.getConversionRatio();
            FluidVariant recipeInputVariant = FluidVariant.of((class_3611)recipe.getFluidInput());
            FluidVariant recipeOutputVariant = FluidVariant.of((class_3611)recipe.getFluidOutput());
            if (!inputTankFluid.equals(recipeInputVariant) || FluidUtils.convertAndMove(inventory.inputTank, inventory.outputTank, f -> true, FluidUtils.millibucketsToDroplets(transferPerTick), null, recipeOutputVariant, conversionRatio) <= 0L) continue;
            return true;
        }
        return false;
    }

    public static void insertFluidIntoTank(class_1263 inventory, Storage<FluidVariant> inputTank, int insertSlot, int extractSlot, Predicate<FluidVariant> filter) {
        class_1799 original = inventory.method_5438(insertSlot).method_7972();
        inventory.method_5438(insertSlot).method_7939(1);
        ContainerItemContext context = ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(insertSlot)));
        Storage storage = (Storage)context.find(FluidStorage.ITEM);
        try (Transaction transaction = Transaction.openOuter();){
            if (StorageUtil.move((Storage)storage, inputTank, filter, (long)Long.MAX_VALUE, (TransactionContext)transaction) > 0L && FluidUtils.canInsert(inventory, extractSlot, context)) {
                class_1799 stack = context.getItemVariant().toStack();
                stack.method_7939(inventory.method_5438(extractSlot).method_7947() + 1);
                original.method_7934(1);
                inventory.method_5447(extractSlot, stack);
                transaction.commit();
                inventory.method_5447(insertSlot, original.method_7972());
                return;
            }
        }
        transaction = Transaction.openOuter();
        try {
            if (StorageUtil.move(inputTank, (Storage)storage, filter, (long)Long.MAX_VALUE, (TransactionContext)transaction) > 0L && FluidUtils.canInsert(inventory, extractSlot, context)) {
                class_1799 stack = context.getItemVariant().toStack();
                stack.method_7939(inventory.method_5438(extractSlot).method_7947() + 1);
                original.method_7934(1);
                inventory.method_5447(extractSlot, stack);
                transaction.commit();
            }
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        inventory.method_5447(insertSlot, original.method_7972());
    }

    public static void extractFluidFromTank(class_1263 inventory, Storage<FluidVariant> outputTank, int insertSlot, int extractSlot) {
        class_1799 original = inventory.method_5438(insertSlot).method_7972();
        inventory.method_5438(insertSlot).method_7939(1);
        ContainerItemContext context = ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(insertSlot)));
        Storage storage = (Storage)context.find(FluidStorage.ITEM);
        try (Transaction transaction = Transaction.openOuter();){
            if (StorageUtil.move(outputTank, (Storage)storage, f -> true, (long)Long.MAX_VALUE, (TransactionContext)transaction) > 0L && FluidUtils.canInsert(inventory, extractSlot, context)) {
                class_1799 stack = context.getItemVariant().toStack();
                if (!(stack.method_7909() instanceof FluidContainingItem)) {
                    stack.method_7939(inventory.method_5438(extractSlot).method_7947() + 1);
                    original.method_7934(1);
                    inventory.method_5447(extractSlot, stack);
                }
                transaction.commit();
            }
        }
        if (!(context.getItemVariant().toStack().method_7909() instanceof FluidContainingItem)) {
            inventory.method_5447(insertSlot, original);
        }
    }

    public static boolean canInsert(class_1263 inventory, int extractSlot, ContainerItemContext context) {
        class_1799 stack = context.getItemVariant().toStack();
        class_1799 extractSlotStack = inventory.method_5438(extractSlot);
        return extractSlotStack.method_7960() || class_1799.method_31577((class_1799)extractSlotStack, (class_1799)stack) && extractSlotStack.method_7947() < extractSlotStack.method_7914();
    }

    public static long convertAndMove(@Nullable Storage<FluidVariant> from, @Nullable Storage<FluidVariant> to, Predicate<FluidVariant> filter, long maxAmount, @Nullable TransactionContext transaction, FluidVariant outputFluid, double conversionRatio) {
        if (from == null || to == null) {
            return 0L;
        }
        long totalMoved = 0L;
        try (Transaction iterationTransaction = Transaction.openNested((TransactionContext)transaction);){
            for (StorageView view : from.iterable((TransactionContext)iterationTransaction)) {
                long maxExtracted;
                FluidVariant resource;
                if (view.isResourceBlank() || !filter.test(resource = (FluidVariant)view.getResource())) continue;
                try (Transaction extractionTestTransaction = iterationTransaction.openNested();){
                    maxExtracted = view.extract((Object)resource, maxAmount - totalMoved, (TransactionContext)extractionTestTransaction);
                    extractionTestTransaction.abort();
                }
                try (Transaction transferTransaction = iterationTransaction.openNested();){
                    long accepted = to.insert((Object)outputFluid, (long)((double)maxExtracted * conversionRatio), (TransactionContext)transferTransaction);
                    if (view.extract((Object)resource, (long)((double)accepted / conversionRatio), (TransactionContext)transferTransaction) == (long)((double)accepted / conversionRatio)) {
                        totalMoved += accepted;
                        transferTransaction.commit();
                    }
                }
                if (maxAmount != totalMoved) continue;
                iterationTransaction.commit();
                long l = totalMoved;
                return l;
            }
            iterationTransaction.commit();
        }
        return totalMoved;
    }
}

