/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.entities.vehicles;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.entities.vehicles.VehicleEntity;
import com.github.alexnijjar.ad_astra.registry.ModItems;
import com.github.alexnijjar.ad_astra.screen.LargeVehicleScreenHandlerFactory;
import com.github.alexnijjar.ad_astra.util.ModKeyBindings;
import com.github.alexnijjar.ad_astra.util.ModUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3486;
import net.minecraft.class_3532;

public class RoverEntity
extends VehicleEntity {
    public double wheelPitch;
    public double prevWheelPitch;
    protected static final class_2940<Float> TURN_SPEED = class_2945.method_12791(RoverEntity.class, (class_2941)class_2943.field_13320);

    public RoverEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_6013 = 1.0f;
    }

    @Override
    public int getInventorySize() {
        return 18;
    }

    @Override
    public void openInventory(class_1657 player) {
        this.openInventory(player, new LargeVehicleScreenHandlerFactory(this));
    }

    @Override
    public long getTankSize() {
        return AdAstra.CONFIG.rover.tankBuckets;
    }

    @Override
    public long getFuelPerTick() {
        return AdAstra.CONFIG.rover.fuelPerTick;
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        super.method_5688(player, hand);
        this.openInventory(player);
        return class_1269.field_5812;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TURN_SPEED, (Object)Float.valueOf(0.0f));
    }

    @Override
    public double method_5621() {
        super.method_5621();
        return super.method_5621() + (double)0.6f;
    }

    @Override
    public class_1799 getDropStack() {
        return ModItems.TIER_1_ROVER.method_7854();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.travel();
        if (AdAstra.CONFIG.rover.explodeRoverInLava && this.method_5777(class_3486.field_15518)) {
            this.explode(0.35f);
        }
    }

    public void method_5641(double x, double y, double z, float yaw, float pitch) {
        super.method_5641(x, y, z, yaw, pitch);
    }

    private void travel() {
        this.prevWheelPitch = this.wheelPitch;
        this.previousYaw = this.method_36454();
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (this.inputTank.amount > 0L) {
                boolean shouldConsumeFuel = false;
                if (ModKeyBindings.forwardKeyDown(player)) {
                    shouldConsumeFuel = true;
                    this.setSpeed(this.getSpeed() + 0.1f);
                }
                if (ModKeyBindings.backKeyDown(player)) {
                    shouldConsumeFuel = true;
                    this.setSpeed(this.getSpeed() + (this.method_5799() || this.method_5771() ? -0.01f : -0.05f));
                }
                if (ModKeyBindings.leftKeyDown(player)) {
                    this.setTurnSpeed(this.getTurnSpeed() - AdAstra.CONFIG.rover.turnSpeed * this.getSpeed());
                    this.method_18799(new class_243(this.method_18798().method_10216() / 1.1, this.method_18798().method_10214(), this.method_18798().method_10215() / 1.1));
                }
                if (ModKeyBindings.rightKeyDown(player)) {
                    this.setTurnSpeed(this.getTurnSpeed() + AdAstra.CONFIG.rover.turnSpeed * this.getSpeed());
                    this.method_18799(new class_243(this.method_18798().method_10216() / 1.1, this.method_18798().method_10214(), this.method_18798().method_10215() / 1.1));
                }
                if (shouldConsumeFuel) {
                    this.consumeFuel();
                }
            }
        }
        this.setTurnSpeed(class_3532.method_15363((float)this.getTurnSpeed(), (float)(-AdAstra.CONFIG.rover.maxTurnSpeed), (float)AdAstra.CONFIG.rover.maxTurnSpeed));
        this.setTurnSpeed(this.getTurnSpeed() * AdAstra.CONFIG.rover.deceleration);
        if ((double)this.getTurnSpeed() < 0.1 && (double)this.getTurnSpeed() > -0.1) {
            this.setTurnSpeed(0.0f);
        }
        ModUtils.rotateVehicleYaw(this, this.method_36454() + this.getTurnSpeed());
        for (class_1297 passenger : this.method_5685()) {
            passenger.method_36456(passenger.method_36454() + this.getTurnSpeed());
        }
        this.wheelPitch += (double)(this.getSpeed() * 7.0f);
    }

    public void method_5865(class_1297 passenger) {
        this.copyEntityData(passenger);
        this.updatePassengerPosition(passenger, class_1297::method_5814);
    }

    private void updatePassengerPosition(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        if (!this.method_5626(passenger)) {
            return;
        }
        double d = this.method_23318() + this.method_5621() + passenger.method_5678();
        if (passenger.equals((Object)this.method_31483())) {
            double xRotator = Math.cos((this.method_36454() - 50.0f) * ((float)Math.PI / 180)) * (double)0.85f;
            double zRotator = Math.sin((this.method_36454() - 50.0f) * ((float)Math.PI / 180)) * (double)0.85f;
            positionUpdater.accept(passenger, this.method_23317() + xRotator, d, this.method_23321() + zRotator);
        } else {
            double xRotator = Math.cos((this.method_36454() + 50.0f) * ((float)Math.PI / 180)) * (double)-0.85f;
            double zRotator = Math.sin((this.method_36454() + 50.0f) * ((float)Math.PI / 180)) * (double)-0.85f;
            positionUpdater.accept(passenger, this.method_23317() + xRotator, d, this.method_23321() + zRotator);
        }
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 pos = passenger.method_19538();
        if (this.method_5685().size() == 0) {
            double xRotator = Math.cos(this.method_36454() * ((float)Math.PI / 180)) * (double)0.9f;
            double zRotator = Math.sin(this.method_36454() * ((float)Math.PI / 180)) * (double)0.9f;
            passenger.method_18799(this.method_18798());
            return new class_243(pos.method_10216() + xRotator, pos.method_10214(), pos.method_10215() + zRotator);
        }
        double xRotator = Math.cos(this.method_36454() * ((float)Math.PI / 180)) * -1.0;
        double zRotator = Math.sin(this.method_36454() * ((float)Math.PI / 180)) * -1.0;
        passenger.method_18799(this.method_18798());
        return new class_243(pos.method_10216() + xRotator, pos.method_10214(), pos.method_10215() + zRotator);
    }

    @Override
    public int getMaxPassengers() {
        return 2;
    }

    @Override
    public float getMinSpeed() {
        return AdAstra.CONFIG.rover.minSpeed;
    }

    @Override
    public float getMaxSpeed() {
        return AdAstra.CONFIG.rover.maxSpeed;
    }

    public float getTurnSpeed() {
        return ((Float)this.field_6011.method_12789(TURN_SPEED)).floatValue();
    }

    public void setTurnSpeed(float value) {
        this.field_6011.method_12778(TURN_SPEED, (Object)Float.valueOf(value));
    }

    protected void copyEntityData(class_1297 entity) {
        entity.method_5636(this.method_36454());
        float deg = class_3532.method_15393((float)(entity.method_36454() - this.method_36454()));
        float lookAroundFreedom = class_3532.method_15363((float)deg, (float)-105.0f, (float)105.0f);
        entity.field_5982 += lookAroundFreedom - deg;
        entity.method_36456(entity.method_36454() + lookAroundFreedom - deg);
        entity.method_5847(entity.method_36454());
    }

    public void method_5644(class_1297 passenger) {
        this.copyEntityData(passenger);
    }
}

