/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.entities.vehicles;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.blocks.door.LocationState;
import com.github.alexnijjar.ad_astra.blocks.launchpad.LaunchPad;
import com.github.alexnijjar.ad_astra.entities.vehicles.VehicleEntity;
import com.github.alexnijjar.ad_astra.items.armour.NetheriteSpaceSuit;
import com.github.alexnijjar.ad_astra.registry.ModCriteria;
import com.github.alexnijjar.ad_astra.registry.ModDamageSource;
import com.github.alexnijjar.ad_astra.registry.ModParticleTypes;
import com.github.alexnijjar.ad_astra.registry.ModSoundEvents;
import com.github.alexnijjar.ad_astra.registry.ModTags;
import com.github.alexnijjar.ad_astra.screen.PlanetSelectionScreenHandlerFactory;
import com.github.alexnijjar.ad_astra.screen.handler.PlanetSelectionScreenHandler;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.github.alexnijjar.ad_astra.util.ModKeyBindings;
import com.github.alexnijjar.ad_astra.util.ModUtils;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2770;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3908;

public class RocketEntity
extends VehicleEntity {
    protected static final class_2940<Boolean> HAS_LAUNCH_PAD = class_2945.method_12791(RocketEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> FLYING = class_2945.method_12791(RocketEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> COUNTDOWN_TICKS = class_2945.method_12791(RocketEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> TIER = class_2945.method_12791(RocketEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> PHASE = class_2945.method_12791(RocketEntity.class, (class_2941)class_2943.field_13327);
    private class_1657 lastRider;

    public RocketEntity(class_1299<?> type, class_1937 world, int tier) {
        super(type, world);
        this.setTier(tier);
    }

    @Override
    public int getInventorySize() {
        return 10;
    }

    @Override
    public long getTankSize() {
        return AdAstra.CONFIG.rocket.tankBuckets;
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        super.method_5688(player, hand);
        this.openInventory(player);
        return class_1269.field_5812;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HAS_LAUNCH_PAD, (Object)false);
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(COUNTDOWN_TICKS, (Object)0);
        this.field_6011.method_12784(TIER, (Object)0);
        this.field_6011.method_12784(PHASE, (Object)0);
    }

    public class_243 method_24829(class_1309 passenger) {
        super.method_24829(passenger);
        int exitDirection = Math.round(passenger.method_36454() / 90.0f) * 90;
        class_243 pos = passenger.method_19538();
        class_243 exitPos = switch (exitDirection) {
            case 0, 360 -> new class_243(pos.method_10216(), pos.method_10214(), pos.method_10215() + 1.5);
            case 90 -> new class_243(pos.method_10216() - 1.5, pos.method_10214(), pos.method_10215());
            case -90 -> new class_243(pos.method_10216() + 1.5, pos.method_10214(), pos.method_10215());
            case -180, 180 -> new class_243(pos.method_10216(), pos.method_10214(), pos.method_10215() - 1.5);
            default -> throw new IllegalArgumentException("Unexpected value: " + exitDirection);
        };
        class_2338 exitBlockPos = new class_2338(exitPos);
        for (int checks = 3; !this.field_6002.method_8320(exitBlockPos).method_26212((class_1922)this.field_6002, exitBlockPos) && checks > 0; --checks) {
            exitBlockPos = exitBlockPos.method_10074();
        }
        class_2680 exitBlockState = this.field_6002.method_8320(exitBlockPos.method_10084());
        class_265 collisionShape = exitBlockState.method_26220((class_1922)this.field_6002, exitBlockPos);
        double yOffset = 0.0;
        if (!collisionShape.method_1110()) {
            yOffset = exitBlockState.method_26220((class_1922)this.field_6002, exitBlockPos).method_1107().method_17940();
        }
        return new class_243((double)exitBlockPos.method_10263(), (double)exitBlockPos.method_10084().method_10264() + yOffset, (double)exitBlockPos.method_10260());
    }

    public void assignLaunchPad(boolean value) {
        this.setLaunchPad(value);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1657) {
            class_1657 player;
            this.lastRider = player = (class_1657)class_12972;
            if (ModKeyBindings.leftKeyDown(player)) {
                this.rotateRocketAndPassengers(-1.0f);
            }
            if (ModKeyBindings.rightKeyDown(player)) {
                this.rotateRocketAndPassengers(1.0f);
            }
        }
        if (this.method_23318() >= (double)AdAstra.CONFIG.rocket.atmosphereLeave || this.method_32312() > 1000) {
            this.setFlying(true);
        }
        if (!this.isFlying()) {
            if (this.hasLaunchPad()) {
                class_2680 below = this.field_6002.method_8320(this.method_24515());
                if (!(below.method_26204() instanceof LaunchPad)) {
                    this.drop();
                } else {
                    class_2248 class_22482 = below.method_26204();
                    if (class_22482 instanceof LaunchPad) {
                        LaunchPad pad = (LaunchPad)class_22482;
                        if (!((LocationState)((Object)below.method_11654(LaunchPad.LOCATION))).equals((Object)LocationState.CENTER)) {
                            this.drop();
                        }
                    }
                }
            }
        } else {
            this.setCountdownTicks(this.getCountdownTicks() - 1);
            if (this.getCountdownTicks() > 0) {
                this.spawnSmokeParticles();
                this.setPhase(1);
            } else if (this.method_23318() < (double)AdAstra.CONFIG.rocket.atmosphereLeave) {
                this.spawnAfterburnerParticles();
                this.burnEntitiesUnderRocket();
                this.travel();
                if (this.getCountdownTicks() < -30) {
                    this.explodeIfStopped();
                }
                this.setPhase(2);
            } else if (this.method_23318() >= (double)AdAstra.CONFIG.rocket.atmosphereLeave) {
                this.openPlanetSelectionGui();
                this.setPhase(3);
            }
        }
        if (this.method_5777(class_3486.field_15518)) {
            this.explode(0.45f);
        }
    }

    @Override
    public void drop() {
        if (!this.isFlying()) {
            super.drop();
        }
    }

    public void openPlanetSelectionGui() {
        if (!this.method_5782()) {
            if (!this.field_6002.field_9236 && this.lastRider != null) {
                ModCriteria.ROCKET_DESTROYED.trigger((class_3222)this.lastRider);
            }
            this.explode();
            return;
        }
        this.method_5685().forEach(passenger -> {
            if (passenger instanceof class_1657) {
                class_1657 player = (class_1657)passenger;
                if (!(player.field_7512 instanceof PlanetSelectionScreenHandler)) {
                    player.method_17355((class_3908)new PlanetSelectionScreenHandlerFactory(this.getTier()));
                    class_1937 patt7142$temp = this.field_6002;
                    if (patt7142$temp instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)patt7142$temp;
                        RocketEntity.stopRocketSoundForRider((class_3222)player);
                    }
                }
            }
        });
    }

    public void spawnSmokeParticles() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 pos = this.method_19538();
            ModUtils.spawnForcedParticles(serverWorld, class_2398.field_17430, pos.method_10216(), pos.method_10214(), pos.method_10215(), 6, 0.1, 0.1, 0.1, 0.023);
        }
    }

    public void spawnAfterburnerParticles() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 pos = this.method_19538();
            ModUtils.spawnForcedParticles(serverWorld, ModParticleTypes.LARGE_FLAME, pos.method_10216(), pos.method_10214(), pos.method_10215(), 20, 0.1, 0.1, 0.1, 0.001);
            ModUtils.spawnForcedParticles(serverWorld, ModParticleTypes.LARGE_SMOKE, pos.method_10216(), pos.method_10214(), pos.method_10215(), 10, 0.1, 0.1, 0.1, 0.001);
        }
    }

    private void burnEntitiesUnderRocket() {
        List entities = this.field_6002.method_8390(class_1309.class, this.method_5829().method_1009(2.0, 30.0, 2.0).method_989(0.0, -37.0, 0.0), entity -> true);
        for (class_1309 entity2 : entities) {
            if (NetheriteSpaceSuit.hasFullSet(entity2) || entity2.method_5854() != null && entity2.method_5854().equals((Object)this) || !AdAstra.CONFIG.rocket.entitiesBurnUnderRocket || entity2.method_5753()) continue;
            entity2.method_5639(10);
            entity2.method_5643(ModDamageSource.ROCKET_FLAMES, 10.0f);
            class_2680 belowBlock = this.field_6002.method_8320(entity2.method_24515().method_10074());
            if (!belowBlock.method_26234((class_1922)this.field_6002, entity2.method_24515().method_10074()) || !belowBlock.method_26215()) continue;
            this.field_6002.method_8501(entity2.method_24515(), class_2246.field_10036.method_9564());
        }
    }

    private void travel() {
        double multiplier;
        double d = multiplier = ((FluidVariant)this.inputTank.getResource()).getFluid().method_15791(ModTags.EFFICIENT_FUELS) ? 2.5 : 1.0;
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, AdAstra.CONFIG.rocket.acceleration * multiplier, 0.0));
        }
        if (this.method_18798().method_10214() > AdAstra.CONFIG.rocket.maxSpeed * multiplier) {
            this.method_18800(0.0, AdAstra.CONFIG.rocket.maxSpeed, 0.0);
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public void initiateLaunchSequenceFromServer() {
        this.initiateLaunchSequence();
        this.field_6002.method_8396(null, this.method_24515(), ModSoundEvents.ROCKET_LAUNCH_SOUND_EVENT, class_3419.field_15256, 1.0f, 1.0f);
    }

    public void initiateLaunchSequence() {
        this.setFlying(true);
        this.setCountdownTicks(AdAstra.CONFIG.rocket.countDownTicks);
        this.method_32317(Integer.MAX_VALUE);
        this.inputTank.amount -= RocketEntity.getRequiredAmountForLaunch((FluidVariant)this.inputTank.getResource());
    }

    public boolean hasLaunchPad() {
        return (Boolean)this.field_6011.method_12789(HAS_LAUNCH_PAD);
    }

    public void setLaunchPad(boolean value) {
        this.field_6011.method_12778(HAS_LAUNCH_PAD, (Object)value);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean value) {
        this.field_6011.method_12778(FLYING, (Object)value);
    }

    public int getCountdownTicks() {
        return (Integer)this.field_6011.method_12789(COUNTDOWN_TICKS);
    }

    public void setCountdownTicks(int value) {
        this.field_6011.method_12778(COUNTDOWN_TICKS, (Object)value);
    }

    public int getPhase() {
        return (Integer)this.field_6011.method_12789(PHASE);
    }

    public void setPhase(int value) {
        this.field_6011.method_12778(PHASE, (Object)value);
    }

    public int getTier() {
        return (Integer)this.field_6011.method_12789(TIER);
    }

    public void setTier(int value) {
        this.field_6011.method_12778(TIER, (Object)value);
    }

    public int getCountdownSeconds() {
        return (this.getCountdownTicks() + 20) / 20;
    }

    @Override
    public boolean doHighFov() {
        return true;
    }

    @Override
    public boolean fullyConcealsRider() {
        return true;
    }

    @Override
    public boolean canRiderTakeFallDamage() {
        return false;
    }

    @Override
    public boolean renderPlanetBar() {
        return true;
    }

    @Override
    public void doGravity() {
        class_2680 belowBlock = this.field_6002.method_8320(this.method_24515());
        if (belowBlock.method_26204() instanceof LaunchPad && ((LocationState)((Object)belowBlock.method_11654(LaunchPad.LOCATION))).equals((Object)LocationState.CENTER)) {
            return;
        }
        if (this.getPhase() == 0 || this.getPhase() == 1) {
            super.doGravity();
        }
    }

    private void explodeIfStopped() {
        if (this.method_18798().method_10214() < 0.05 && this.method_18798().method_10214() > -1.0E-6) {
            this.explode();
        }
    }

    public void explode() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            float tierMultiplier = 1.0f + (float)this.getTier() * 0.25f;
            if (this.method_18798().method_10214() > 4.0) {
                tierMultiplier *= 1.25f;
            }
            if (this.method_23318() <= (double)AdAstra.CONFIG.rocket.atmosphereLeave) {
                serverWorld.method_18456().forEach(RocketEntity::stopRocketSoundForRider);
            }
            this.explode(tierMultiplier);
        }
    }

    public void rotateRocketAndPassengers(float rotation) {
        ModUtils.rotateVehicleYaw(this, this.method_36454() + rotation);
        for (class_1297 passenger : this.method_5685()) {
            passenger.method_36456(passenger.method_36454() + rotation);
        }
    }

    public static void stopRocketSoundForRider(class_3222 rider) {
        class_2770 stopSoundS2CPacket = new class_2770((class_2960)new ModIdentifier("rocket_fly"), class_3419.field_15256);
        rider.field_13987.method_14364((class_2596)stopSoundS2CPacket);
    }

    public static long getRequiredAmountForLaunch(FluidVariant variant) {
        if (variant.getFluid().method_15791(ModTags.EFFICIENT_FUELS)) {
            return 81000L;
        }
        return 243000L;
    }
}

