/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.data;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.data.Planet;
import com.github.alexnijjar.ad_astra.data.PlanetParser;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public class PlanetData {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new ModIdentifier("planet_data");
            }

            public void method_14491(class_3300 manager) {
                ArrayList<Planet> planets = new ArrayList<Planet>();
                for (class_2960 id : manager.method_14488("planet_data/planets", path -> path.endsWith(".json"))) {
                    try {
                        for (class_3298 resource : manager.method_14489(id)) {
                            InputStreamReader reader = new InputStreamReader(resource.method_14482());
                            JsonObject jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (jsonObject == null) continue;
                            planets.add(PlanetParser.parse(jsonObject));
                        }
                    }
                    catch (Exception e) {
                        AdAstra.LOGGER.error("Failed to load Ad Astra planet data from: \"" + id.toString() + "\"", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                AdAstra.planets = new HashSet<Planet>(planets);
                AdAstra.planetWorlds = AdAstra.planets.stream().map(Planet::world).collect(Collectors.toSet());
                AdAstra.orbitWorlds = AdAstra.planets.stream().map(Planet::orbitWorld).collect(Collectors.toSet());
                AdAstra.adAstraWorlds = Stream.concat(AdAstra.planetWorlds.stream(), AdAstra.orbitWorlds.stream()).collect(Collectors.toSet());
                AdAstra.worldsWithOxygen = AdAstra.planets.stream().filter(Planet::hasOxygen).map(Planet::world).collect(Collectors.toSet());
            }
        });
    }
}

