/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.compat.emi.recipes;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.compat.emi.EmiCategories;
import com.github.alexnijjar.ad_astra.compat.emi.EmiTextures;
import com.github.alexnijjar.ad_astra.recipes.OxygenConversionRecipe;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5481;

public class EmiOxygenConversionRecipe
implements EmiRecipe {
    private final class_2960 id;
    OxygenConversionRecipe recipe;
    private final EmiStack input;
    private final EmiStack output;

    public EmiOxygenConversionRecipe(OxygenConversionRecipe recipe) {
        this.id = recipe.method_8114();
        this.recipe = recipe;
        this.input = EmiStack.of((class_3611)recipe.getFluidInput());
        this.output = EmiStack.of((class_3611)recipe.getFluidOutput());
    }

    public EmiRecipeCategory getCategory() {
        return EmiCategories.OXYGEN_CONVERSION_CATEGORY;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 90;
    }

    public void addWidgets(WidgetHolder widgets) {
        int xOffset = 20;
        int yOffset = 30;
        widgets.addFillingArrow(26 + xOffset, 1 + yOffset, 1000);
        EmiTextures.createFluidWidget(widgets, -10 + xOffset, -17 + yOffset, FluidVariant.of((class_3611)((class_3611)this.input.getKey())), 7500, false);
        EmiTextures.createFluidWidget(widgets, 60 + xOffset, -17 + yOffset, FluidVariant.of((class_3611)((class_3611)this.output.getKey())), 7500, true);
        EmiTextures.createEnergyWidget(widgets, 100 + xOffset, -20 + yOffset, (int)AdAstra.CONFIG.fuelRefinery.energyPerTick, false);
        class_5481 ratioText = EmiPort.ordered((class_2561)EmiPort.translatable((String)"rei.text.ad_astra.conversion_ratio", (Object[])new Object[]{this.recipe.getConversionRatio() * 100.0}));
        widgets.addText(ratioText, -17 + xOffset, 50 + yOffset, -12566464, false);
    }
}

