/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.screens;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.client.screens.GuiUtil;
import com.github.alexnijjar.ad_astra.util.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class PlayerOverlayScreen {
    private static final class_2960 OXYGEN_TANK_EMPTY_TEXTURE = new class_2960("ad_astra", "textures/gui/overlay/oxygen_tank_empty.png");
    private static final class_2960 OXYGEN_TANK_FULL_TEXTURE = new class_2960("ad_astra", "textures/gui/overlay/oxygen_tank_full.png");
    private static final class_2960 EARTH_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/earth_planet_bar.png");
    private static final class_2960 MOON_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/moon_planet_bar.png");
    private static final class_2960 MARS_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/mars_planet_bar.png");
    private static final class_2960 VENUS_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/venus_planet_bar.png");
    private static final class_2960 MERCURY_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/mercury_planet_bar.png");
    private static final class_2960 GLACIO_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/glacio_planet_bar.png");
    private static final class_2960 ORBIT_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/orbit_planet_bar.png");
    private static final class_2960 ROCKET_PLANET_BAR_TEXTURE = new class_2960("ad_astra", "textures/gui/planet_bar/rocket.png");
    private static final class_2561 WARNING_TEXT = new class_2588("gui.ad_astra.text.warning");
    private static final class_2960 BATTERY_TEXTURE = new class_2960("ad_astra", "textures/gui/overlay/battery.png");
    private static final class_2960 BATTERY_EMPTY_TEXTURE = new class_2960("ad_astra", "textures/gui/overlay/battery_empty.png");
    public static boolean shouldRenderOxygen;
    public static double oxygenRatio;
    public static boolean doesNotNeedOxygen;
    public static int countdownSeconds;
    public static boolean shouldRenderBar;
    public static boolean shouldRenderWarning;
    public static double speed;
    public static boolean shouldRenderBattery;
    public static double batteryRatio;

    public static void render(class_4587 matrices, float delta) {
        int textWidth;
        class_2561 text;
        int textureHeight;
        int textureWidth;
        int y;
        int x;
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        class_746 player = client.field_1724;
        if (player.method_7325()) {
            return;
        }
        if (shouldRenderOxygen && !client.field_1690.field_1866) {
            x = 5 + AdAstra.CONFIG.general.oxygenBarXOffset;
            y = 25 + AdAstra.CONFIG.general.oxygenBarYOffset;
            textureWidth = 62;
            textureHeight = 52;
            GuiUtil.drawVerticalReverse(matrices, x, y, textureWidth, textureHeight, OXYGEN_TANK_EMPTY_TEXTURE, oxygenRatio);
            GuiUtil.drawVertical(matrices, x, y, textureWidth, textureHeight, OXYGEN_TANK_FULL_TEXTURE, oxygenRatio);
            double oxygen = (double)Math.round(oxygenRatio * 1000.0) / 10.0;
            text = class_2561.method_30163((String)(oxygen + "%"));
            textWidth = client.field_1772.method_27525((class_5348)text);
            if (doesNotNeedOxygen) {
                client.field_1772.method_30881(matrices, text, (float)x + (float)(textureWidth - textWidth) / 2.0f, (float)(y + textureHeight + 3), 0x7FFF00);
            } else {
                client.field_1772.method_30881(matrices, text, (float)x + (float)(textureWidth - textWidth) / 2.0f, (float)(y + textureHeight + 3), oxygen <= 0.0 ? 14423100 : 0xFFFFFF);
            }
        }
        if (shouldRenderBattery && !client.field_1690.field_1866) {
            x = screenWidth - 75 - AdAstra.CONFIG.general.energyBarXOffset;
            y = 25 + AdAstra.CONFIG.general.energyBarYOffset;
            textureWidth = 68;
            textureHeight = 37;
            GuiUtil.drawHorizontal(matrices, x, y, textureWidth, textureHeight, BATTERY_EMPTY_TEXTURE, 1.0);
            GuiUtil.drawHorizontal(matrices, x, y, textureWidth, textureHeight, BATTERY_TEXTURE, batteryRatio);
            double energy = (double)Math.round(batteryRatio * 1000.0) / 10.0;
            text = class_2561.method_30163((String)(energy + "%"));
            textWidth = client.field_1772.method_27525((class_5348)text);
            client.field_1772.method_30881(matrices, text, (float)(x + (textureWidth - textWidth) / 2), (float)(y + textureHeight + 3), 6324918);
        }
        if (countdownSeconds > 0) {
            matrices.method_22903();
            matrices.method_22904((double)((float)screenWidth / 2.0f), (double)((float)screenHeight / 2.0f), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            matrices.method_22903();
            matrices.method_22905(4.0f, 4.0f, 4.0f);
            int m = client.field_1772.method_1727("" + countdownSeconds);
            client.field_1772.method_1720(matrices, "" + countdownSeconds, (float)(-m / 2), -10.0f, 15020627);
            matrices.method_22909();
            RenderSystem.disableBlend();
            matrices.method_22909();
        }
        if (shouldRenderBar && !client.field_1690.field_1866) {
            float rocketHeight = (float)(player.method_23318() / (double)((float)AdAstra.CONFIG.rocket.atmosphereLeave / 113.0f));
            rocketHeight = class_3532.method_15363((float)rocketHeight, (float)0.0f, (float)113.0f);
            int x2 = 0;
            int y2 = screenHeight / 2 - 64;
            class_5321 currentWorld = player.method_37908().method_27983();
            class_2960 planet = currentWorld.equals(class_1937.field_25179) ? EARTH_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MOON_KEY) ? MOON_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MARS_KEY) ? MARS_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.VENUS_KEY) ? VENUS_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.MERCURY_KEY) ? MERCURY_PLANET_BAR_TEXTURE : (currentWorld.equals(ModUtils.GLACIO_KEY) ? GLACIO_PLANET_BAR_TEXTURE : ORBIT_PLANET_BAR_TEXTURE)))));
            RenderSystem.setShaderTexture((int)0, (class_2960)planet);
            class_332.method_25290((class_4587)matrices, (int)x2, (int)y2, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            RenderSystem.setShaderTexture((int)0, (class_2960)ROCKET_PLANET_BAR_TEXTURE);
            GuiUtil.FloatDrawableHelper.drawTexture(matrices, 4.0f, (float)(screenHeight / 2 + 51) - rocketHeight, 0.0f, 0.0f, 8, 11, 8, 11);
        }
        if (shouldRenderWarning) {
            matrices.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34542);
            float sine = (float)Math.sin(((float)client.field_1687.method_8510() + client.method_1488()) / 2.0f);
            sine = class_3532.method_15363((float)sine, (float)0.0f, (float)1.0f);
            RenderSystem.setShaderColor((float)sine, (float)sine, (float)sine, (float)sine);
            matrices.method_22903();
            matrices.method_22904((double)((float)screenWidth / 2.0f), (double)((float)screenHeight / 2.0f / 1.5f), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            matrices.method_22903();
            matrices.method_22905(4.0f, 4.0f, 4.0f);
            int m = client.field_1772.method_27525((class_5348)WARNING_TEXT);
            client.field_1772.method_30881(matrices, WARNING_TEXT, (float)(-m / 2), -10.0f, class_5253.class_5254.method_27764((int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f)), (int)((int)(sine * 255.0f))));
            matrices.method_22909();
            RenderSystem.disableBlend();
            matrices.method_22909();
        }
    }

    public static void disableAllOverlays() {
        shouldRenderOxygen = false;
        shouldRenderBattery = false;
        shouldRenderBar = false;
        shouldRenderWarning = false;
    }

    public static void disableAllVehicleOverlays() {
        shouldRenderBar = false;
        countdownSeconds = 0;
        shouldRenderWarning = false;
    }
}

