/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.resourcepack;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.client.AdAstraClient;
import com.github.alexnijjar.ad_astra.client.registry.ClientModSkies;
import com.github.alexnijjar.ad_astra.client.resourcepack.Galaxy;
import com.github.alexnijjar.ad_astra.client.resourcepack.GalaxyParser;
import com.github.alexnijjar.ad_astra.client.resourcepack.PlanetRing;
import com.github.alexnijjar.ad_astra.client.resourcepack.PlanetRingParser;
import com.github.alexnijjar.ad_astra.client.resourcepack.SkyRenderer;
import com.github.alexnijjar.ad_astra.client.resourcepack.SkyRendererParser;
import com.github.alexnijjar.ad_astra.client.resourcepack.SolarSystem;
import com.github.alexnijjar.ad_astra.client.resourcepack.SolarSystemParser;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class PlanetResources {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new ModIdentifier("planet_resources");
            }

            public void method_14491(class_3300 manager) {
                JsonObject jsonObject;
                InputStreamReader reader;
                ArrayList<SkyRenderer> skyRenderers = new ArrayList<SkyRenderer>();
                ArrayList<SolarSystem> solarSystems = new ArrayList<SolarSystem>();
                ArrayList<PlanetRing> planetRings = new ArrayList<PlanetRing>();
                ArrayList<Galaxy> galaxies = new ArrayList<Galaxy>();
                for (class_2960 id : manager.method_14488("planet_resources/sky_renderers", path -> path.endsWith(".json"))) {
                    try {
                        for (class_3298 resource : manager.method_14489(id)) {
                            reader = new InputStreamReader(resource.method_14482());
                            jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (jsonObject == null) continue;
                            skyRenderers.add(SkyRendererParser.parse(jsonObject));
                        }
                    }
                    catch (Exception e) {
                        AdAstra.LOGGER.error("Failed to load Ad Astra sky rendering assets from: \"" + id.toString() + "\"", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                for (class_2960 id : manager.method_14488("planet_resources/solar_systems", path -> path.endsWith(".json"))) {
                    try {
                        for (class_3298 resource : manager.method_14489(id)) {
                            reader = new InputStreamReader(resource.method_14482());
                            jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (jsonObject == null) continue;
                            solarSystems.add(SolarSystemParser.parse(jsonObject));
                        }
                    }
                    catch (Exception e) {
                        AdAstra.LOGGER.error("Failed to load Ad Astra solar system assets from: \"" + id.toString() + "\"", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                for (class_2960 id : manager.method_14488("planet_resources/planet_rings", path -> path.endsWith(".json"))) {
                    try {
                        for (class_3298 resource : manager.method_14489(id)) {
                            reader = new InputStreamReader(resource.method_14482());
                            jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (jsonObject == null) continue;
                            planetRings.add(PlanetRingParser.parse(jsonObject));
                        }
                    }
                    catch (Exception e) {
                        AdAstra.LOGGER.error("Failed to load Ad Astra planet ring assets from: \"" + id.toString() + "\"", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                for (class_2960 id : manager.method_14488("planet_resources/galaxy", path -> path.endsWith(".json"))) {
                    try {
                        for (class_3298 resource : manager.method_14489(id)) {
                            reader = new InputStreamReader(resource.method_14482());
                            jsonObject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (jsonObject == null) continue;
                            galaxies.add(GalaxyParser.parse(jsonObject));
                        }
                    }
                    catch (Exception e) {
                        AdAstra.LOGGER.error("Failed to load Ad Astra galaxy assets from: \"" + id.toString() + "\"", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                solarSystems.sort((s1, s2) -> s1.solarSystem().method_12833(s2.solarSystem()));
                galaxies.sort((g1, g2) -> g1.galaxy().method_12833(g2.galaxy()));
                AdAstraClient.skyRenderers = skyRenderers;
                AdAstraClient.solarSystems = solarSystems;
                AdAstraClient.planetRings = planetRings;
                AdAstraClient.galaxies = galaxies;
                ClientModSkies.register();
            }
        });
    }
}

