/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.renderer.sky;

import com.github.alexnijjar.ad_astra.client.renderer.sky.ModSky;
import com.github.alexnijjar.ad_astra.client.resourcepack.SkyRenderer;
import com.github.alexnijjar.ad_astra.mixin.client.WorldRendererAccessor;
import com.github.alexnijjar.ad_astra.util.ColourHolder;
import com.github.alexnijjar.ad_astra.world.WorldSeed;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1294;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_758;

@Environment(value=EnvType.CLIENT)
public class SkyUtil {
    public static float getScale() {
        class_310 client = class_310.method_1551();
        float distance = (float)(-3000.0 + client.field_1724.method_23318() * 4.5);
        float scale = 100.0f * (0.2f - distance / 10000.0f);
        return Math.max(scale, 0.5f);
    }

    public static void preRender(WorldRenderContext context, class_287 bufferBuilder, SkyRenderer.SunsetColour colourType, int sunsetAngle, class_4587 matrices, class_638 world, float tickDelta) {
        RenderSystem.disableTexture();
        class_243 vec3d = world.method_23777(context.gameRenderer().method_19418().method_19326(), tickDelta);
        float f = (float)vec3d.method_10216();
        float g = (float)vec3d.method_10214();
        float h = (float)vec3d.method_10215();
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        class_291 skyBuffer = ((WorldRendererAccessor)context.worldRenderer()).getLightSkyBuffer();
        skyBuffer.method_1353();
        ((WorldRendererAccessor)context.worldRenderer()).getLightSkyBuffer().method_34427(context.matrixStack().method_23760().method_23761(), context.projectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        SkyUtil.renderColouring(colourType, bufferBuilder, matrices, world, tickDelta, world.method_30274(tickDelta), sunsetAngle);
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void postRender(WorldRenderContext context, class_4587 matrices, class_638 world, float tickDelta) {
        class_243 vec3d = world.method_23777(context.gameRenderer().method_19418().method_19326(), tickDelta);
        float f = (float)vec3d.method_10216();
        float g = (float)vec3d.method_10214();
        float h = (float)vec3d.method_10215();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (world.method_28103().method_28113()) {
            RenderSystem.setShaderColor((float)(f * 0.2f + 0.04f), (float)(g * 0.2f + 0.04f), (float)(h * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        }
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
    }

    public static boolean isSubmerged(class_4184 camera) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        class_5636 cameraSubmersionType = camera.method_19334();
        return cameraSubmersionType.equals((Object)class_5636.field_27887) || cameraSubmersionType.equals((Object)class_5636.field_27885) || player.method_6059(class_1294.field_5919);
    }

    private static void startRendering(class_4587 matrices, class_1160 rotation) {
        matrices.method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22907(class_1160.field_20705.method_23214(rotation.method_4945()));
        matrices.method_22907(class_1160.field_20707.method_23214(rotation.method_4947()));
        matrices.method_22907(class_1160.field_20703.method_23214(rotation.method_4943()));
    }

    private static void endRendering(class_4587 matrices) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        matrices.method_22909();
    }

    public static void render(WorldRenderContext context, class_287 bufferBuilder, class_2960 texture, ColourHolder colour, class_1160 rotation, float scale, boolean blending) {
        SkyUtil.startRendering(context.matrixStack(), rotation);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderColor((float)((float)((int)colour.r()) / 255.0f), (float)((float)((int)colour.g()) / 255.0f), (float)((float)((int)colour.b()) / 255.0f), (float)1.0f);
        if (blending) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        class_1159 positionMatrix = context.matrixStack().method_23760().method_23761();
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(positionMatrix, -scale, 100.0f, -scale).method_22913(1.0f, 0.0f).method_1336((int)colour.r(), (int)colour.g(), (int)colour.b(), 255).method_1344();
        bufferBuilder.method_22918(positionMatrix, scale, 100.0f, -scale).method_22913(0.0f, 0.0f).method_1336((int)colour.r(), (int)colour.g(), (int)colour.b(), 255).method_1344();
        bufferBuilder.method_22918(positionMatrix, scale, 100.0f, scale).method_22913(0.0f, 1.0f).method_1336((int)colour.r(), (int)colour.g(), (int)colour.b(), 255).method_1344();
        bufferBuilder.method_22918(positionMatrix, -scale, 100.0f, scale).method_22913(1.0f, 1.0f).method_1336((int)colour.r(), (int)colour.g(), (int)colour.b(), 255).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        SkyUtil.endRendering(context.matrixStack());
    }

    public static class_291 renderStars(WorldRenderContext context, class_287 bufferBuilder, class_291 starsBuffer, int stars, SkyRenderer.StarsRenderer starsRenderer) {
        SkyUtil.startRendering(context.matrixStack(), new class_1160(-30.0f, 0.0f, context.world().method_30274(context.tickDelta()) * 360.0f));
        RenderSystem.setShader(class_757::method_34540);
        if (starsBuffer != null) {
            starsBuffer.close();
        }
        starsBuffer = new class_291();
        SkyUtil.renderStars(bufferBuilder, stars, starsRenderer.colouredStars());
        bufferBuilder.method_1326();
        starsBuffer.method_1352(bufferBuilder);
        if (!starsRenderer.daylightVisible()) {
            float rot = context.world().method_23787(context.tickDelta());
            RenderSystem.setShaderColor((float)rot, (float)rot, (float)rot, (float)rot);
        } else {
            RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.8f);
        }
        class_758.method_3212();
        starsBuffer.method_34427(context.matrixStack().method_23760().method_23761(), RenderSystem.getProjectionMatrix(), class_757.method_34540());
        context.matrixStack().method_22909();
        return starsBuffer;
    }

    private static void renderStars(class_287 buffer, int stars, boolean colouredStars) {
        RenderSystem.setShader(class_757::method_34540);
        Random random = new Random(WorldSeed.getSeed());
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (int i = 0; i < stars; ++i) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double e = random.nextFloat() * 2.0f - 1.0f;
            double f = random.nextFloat() * 2.0f - 1.0f;
            double g = (double)0.15f + (double)random.nextFloat() * 0.01;
            double h = d * d + e * e + f * f;
            if (!(h < 1.0) || !(h > 0.01)) continue;
            h = 1.0 / Math.sqrt(h);
            double j = (d *= h) * 100.0;
            double k = (e *= h) * 100.0;
            double l = (f *= h) * 100.0;
            double m = Math.atan2(d, f);
            double n = Math.sin(m);
            double o = Math.cos(m);
            double p = Math.atan2(Math.sqrt(d * d + f * f), e);
            double q = Math.sin(p);
            double r = Math.cos(p);
            double s = random.nextDouble() * Math.PI * 2.0;
            double t = Math.sin(s);
            double u = Math.cos(s);
            int starR = 255;
            int starG = 255;
            int starB = 255;
            if (colouredStars) {
                int colourChannel = random.nextInt(5);
                if (colourChannel == 0) {
                    starR = 204;
                    starG = 238;
                    starB = 255;
                } else if (colourChannel == 1) {
                    starR = 204;
                    starG = 153;
                    starB = 255;
                } else if (colourChannel == 2) {
                    starR = 255;
                    starG = 255;
                    starB = 153;
                } else if (colourChannel == 3) {
                    starR = 255;
                    starG = 204;
                    starB = 102;
                } else {
                    starR = 255;
                    starG = 255;
                    starB = 255;
                }
            }
            for (int v = 0; v < 4; ++v) {
                double x = (double)((v & 2) - 1) * g;
                double y = (double)((v + 1 & 2) - 1) * g;
                double aa = x * u - y * t;
                double ac = y * u + x * t;
                double ad = aa * q + 0.0 * r;
                double ae = 0.0 * q - aa * r;
                double af = ae * n - ac * o;
                double ah = ac * n + ae * o;
                buffer.method_22912(j + af, k + ad, l + ah).method_1336(starR, starG, starB, 255).method_1344();
            }
        }
    }

    public static void renderColouring(SkyRenderer.SunsetColour type, class_287 bufferBuilder, class_4587 matrices, class_638 world, float tickDelta, float skyAngle, int sunsetAngle) {
        float[] fogColours;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VANILLA: {
                float[] fArray = world.method_28103().method_28109(world.method_30274(tickDelta), tickDelta);
                break;
            }
            case MARS: {
                float[] fArray = fogColours = ModSky.getMarsColour(skyAngle);
            }
        }
        if (fogColours != null) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.disableTexture();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22903();
            matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
            float sine = class_3532.method_15374((float)world.method_8442(tickDelta)) < 0.0f ? 180.0f : (float)sunsetAngle;
            matrices.method_22907(class_1160.field_20707.method_23214(sine));
            matrices.method_22907(class_1160.field_20707.method_23214(90.0f));
            class_1159 matrix4f = matrices.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(fogColours[0], fogColours[1], fogColours[2], fogColours[3]).method_1344();
            for (int i = 0; i <= 16; ++i) {
                float o = (float)i * ((float)Math.PI * 2) / 16.0f;
                float cosine = class_3532.method_15362((float)o);
                bufferBuilder.method_22918(matrix4f, class_3532.method_15374((float)o) * 120.0f, cosine * 120.0f, -cosine * 40.0f * fogColours[3]).method_22915(fogColours[0], fogColours[1], fogColours[2], 0.0f).method_1344();
            }
            bufferBuilder.method_1326();
            class_286.method_1309((class_287)bufferBuilder);
            matrices.method_22909();
        }
    }
}

