/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.renderer.entity.vehicles;

import com.github.alexnijjar.ad_astra.client.renderer.entity.vehicles.VehicleEntityModel;
import com.github.alexnijjar.ad_astra.client.renderer.entity.vehicles.rover.RoverEntityModel;
import com.github.alexnijjar.ad_astra.entities.vehicles.VehicleEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public abstract class VehicleEntityRenderer<T extends VehicleEntity, M extends class_583<T>>
extends class_897<T>
implements class_3883<T, M> {
    protected M model;

    protected VehicleEntityRenderer(class_5617.class_5618 context, M model, float shadowRadius) {
        super(context);
        this.model = model;
        this.field_4673 = shadowRadius;
    }

    public M method_4038() {
        return this.model;
    }

    public void render(T entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22903();
        matrices.method_22907(class_1160.field_20707.method_23214(180.0f));
        matrices.method_22907(class_1160.field_20705.method_23214((float)this.getYawOffset()));
        matrices.method_22904(0.0, -1.501, 0.0);
        if (entity.method_32314()) {
            this.shakeVehicle(entity, tickDelta, matrices);
        }
        this.model.method_2819(entity, tickDelta, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(this.model.method_23500(this.method_3931((class_1297)entity)));
        this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.method_22909();
        super.method_3936(entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    private void shakeVehicle(T entity, float tickDelta, class_4587 matrices) {
        if (!class_310.method_1551().method_1493()) {
            double shakeDirection1 = tickDelta * (float)(((VehicleEntity)((Object)entity)).field_6002.field_9229.nextBoolean() ? 1 : -1) / 150.0f;
            double shakeDirection2 = tickDelta * (float)(((VehicleEntity)((Object)entity)).field_6002.field_9229.nextBoolean() ? 1 : -1) / 150.0f;
            double shakeDirection3 = tickDelta * (float)(((VehicleEntity)((Object)entity)).field_6002.field_9229.nextBoolean() ? 1 : -1) / 150.0f;
            matrices.method_22904(shakeDirection1, shakeDirection2, shakeDirection3);
        }
    }

    public static void renderItem(class_583<?> model, class_2960 texture, class_5601 layer, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        matrices.method_22907(class_1160.field_20707.method_23214(180.0f));
        matrices.method_22904(0.0, -1.501, 0.0);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_28116((class_2960)texture));
        model.method_2828(matrices, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.method_22909();
    }

    public static void renderRocketItem(class_2960 texture, class_5601 layer, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        VehicleEntityModel model = new VehicleEntityModel(class_310.method_1551().method_31974().method_32072(layer), "rocket");
        VehicleEntityRenderer.renderItem(model, texture, layer, matrices, vertexConsumers, light, overlay);
    }

    public static void renderRoverItem(class_2960 texture, class_5601 layer, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        RoverEntityModel model = new RoverEntityModel(class_310.method_1551().method_31974().method_32072(layer));
        VehicleEntityRenderer.renderItem(model, texture, layer, matrices, vertexConsumers, light, overlay);
    }

    public int getYawOffset() {
        return 180;
    }
}

