/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.client.renderer.block.flag;

import com.github.alexnijjar.ad_astra.blocks.flags.EightDirectionProperty;
import com.github.alexnijjar.ad_astra.blocks.flags.FlagBlock;
import com.github.alexnijjar.ad_astra.blocks.flags.FlagBlockEntity;
import com.github.alexnijjar.ad_astra.client.renderer.block.flag.FlagTexture;
import com.github.alexnijjar.ad_astra.util.ModIdentifier;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.BakedModelManagerHelper;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2378;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class FlagBlockEntityRenderer
implements class_827<FlagBlockEntity> {
    public FlagBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public void render(FlagBlockEntity entity, float partialTicks, class_4587 stack, class_4597 provider, int light, int overlay) {
        if (((class_2756)entity.method_11010().method_11654(FlagBlock.HALF)).equals((Object)class_2756.field_12607)) {
            ModIdentifier model = new ModIdentifier("block/flag/" + class_2378.field_11146.method_10221((Object)entity.method_11010().method_26204()).method_12832());
            stack.method_22903();
            stack.method_22904(0.5, 0.5, 0.5);
            stack.method_22907(class_1160.field_20705.method_23214((float)((EightDirectionProperty.Direction)((Object)entity.method_11010().method_11654((class_2769)FlagBlock.FACING))).asRotation()));
            stack.method_22904(-0.5, 0.0, -0.5);
            FlagBlockEntityRenderer.renderFlag(model, partialTicks, stack, provider, light, overlay);
            stack.method_22909();
        } else {
            String url = entity.getUrl();
            if (url != null) {
                FlagBlockEntityRenderer.renderFullTexture(entity, stack, provider, light, overlay, false);
                FlagBlockEntityRenderer.renderFullTexture(entity, stack, provider, light, overlay, true);
            } else {
                FlagBlockEntityRenderer.renderFace(entity, stack, provider, light, overlay, false);
                FlagBlockEntityRenderer.renderFace(entity, stack, provider, light, overlay, true);
            }
        }
    }

    private static void renderFullTexture(FlagBlockEntity entity, class_4587 stack, class_4597 provider, int light, int overlay, boolean flip) {
        stack.method_22903();
        stack.method_22904(0.5, 1.0, 0.5);
        stack.method_22907(class_1160.field_20705.method_23214((float)((EightDirectionProperty.Direction)((Object)entity.method_11010().method_11654((class_2769)FlagBlock.FACING))).asRotation()));
        stack.method_22907(class_1160.field_20703.method_23214(180.0f));
        stack.method_22904(-1.375, -0.375, flip ? -0.01 : 0.01);
        if (!flip) {
            FlagBlockEntityRenderer.flipY(stack, 1.25f);
        }
        class_4588 vertexConsumer = provider.getBuffer(FlagBlockEntityRenderer.getFlagImage(entity.getUrl()));
        FlagBlockEntityRenderer.renderQuad(stack, vertexConsumer, 1.25f, 0.875f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
        stack.method_22909();
    }

    private static void renderFace(FlagBlockEntity entity, class_4587 stack, class_4597 provider, int light, int overlay, boolean flip) {
        stack.method_22903();
        stack.method_22904(0.5, 1.0, 0.5);
        stack.method_22907(class_1160.field_20705.method_23214((float)((EightDirectionProperty.Direction)((Object)entity.method_11010().method_11654((class_2769)FlagBlock.FACING))).asRotation()));
        stack.method_22907(class_1160.field_20703.method_23214(180.0f));
        stack.method_22904(-1.0, -0.25, flip ? -0.01 : 0.01);
        if (flip) {
            FlagBlockEntityRenderer.flipY(stack, 0.5f);
        }
        class_4588 vertexConsumer = provider.getBuffer(FlagBlockEntityRenderer.getRenderLayer(entity.getOwner()));
        FlagBlockEntityRenderer.renderQuad(stack, vertexConsumer, 0.5f, 0.5f, 0.125f, 0.125f, 0.125f, 0.125f, light, overlay);
        FlagBlockEntityRenderer.renderQuad(stack, vertexConsumer, 0.5f, 0.5f, 0.5f, 0.125f, 0.125f, 0.125f, light, overlay);
        stack.method_22909();
    }

    private static void renderQuad(class_4587 stack, class_4588 consumer, float width, float height, float u, float v, float uWidth, float vHeight, int light, int overlay) {
        consumer.method_22918(stack.method_23760().method_23761(), 0.0f, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(overlay).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        consumer.method_22918(stack.method_23760().method_23761(), 0.0f, height, 0.0f).method_1336(255, 255, 255, 255).method_22913(u, v + vHeight).method_22922(overlay).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        consumer.method_22918(stack.method_23760().method_23761(), width, height, 0.0f).method_1336(255, 255, 255, 255).method_22913(u + uWidth, v + vHeight).method_22922(overlay).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        consumer.method_22918(stack.method_23760().method_23761(), width, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(u + uWidth, v).method_22922(overlay).method_22916(light).method_22914(0.0f, 0.0f, 1.0f).method_1344();
    }

    private static void flipY(class_4587 stack, float width) {
        class_1162 vec3f = new class_1162(0.0f, 0.0f, 0.0f, 0.0f);
        vec3f.method_22674(stack.method_23760().method_23761());
        stack.method_22904((double)(-vec3f.method_4953()), (double)(-vec3f.method_4956()), (double)(-vec3f.method_4957()));
        stack.method_22907(class_1160.field_20705.method_23214(180.0f));
        stack.method_22904((double)vec3f.method_4953(), (double)vec3f.method_4956(), (double)vec3f.method_4957());
        stack.method_22904((double)(-width), 0.0, 0.0);
    }

    public static class_1921 getRenderLayer(GameProfile profile) {
        if (profile == null) {
            return class_1921.method_28116((class_2960)new class_2960("textures/entity/zombie/zombie.png"));
        }
        class_310 minecraftClient = class_310.method_1551();
        Map map = minecraftClient.method_1582().method_4654(profile);
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return class_1921.method_23580((class_2960)minecraftClient.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
        }
        return class_1921.method_23578((class_2960)class_1068.method_4648((UUID)class_1657.method_7271((GameProfile)profile)));
    }

    public static class_1921 getFlagImage(String url) {
        class_2960 id = FlagTexture.getTextureId(url);
        class_1060 manager = class_310.method_1551().method_1531();
        class_1044 texture = manager.method_34590(id, (class_1044)class_1047.method_4540());
        if (texture == class_1047.method_4540()) {
            manager.method_4616(id, (class_1044)new FlagTexture(url));
        }
        return class_1921.method_23580((class_2960)id);
    }

    public static void renderFlag(class_2960 texture, float tickDelta, class_4587 matrices, class_4597 provider, int light, int overlay) {
        class_310 minecraft = class_310.method_1551();
        class_1087 model = BakedModelManagerHelper.getModel((class_1092)minecraft.method_1554(), (class_2960)texture);
        class_4588 vertexConsumer1 = provider.getBuffer(class_1921.method_23576((class_2960)class_1723.field_21668));
        minecraft.method_1541().method_3350().method_3367(matrices.method_23760(), vertexConsumer1, null, model, 1.0f, 1.0f, 1.0f, light, overlay);
    }
}

