/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.pipes;

import com.github.alexnijjar.ad_astra.blocks.pipes.FluidPipeBlock;
import com.github.alexnijjar.ad_astra.blocks.pipes.InteractablePipe;
import com.github.alexnijjar.ad_astra.blocks.pipes.PipeState;
import com.github.alexnijjar.ad_astra.registry.ModBlockEntities;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class FluidPipeBlockEntity
extends class_2586
implements InteractablePipe<Storage<FluidVariant>> {
    private List<InteractablePipe.Node<Storage<FluidVariant>>> consumers = new ArrayList<InteractablePipe.Node<Storage<FluidVariant>>>();
    private InteractablePipe.Node<Storage<FluidVariant>> source;

    public FluidPipeBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.FLUID_PIPE, pos, state);
    }

    @Override
    public boolean supportsAutoExtract() {
        return true;
    }

    @Override
    public boolean canTakeFrom(Storage<FluidVariant> source) {
        return source.supportsExtraction();
    }

    @Override
    public boolean canInsertInto(Storage<FluidVariant> consumer) {
        return consumer.supportsInsertion();
    }

    @Override
    public boolean canConnectTo(class_2586 next, class_2350 direction, class_2338 pos) {
        return true;
    }

    @Override
    public void insertInto(Storage<FluidVariant> consumer, class_2350 direction, class_2338 pos) {
        Storage<FluidVariant> output;
        Storage<FluidVariant> input;
        class_2680 state = this.method_11010();
        class_2680 state2 = this.field_11863.method_8320(pos);
        if (!(state.method_26204() instanceof FluidPipeBlock) || !(state2.method_26204() instanceof FluidPipeBlock)) {
            return;
        }
        PipeState pipeState = (PipeState)((Object)state.method_11654((class_2769)FluidPipeBlock.DIRECTIONS.get(this.getSource().direction())));
        PipeState pipeState2 = (PipeState)((Object)state2.method_11654((class_2769)FluidPipeBlock.DIRECTIONS.get(direction)));
        if (pipeState.equals((Object)PipeState.INSERT) && pipeState2.equals((Object)PipeState.INSERT)) {
            return;
        }
        if (pipeState.equals((Object)PipeState.EXTRACT) && pipeState2.equals((Object)PipeState.EXTRACT)) {
            return;
        }
        if (pipeState.equals((Object)PipeState.NONE) || pipeState2.equals((Object)PipeState.NONE)) {
            return;
        }
        if (pipeState2.equals((Object)PipeState.INSERT) && !pipeState2.equals((Object)PipeState.NONE)) {
            input = this.source.storage();
            output = consumer;
        } else if (pipeState2.equals((Object)PipeState.EXTRACT) && !pipeState2.equals((Object)PipeState.NONE)) {
            input = consumer;
            output = this.source.storage();
        } else if (pipeState.equals((Object)PipeState.INSERT) && !pipeState.equals((Object)PipeState.NONE)) {
            input = consumer;
            output = this.source.storage();
        } else if (pipeState.equals((Object)PipeState.EXTRACT) && !pipeState.equals((Object)PipeState.NONE)) {
            input = this.source.storage();
            output = consumer;
        } else {
            return;
        }
        if (this.getSource() != null && this.getConsumers().size() > 0) {
            StorageUtil.move(input, output, f -> true, (long)Math.max(0L, this.getTransferAmount() / (long)this.getConsumers().size()), null);
        }
    }

    @Override
    public Storage<FluidVariant> getInteraction(class_1937 world, class_2338 pos, class_2350 direction) {
        return (Storage)FluidStorage.SIDED.find(world, pos, (Object)direction);
    }

    @Override
    public InteractablePipe.Node<Storage<FluidVariant>> getSource() {
        return this.source;
    }

    @Override
    public void setSource(InteractablePipe.Node<Storage<FluidVariant>> source) {
        this.source = source;
    }

    @Override
    public void clearSource() {
        this.source = null;
    }

    @Override
    public List<InteractablePipe.Node<Storage<FluidVariant>>> getConsumers() {
        return this.consumers;
    }

    @Override
    public int getWorkTime() {
        return 5;
    }

    @Override
    public class_1937 getPipeWorld() {
        return this.field_11863;
    }

    @Override
    public long getTransferAmount() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof FluidPipeBlock) {
            FluidPipeBlock fluidPipe = (FluidPipeBlock)class_22482;
            return fluidPipe.getTransferRate();
        }
        return 0L;
    }

    @Override
    public class_2338 getPipePos() {
        return this.method_11016();
    }
}

