/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexnijjar.ad_astra.blocks.machines.entity;

import com.github.alexnijjar.ad_astra.AdAstra;
import com.github.alexnijjar.ad_astra.blocks.machines.entity.AbstractMachineBlockEntity;
import com.github.alexnijjar.ad_astra.registry.ModBlockEntities;
import com.github.alexnijjar.ad_astra.screen.handler.SolarPanelScreenHandler;
import com.github.alexnijjar.ad_astra.util.ModUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends AbstractMachineBlockEntity {
    public SolarPanelBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.SOLAR_PANEL, blockPos, blockState);
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new SolarPanelScreenHandler(syncId, inv, this);
    }

    @Override
    public boolean usesEnergy() {
        return true;
    }

    @Override
    public long getMaxGeneration() {
        return AdAstra.CONFIG.solarPanel.maxEnergy;
    }

    @Override
    public long getEnergyPerTick() {
        return SolarPanelBlockEntity.getEnergyForDimension(this.method_10997());
    }

    @Override
    public long getMaxEnergyExtract() {
        return (long)(AdAstra.CONFIG.solarPanel.energyMultiplier * 15.0);
    }

    @Override
    public void tick() {
        if (!this.field_11863.field_9236) {
            if (this.field_11863.method_8530() && (!this.field_11863.method_27983().equals(class_1937.field_25179) || !this.field_11863.method_8419() && !this.field_11863.method_8546()) && this.field_11863.method_8311(this.method_11016().method_10084())) {
                this.cumulateEnergy();
                this.setActive(true);
            } else {
                this.setActive(false);
            }
            this.energyOut();
        }
    }

    public static long getEnergyForDimension(class_1937 world) {
        if (world != null) {
            return (long)((double)ModUtils.getSolarEnergy(world) * AdAstra.CONFIG.solarPanel.energyMultiplier);
        }
        return 0L;
    }
}

