/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.world;

import io.github.foundationgames.phonos.block.NotePlayReceivable;
import io.github.foundationgames.phonos.network.PayloadPackets;
import io.github.foundationgames.phonos.network.ReceiverStorageOperation;
import io.github.foundationgames.phonos.util.PhonosUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class RadioChannelState
extends class_18 {
    public static final String ID = "radio_channel_state";
    private final Int2ObjectMap<LinkedHashSet<Long>> blockStorage = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<LinkedHashSet<class_1297>> entityStorage = new Int2ObjectOpenHashMap();
    private final class_3218 world;

    public RadioChannelState(class_3218 world) {
        this.world = world;
    }

    public void readNbt(class_2487 tag) {
        this.blockStorage.clear();
        this.entityStorage.clear();
        Set channels = tag.method_10541();
        for (String c : channels) {
            int i = Integer.parseInt(c);
            long[] la = tag.method_10565(c);
            LinkedHashSet<Long> lt = new LinkedHashSet<Long>();
            for (long l : la) {
                lt.add(l);
            }
            this.blockStorage.put(i, lt);
        }
    }

    public class_2487 method_75(class_2487 tag) {
        IntIterator intIterator = this.blockStorage.keySet().iterator();
        while (intIterator.hasNext()) {
            int k = (Integer)intIterator.next();
            long[] la = ((LinkedHashSet)this.blockStorage.get(k)).stream().mapToLong(l -> l).toArray();
            tag.method_10564(Integer.toString(k), la);
        }
        return tag;
    }

    public void addReceiver(int channel, class_2338 pos) {
        this.blockStorage.putIfAbsent(channel, new LinkedHashSet());
        LinkedHashSet l = (LinkedHashSet)this.blockStorage.get(channel);
        if (l.add(pos.method_10063())) {
            for (class_3222 player : this.world.method_18456()) {
                PayloadPackets.sendReceiversUpdate(player, ReceiverStorageOperation.ADD, channel, new long[]{pos.method_10063()}, new int[0]);
            }
        }
        this.method_78(true);
    }

    public void removeReceiver(int channel, class_2338 pos) {
        this.blockStorage.putIfAbsent(channel, new LinkedHashSet());
        ((LinkedHashSet)this.blockStorage.get(channel)).remove(pos.method_10063());
        for (class_3222 player : this.world.method_18456()) {
            PayloadPackets.sendReceiversUpdate(player, ReceiverStorageOperation.REMOVE, channel, new long[]{pos.method_10063()}, new int[0]);
        }
        this.method_78(true);
    }

    public void addEntityReceiver(int channel, class_1297 ent) {
        this.entityStorage.putIfAbsent(channel, new LinkedHashSet());
        LinkedHashSet l = (LinkedHashSet)this.entityStorage.get(channel);
        if (l.add(ent)) {
            for (class_3222 player : this.world.method_18456()) {
                PayloadPackets.sendReceiversUpdate(player, ReceiverStorageOperation.ADD, channel, new long[0], new int[]{ent.method_5628()});
            }
        }
        this.method_78(true);
    }

    public void removeEntityReceiver(int channel, class_1297 ent) {
        this.entityStorage.putIfAbsent(channel, new LinkedHashSet());
        ((LinkedHashSet)this.entityStorage.get(channel)).remove(ent);
        for (class_3222 player : this.world.method_18456()) {
            PayloadPackets.sendReceiversUpdate(player, ReceiverStorageOperation.REMOVE, channel, new long[0], new int[]{ent.method_5628()});
        }
        this.method_78(true);
    }

    public void garbageCollectEntities() {
        HashSet<class_1297> removed = new HashSet<class_1297>();
        IntIterator intIterator = this.entityStorage.keySet().iterator();
        while (intIterator.hasNext()) {
            int channel = (Integer)intIterator.next();
            removed.clear();
            for (class_1297 entity : (LinkedHashSet)this.entityStorage.get(channel)) {
                if (!entity.method_31481()) continue;
                removed.add(entity);
            }
            for (class_1297 entity : removed) {
                ((LinkedHashSet)this.entityStorage.get(channel)).remove(entity);
            }
        }
    }

    public void tick() {
        this.garbageCollectEntities();
    }

    public boolean hasReceiver(int channel, class_2338 pos) {
        if (this.blockStorage.containsKey(channel)) {
            return ((LinkedHashSet)this.blockStorage.get(channel)).contains(pos.method_10063());
        }
        return false;
    }

    public boolean hasEntityReceiver(int channel, class_1297 ent) {
        if (this.entityStorage.containsKey(channel)) {
            return ((LinkedHashSet)this.entityStorage.get(channel)).contains(ent);
        }
        return false;
    }

    public static void sendPlayerJoinPackets(class_3222 player) {
        int index;
        int j;
        int repeats;
        int i;
        int channel;
        RadioChannelState state = PhonosUtil.getRadioState(player.method_14220());
        IntIterator intIterator = state.blockStorage.keySet().iterator();
        while (intIterator.hasNext()) {
            channel = (Integer)intIterator.next();
            PayloadPackets.sendReceiversUpdate(player, ReceiverStorageOperation.CLEAR, channel, new long[0], new int[0]);
        }
        intIterator = state.entityStorage.keySet().iterator();
        while (intIterator.hasNext()) {
            channel = (Integer)intIterator.next();
            PayloadPackets.sendReceiversUpdate(player, ReceiverStorageOperation.CLEAR, channel, new long[0], new int[0]);
        }
        intIterator = state.blockStorage.keySet().iterator();
        while (intIterator.hasNext()) {
            channel = (Integer)intIterator.next();
            Long[] posList = ((LinkedHashSet)state.blockStorage.get(channel)).toArray(new Long[0]);
            i = 0;
            while ((double)i < Math.ceil((float)posList.length / 16.0f)) {
                repeats = Math.min(posList.length - i * 16, 16);
                long[] positions = new long[repeats];
                for (j = 0; j < repeats; ++j) {
                    index = i * 16 + j;
                    positions[j] = posList[index];
                }
                PayloadPackets.sendReceiversUpdate(player, ReceiverStorageOperation.ADD, channel, positions, new int[0]);
                ++i;
            }
        }
        intIterator = state.entityStorage.keySet().iterator();
        while (intIterator.hasNext()) {
            channel = (Integer)intIterator.next();
            class_1297[] entityList = ((LinkedHashSet)state.entityStorage.get(channel)).toArray(new class_1297[0]);
            i = 0;
            while ((double)i < Math.ceil((float)entityList.length / 16.0f)) {
                repeats = Math.min(entityList.length - i * 16, 16);
                int[] entities = new int[repeats];
                for (j = 0; j < repeats; ++j) {
                    index = i * 16 + j;
                    entities[j] = entityList[index].method_5628();
                }
                PayloadPackets.sendReceiversUpdate(player, ReceiverStorageOperation.ADD, channel, new long[0], entities);
                ++i;
            }
        }
    }

    public void playSound(class_2338 origin, class_3414 sound, int channel, float volume, float pitch, boolean stoppable) {
        for (class_3222 player : this.world.method_18456()) {
            PayloadPackets.sendRadioChannelSound(player, origin, sound, channel, volume, pitch, stoppable);
        }
    }

    public void playSound(class_2338 origin, class_2960 sound, int channel, float volume, float pitch, boolean stoppable) {
        for (class_3222 player : this.world.method_18456()) {
            PayloadPackets.sendRadioChannelSound(player, origin, sound, channel, volume, pitch, stoppable);
        }
    }

    public void alertNotePlayed(int channel, float pitch) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        Iterator iterator = ((LinkedHashSet)this.blockStorage.get(channel)).iterator();
        while (iterator.hasNext()) {
            class_2248 class_22482;
            long l = (Long)iterator.next();
            pos.method_16363(l);
            if (!this.world.method_22340((class_2338)pos) || !((class_22482 = this.world.method_8320((class_2338)pos).method_26204()) instanceof NotePlayReceivable)) continue;
            NotePlayReceivable receiver = (NotePlayReceivable)class_22482;
            receiver.onNotePlayed(this.world, (class_2338)pos, pitch);
        }
    }

    public void tryStopSound(class_2338 origin, int channel) {
        for (class_3222 player : this.world.method_18456()) {
            PayloadPackets.sendStopSound(player, origin, channel);
        }
    }
}

