/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.util.piano;

public class PianoKeyboard {
    private static final int ANIMATION_LENGTH = 3;
    private final int[] keyTimers = new int[25];

    public void tick() {
        for (int i = 0; i < this.keyTimers.length; ++i) {
            if (this.keyTimers[i] <= 0) continue;
            int n = i;
            this.keyTimers[n] = this.keyTimers[n] - 1;
        }
    }

    public void press(int key) {
        this.keyTimers[key] = 3;
    }

    public float getAnimationProgress(int key, float tickDelta) {
        return Math.max((float)this.keyTimers[key] - tickDelta, 0.0f) / 3.0f;
    }
}

