/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.util.piano;

import io.github.foundationgames.phonos.util.PhonosUtil;
import io.github.foundationgames.phonos.util.piano.PianoRoll;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public final class BuiltinPianoRolls {
    private static final Map<String, PianoRoll> REGISTRY = new HashMap<String, PianoRoll>();
    public static final PianoRoll CHOPSTICKS = BuiltinPianoRolls.register("chopsticks", BuiltinPianoRolls.chopsticks());
    private static final int CHOPSTICKS_SPEED = 5;

    private BuiltinPianoRolls() {
    }

    public static PianoRoll register(String name, PianoRoll roll) {
        REGISTRY.put(name, roll);
        return roll;
    }

    public static void forEach(BiConsumer<String, PianoRoll> action) {
        REGISTRY.forEach(action);
    }

    private static PianoRoll chopsticks() {
        ArrayList<PianoRoll.Stage> stages = new ArrayList<PianoRoll.Stage>();
        BuiltinPianoRolls.chopsticksCommonSection(stages);
        for (int i = 0; i < 4; ++i) {
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(6), PhonosUtil.pitchFromNote(18)}, 5));
        }
        stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(8), PhonosUtil.pitchFromNote(17)}, 5));
        stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(10), PhonosUtil.pitchFromNote(15)}, 5));
        BuiltinPianoRolls.chopsticksCommonSection(stages);
        stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(6), PhonosUtil.pitchFromNote(18)}, 5));
        stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(13)}, 5));
        stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(10)}, 5));
        stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(6)}, 5));
        int halfSpeed = 2;
        if (Calendar.getInstance().get(2) == 3 && Calendar.getInstance().get(5) == 1) {
            int i;
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(1)}, halfSpeed));
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(3)}, halfSpeed));
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(6)}, halfSpeed));
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(3)}, halfSpeed));
            for (i = 0; i < 3; ++i) {
                stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(6), PhonosUtil.pitchFromNote(10)}, 5));
            }
            for (i = 0; i < 3; ++i) {
                stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(5), PhonosUtil.pitchFromNote(13)}, 5));
            }
            for (i = 0; i < 3; ++i) {
                stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(8), PhonosUtil.pitchFromNote(13)}, 5));
            }
            for (i = 0; i < 3; ++i) {
                stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(6), PhonosUtil.pitchFromNote(13)}, 5));
            }
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(6), PhonosUtil.pitchFromNote(10), PhonosUtil.pitchFromNote(15)}, 5));
        }
        return new PianoRoll(stages);
    }

    private static void chopsticksCommonSection(List<PianoRoll.Stage> stages) {
        int i;
        for (i = 0; i < 6; ++i) {
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(11), PhonosUtil.pitchFromNote(13)}, 5));
        }
        for (i = 0; i < 6; ++i) {
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(10), PhonosUtil.pitchFromNote(13)}, 5));
        }
        for (i = 0; i < 6; ++i) {
            stages.add(new PianoRoll.Stage(new float[]{PhonosUtil.pitchFromNote(8), PhonosUtil.pitchFromNote(17)}, 5));
        }
    }
}

