/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.screen;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlayerInvPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import io.github.foundationgames.phonos.Phonos;
import io.github.foundationgames.phonos.block.entity.RadioJukeboxBlockEntity;
import io.github.foundationgames.phonos.item.CustomMusicDiscItem;
import io.github.foundationgames.phonos.screen.widget.WBasicButton;
import io.github.foundationgames.phonos.util.SoundUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1813;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class RadioJukeboxGuiDescription
extends SyncedGuiDescription {
    private static final class_2960 TEXTURE = Phonos.id("textures/gui/container/radio_jukebox.png");
    private final WItemSlot discs;
    private final WPlayerInvPanel pinvPanel;
    private final RadioJukeboxBlockEntity blockEntity;
    private final WBasicButton playButton;
    private final WBasicButton forwardButton;
    private final WBasicButton backButton;
    private final WBasicButton shuffleButton;
    private final WBasicButton pitchField;
    private final WBasicButton[] durationFields = new WBasicButton[6];
    private final WBasicButton progressBar;

    public RadioJukeboxGuiDescription(int syncId, class_1661 playerInventory, class_3914 ctx, RadioJukeboxBlockEntity blockEntity) {
        super(Phonos.RADIO_JUKEBOX_HANDLER, syncId, playerInventory, RadioJukeboxGuiDescription.getBlockInventory((class_3914)ctx), RadioJukeboxGuiDescription.getBlockPropertyDelegate((class_3914)ctx));
        WBasicButton progressBar;
        this.blockEntity = blockEntity;
        WGridPanel root = new WGridPanel(1);
        root.setSize(162, 154);
        this.setRootPanel((WPanel)root);
        WLabel title = new WLabel((class_2561)new class_2588("container.phonos.radio_jukebox.title"), 0x252525);
        title.setSize(51, 15);
        root.add((WWidget)title, 0, 3);
        WItemSlot discSlots = WItemSlot.of((class_1263)blockEntity, (int)0, (int)6, (int)1);
        discSlots.setFilter(stack -> stack.method_7909() instanceof class_1813 || stack.method_7909() instanceof CustomMusicDiscItem);
        root.add((WWidget)discSlots, 27, 32);
        this.discs = discSlots;
        WBasicButton playButton = new WBasicButton(19, 14);
        playButton.setWhenClicked((button, x, y, mouseButton) -> {
            if (blockEntity != null) {
                blockEntity.performSyncedOperation((byte)8, 0);
            }
            SoundUtil.playPositionedSound(class_3417.field_15015, class_3419.field_15250, 1.0f, 1.57f, this.playerInventory.field_7546.method_24515());
        });
        this.playButton = playButton;
        root.add((WWidget)playButton, 71, 2);
        WBasicButton forwardButton = new WBasicButton(18, 14);
        forwardButton.setWhenClicked((button, x, y, mouseButton) -> {
            SoundUtil.playPositionedSound(class_3417.field_15015, class_3419.field_15250, 1.0f, 1.57f, this.playerInventory.field_7546.method_24515());
            if (blockEntity != null) {
                blockEntity.performSyncedOperation((byte)9, 0);
            }
        });
        this.forwardButton = forwardButton;
        root.add((WWidget)forwardButton, 91, 2);
        WBasicButton backButton = new WBasicButton(18, 14);
        backButton.setWhenClicked((button, x, y, mouseButton) -> {
            SoundUtil.playPositionedSound(class_3417.field_15015, class_3419.field_15250, 1.0f, 1.57f, this.playerInventory.field_7546.method_24515());
            if (blockEntity != null) {
                blockEntity.performSyncedOperation((byte)10, 0);
            }
        });
        this.backButton = backButton;
        root.add((WWidget)backButton, 52, 2);
        WBasicButton shuffleButton = new WBasicButton(15, 13);
        shuffleButton.setWhenClicked((button, x, y, mouseButton) -> {
            if (blockEntity != null) {
                blockEntity.performSyncedOperation((byte)1, blockEntity.doShuffle ? 0 : 1);
            }
            SoundUtil.playPositionedSound(class_3417.field_15015, class_3419.field_15250, 1.0f, 1.57f, this.playerInventory.field_7546.method_24515());
        });
        this.shuffleButton = shuffleButton;
        root.add((WWidget)shuffleButton, 143, 40);
        WBasicButton pitchAdjust = new WBasicButton(15, 13);
        pitchAdjust.setWhenScrolledOver((button, x, y, amount) -> {
            int value = 10;
            boolean g = true;
            if (blockEntity != null) {
                g = blockEntity.isPlaying();
                value = (int)(blockEntity.pitch * 10.0f);
            }
            value += amount > 0.0 ? 1 : -1;
            value = Math.min(Math.max(1, value), 20);
            if (!g) {
                blockEntity.performSyncedOperation((byte)0, value);
                SoundUtil.playPositionedSound(class_3417.field_15047, class_3419.field_15250, 0.3f, (float)value / 10.0f, this.playerInventory.field_7546.method_24515());
                return InputResult.IGNORED;
            }
            return InputResult.IGNORED;
        });
        this.pitchField = pitchAdjust;
        root.add((WWidget)pitchAdjust, 4, 40);
        for (int i = 0; i < 6; ++i) {
            WBasicButton durationField = new WBasicButton(18, 9);
            int fi = 5 - i;
            durationField.setWhenScrolledOver((button, x, y, amount) -> {
                int dur = 1;
                boolean g = true;
                boolean s = class_437.method_25442();
                if (blockEntity != null) {
                    dur = fi == 0 ? blockEntity.disc1Duration : dur;
                    dur = fi == 1 ? blockEntity.disc2Duration : dur;
                    dur = fi == 2 ? blockEntity.disc3Duration : dur;
                    dur = fi == 3 ? blockEntity.disc4Duration : dur;
                    dur = fi == 4 ? blockEntity.disc5Duration : dur;
                    dur = fi == 5 ? blockEntity.disc6Duration : dur;
                    g = blockEntity.isPlaying();
                }
                int m = 1;
                if (s && (dur == 1 || dur == 599)) {
                    m = 4;
                } else if (s) {
                    m = 5;
                }
                dur += m * (amount > 0.0 ? 1 : -1);
                dur = Math.min(Math.max(1, dur), 599);
                if (!g) {
                    blockEntity.performSyncedOperation(RadioJukeboxBlockEntity.SLOT_2_OP.get(fi), dur);
                    SoundUtil.playPositionedSound(class_3417.field_15015, class_3419.field_15250, 0.1f, 1.85f - (s ? 0.3f : 0.0f), this.playerInventory.field_7546.method_24515());
                    return InputResult.PROCESSED;
                }
                return InputResult.IGNORED;
            });
            this.durationFields[i] = durationField;
            root.add((WWidget)durationField, 116 - i * 18, 51);
        }
        this.progressBar = progressBar = new WBasicButton(108, 13);
        root.add((WWidget)progressBar, 27, 17);
        this.pinvPanel = this.createPlayerInventoryPanel();
        root.add((WWidget)this.pinvPanel, 0, 69);
        root.validate((GuiDescription)this);
    }

    public void addPainters() {
        super.addPainters();
        this.getRootPanel().setBackgroundPainter((mat, x, y, widget) -> RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 0, 0, 176, 166, 256, 256), x - 7, y - 3, 176, 166));
        this.discs.setBackgroundPainter((mat, x, y, widget) -> {
            for (int i = 0; i < 6; ++i) {
                if (!this.blockInventory.method_5438(i).method_7960()) continue;
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176, 42, 18, 18, 256, 256), x + i * 18, y, 18, 18);
            }
        });
        this.playButton.setBackgroundPainter((mat, x, y, mouseX, mouseY, button) -> {
            boolean g = true;
            if (this.blockEntity != null) {
                g = this.blockEntity.isPlaying();
            }
            RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176 + (g ? 19 : 0), 86, 19, 14, 256, 256), x, y, 19, 14);
            if (button.isWithinBounds(mouseX, mouseY)) {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176, 100, 19, 14, 256, 256), x, y, 19, 14);
            }
        });
        this.forwardButton.setBackgroundPainter((mat, x, y, mouseX, mouseY, button) -> {
            RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 214, 86, 18, 14, 256, 256), x, y, 18, 14);
            if (button.isWithinBounds(mouseX, mouseY)) {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 195, 100, 18, 14, 256, 256), x, y, 18, 14);
            }
        });
        this.backButton.setBackgroundPainter((mat, x, y, mouseX, mouseY, button) -> {
            RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 232, 86, 18, 14, 256, 256), x, y, 18, 14);
            if (button.isWithinBounds(mouseX, mouseY)) {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 195, 100, 18, 14, 256, 256), x, y, 18, 14);
            }
        });
        this.shuffleButton.setBackgroundPainter((mat, x, y, mouseX, mouseY, button) -> {
            if (this.blockEntity != null && this.blockEntity.doShuffle) {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176, 60, 15, 13, 256, 256), x, y, 15, 13);
            } else {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 191, 60, 15, 13, 256, 256), x, y, 15, 13);
            }
            if (button.isWithinBounds(mouseX, mouseY)) {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176, 73, 15, 13, 256, 256), x, y, 15, 13);
            }
        });
        this.pitchField.setBackgroundPainter((mat, x, y, mouseX, mouseY, button) -> {
            boolean g = true;
            if (this.blockEntity != null) {
                g = this.blockEntity.isPlaying();
            }
            int d = 10;
            if (this.blockEntity != null) {
                d = (int)(this.blockEntity.pitch * 10.0f);
            }
            if (g) {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 208, 114, 15, 13, 256, 256), x, y, 15, 13);
            } else if (!button.isWithinBounds(mouseX, mouseY)) {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176, 114, 15, 13, 256, 256), x, y, 15, 13);
            } else {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 191, 114, 17, 13, 256, 256), x, y, 17, 13);
            }
            int t = (int)Math.floor((float)d / 10.0f);
            RadioJukeboxGuiDescription.drawDigit(mat, x + 3, y + 4, t, g);
            RadioJukeboxGuiDescription.drawDigit(mat, x + 9, y + 4, d - t * 10, g);
        });
        for (int i = 0; i < this.durationFields.length; ++i) {
            WBasicButton durationField = this.durationFields[i];
            int fi = 5 - i;
            durationField.setBackgroundPainter((mat, x, y, mouseX, mouseY, button) -> {
                boolean g = this.blockEntity.isPlaying();
                int v = 0;
                if (g) {
                    RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 196, 14, 22, 9, 256, 256), x, y, 22, 9);
                } else {
                    if (button.isWithinBounds(mouseX, mouseY)) {
                        v += 9;
                    }
                    RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176, 14 + v, 20 + (button.isWithinBounds(mouseX, mouseY) ? 2 : 0), 9, 256, 256), x, y, 20 + (button.isWithinBounds(mouseX, mouseY) ? 2 : 0), 9);
                }
                int dur = 0;
                dur = fi == 0 ? this.blockEntity.disc1Duration : dur;
                dur = fi == 1 ? this.blockEntity.disc2Duration : dur;
                dur = fi == 2 ? this.blockEntity.disc3Duration : dur;
                dur = fi == 3 ? this.blockEntity.disc4Duration : dur;
                dur = fi == 4 ? this.blockEntity.disc5Duration : dur;
                dur = fi == 5 ? this.blockEntity.disc6Duration : dur;
                int min = (int)Math.floor((float)dur / 60.0f);
                int secTens = (int)Math.floor((float)(dur - min * 60) / 10.0f);
                int secOnes = dur - (min * 60 + secTens * 10);
                RadioJukeboxGuiDescription.drawDigit(mat, x + 4, y + 2, min, g);
                RadioJukeboxGuiDescription.drawDigit(mat, x + 10, y + 2, secTens, g);
                RadioJukeboxGuiDescription.drawDigit(mat, x + 14, y + 2, secOnes, g);
            });
        }
        this.progressBar.setBackgroundPainter((mat, x, y, mouseX, mouseY, button) -> {
            int track = 0;
            float progress = 0.0f;
            boolean playing = false;
            if (this.blockEntity != null) {
                track = this.blockEntity.getPlayingSong();
                progress = 1.0f - this.blockEntity.getProgress();
                playing = this.blockEntity.isPlaying();
            }
            if (playing) {
                int len = (track + 1) * 18 - 9;
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 0, 166, len, 9, 256, 256), x, y + 2, len, 9);
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 202, 127, 13, 15, 256, 256), x + len - 6, y, 13, 15);
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 189, 127, Math.round(13.0f * progress), 15, 256, 256), x + len - 6, y, Math.round(13.0f * progress), 15);
            } else {
                RadioJukeboxGuiDescription.drawTexture(mat, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176, 127, 13, 15, 256, 256), x + 3, y, 13, 15);
            }
        });
        this.pinvPanel.setBackgroundPainter((mat, x, y, widget) -> {});
    }

    private static void drawTexture(class_4587 matrices, Texture texture, int x, int y, int width, int height) {
        ScreenDrawing.texturedRect((class_4587)matrices, (int)x, (int)y, (int)width, (int)height, (Texture)texture, (int)0xFFFFFF, (float)1.0f);
    }

    private static Texture createTexture(class_2960 texture, int u, int v, int width, int height, int texWidth, int texHeight) {
        float u0 = (float)u / (float)texWidth;
        float v0 = (float)v / (float)texHeight;
        float u1 = (float)(u + width) / (float)texWidth;
        float v1 = (float)(v + height) / (float)texHeight;
        return new Texture(texture, u0, v0, u1, v1);
    }

    private static void drawDigit(class_4587 matrices, int x, int y, int digit, boolean grayed) {
        digit = Math.max(0, Math.min(9, digit));
        RadioJukeboxGuiDescription.drawTexture(matrices, RadioJukeboxGuiDescription.createTexture(TEXTURE, 176 + digit * 3, 32 + (grayed ? 5 : 0), 3, 5, 256, 256), x, y, 3, 5);
    }
}

