/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.resource;

import io.github.foundationgames.phonos.Phonos;
import net.devtech.arrp.api.RRPCallback;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.minecraft.class_2960;

public class PhonosAssets {
    public static final RuntimeResourcePack PHONOS_ASSETS = RuntimeResourcePack.create((String)"phonos_assets");

    public static void init() {
        int i;
        RuntimeResourcePack pack = PHONOS_ASSETS;
        JModel ctModel = new JModel().parent("item/handheld").textures(JModel.textures().var("layer0", "phonos:item/channel_tuner"));
        for (i = 0; i < 20; ++i) {
            ctModel.addOverride(JModel.override((JCondition)JModel.condition().parameter("tuned_channel", (Number)Float.valueOf((float)i / 19.0f)), (class_2960)Phonos.id("item/channel_tuner_" + i)));
            pack.addModel(new JModel().parent("item/handheld").textures(JModel.textures().var("layer0", "phonos:item/channel_tuner_" + i)), Phonos.id("item/channel_tuner_" + i));
        }
        pack.addModel(ctModel, Phonos.id("item/channel_tuner"));
        PhonosAssets.addBoomboxItem(pack, "boombox");
        PhonosAssets.addBoomboxItem(pack, "festive_boombox");
        PhonosAssets.addGeneratedItem(pack, "redstone_chip");
        PhonosAssets.addGeneratedItem(pack, "empty_piano_roll");
        PhonosAssets.addGeneratedItem(pack, "piano_roll");
        pack.addModel(new JModel().parent("item/handheld").textures(JModel.textures().var("layer0", "phonos:item/note_block_tuner_inner").var("layer1", "phonos:item/note_block_tuner")).addOverride(JModel.override((JCondition)JModel.condition().parameter("tuner_mode", (Number)0.5), (class_2960)Phonos.id("item/note_block_tuner_copy"))).addOverride(JModel.override((JCondition)JModel.condition().parameter("tuner_mode", (Number)1), (class_2960)Phonos.id("item/note_block_tuner_adjust"))), Phonos.id("item/note_block_tuner"));
        pack.addModel(new JModel().parent("item/generated").textures(JModel.textures().var("layer0", "phonos:item/note_block_tuner_inner").var("layer1", "phonos:item/note_block_tuner_copy")), Phonos.id("item/note_block_tuner_copy"));
        pack.addModel(new JModel().parent("item/generated").textures(JModel.textures().var("layer0", "phonos:item/note_block_tuner_inner").var("layer1", "phonos:item/note_block_tuner_adjust")), Phonos.id("item/note_block_tuner_adjust"));
        pack.addModel(new JModel().parent("item/generated").textures(JModel.textures().var("layer0", "phonos:item/music_disc_inner").var("layer1", "phonos:item/music_disc_outer")), Phonos.id("item/custom_music_disc"));
        for (i = 0; i < 20; ++i) {
            PhonosAssets.addSidedBlockModel(pack, "block/loudspeaker_tuned_" + i, Phonos.id("block/speaker_bottom"), Phonos.id("block/speaker_side"), Phonos.id("block/speaker_top_" + i));
            PhonosAssets.addSidedBlockModel(pack, "block/gourd_speaker_tuned_" + i, new class_2960("block/pumpkin_top"), Phonos.id("block/gourd_speaker_side"), Phonos.id("block/gourd_speaker_top_" + i));
            PhonosAssets.addSidedBlockModel(pack, "block/speak_o_lantern_tuned_" + i, new class_2960("block/pumpkin_top"), Phonos.id("block/speak_o_lantern_side"), Phonos.id("block/gourd_speaker_top_" + i));
            PhonosAssets.addSidedBlockModel(pack, "block/radio_jukebox_off_tuned_" + i, Phonos.id("block/speaker_bottom"), Phonos.id("block/radio_jukebox_side_off"), Phonos.id("block/speaker_top_" + i));
            PhonosAssets.addSidedBlockModel(pack, "block/radio_jukebox_on_tuned_" + i, Phonos.id("block/speaker_bottom"), Phonos.id("block/radio_jukebox_side_on"), Phonos.id("block/speaker_top_" + i));
            PhonosAssets.addCopperSpeakerModels(pack, "", i);
            PhonosAssets.addCopperSpeakerModels(pack, "exposed_", i);
            PhonosAssets.addCopperSpeakerModels(pack, "weathered_", i);
            PhonosAssets.addCopperSpeakerModels(pack, "oxidized_", i);
            PhonosAssets.addTinyPotatoSpeakerModel(pack, i);
            PhonosAssets.addBoomboxModels(pack, "boombox", i);
            PhonosAssets.addBoomboxModels(pack, "festive_boombox", i);
            pack.addModel(new JModel().parent("phonos:block/radio_note_block_base").textures(new JTextures().var("side", "phonos:block/radio_note_block_side").var("overlay", "phonos:block/radio_note_block_overlay").var("bottom", "phonos:block/radio_note_block_bottom").var("top", "phonos:block/speaker_top_" + i)), Phonos.id("block/radio_note_block_tuned_" + i));
            pack.addModel(new JModel().parent("phonos:block/radio_player_piano_base").textures(new JTextures().var("display", "phonos:block/boombox_display_" + i)), Phonos.id("block/radio_player_piano_tuned_" + i));
            pack.addModel(new JModel().parent("phonos:block/radio_recorder_off_base").textures(new JTextures().var("top", "phonos:block/speaker_top_" + i)), Phonos.id("block/radio_recorder_off_tuned_" + i));
            pack.addModel(new JModel().parent("phonos:block/radio_recorder_on_base").textures(new JTextures().var("top", "phonos:block/speaker_top_" + i)), Phonos.id("block/radio_recorder_on_tuned_" + i));
        }
        PhonosAssets.addTunableBlockState(pack, "loudspeaker", "block/loudspeaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "radio_note_block", "block/radio_note_block_tuned_");
        PhonosAssets.addTunableBlockState(pack, "gourd_speaker", "block/gourd_speaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "speak_o_lantern", "block/speak_o_lantern_tuned_");
        PhonosAssets.addTunableBlockState(pack, "copper_speaker", "block/copper_speaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "exposed_copper_speaker", "block/exposed_copper_speaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "weathered_copper_speaker", "block/weathered_copper_speaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "oxidized_copper_speaker", "block/oxidized_copper_speaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "waxed_copper_speaker", "block/copper_speaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "waxed_exposed_copper_speaker", "block/exposed_copper_speaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "waxed_weathered_copper_speaker", "block/weathered_copper_speaker_tuned_");
        PhonosAssets.addTunableBlockState(pack, "waxed_oxidized_copper_speaker", "block/oxidized_copper_speaker_tuned_");
        JVariant tinyPotatoVar = JState.variant();
        for (int i2 = 0; i2 < 20; ++i2) {
            tinyPotatoVar.put("facing=north,channel=" + i2, JState.model((class_2960)Phonos.id("block/tiny_potato_speaker_tuned_" + i2)).y(0));
            tinyPotatoVar.put("facing=south,channel=" + i2, JState.model((class_2960)Phonos.id("block/tiny_potato_speaker_tuned_" + i2)).y(180));
            tinyPotatoVar.put("facing=east,channel=" + i2, JState.model((class_2960)Phonos.id("block/tiny_potato_speaker_tuned_" + i2)).y(90));
            tinyPotatoVar.put("facing=west,channel=" + i2, JState.model((class_2960)Phonos.id("block/tiny_potato_speaker_tuned_" + i2)).y(270));
        }
        pack.addBlockState(new JState().add(tinyPotatoVar), Phonos.id("tiny_potato_speaker"));
        JVariant jukeboxVar = JState.variant();
        for (int i3 = 0; i3 < 20; ++i3) {
            jukeboxVar.put("playing=true,channel=" + i3, JState.model((class_2960)Phonos.id("block/radio_jukebox_on_tuned_" + i3)));
            jukeboxVar.put("playing=false,channel=" + i3, JState.model((class_2960)Phonos.id("block/radio_jukebox_off_tuned_" + i3)));
        }
        pack.addBlockState(new JState().add(jukeboxVar), Phonos.id("radio_jukebox"));
        JVariant radioPianoVar = JState.variant();
        for (int i4 = 0; i4 < 20; ++i4) {
            radioPianoVar.put("facing=north,channel=" + i4, JState.model((class_2960)Phonos.id("block/radio_player_piano_tuned_" + i4)).y(0));
            radioPianoVar.put("facing=south,channel=" + i4, JState.model((class_2960)Phonos.id("block/radio_player_piano_tuned_" + i4)).y(180));
            radioPianoVar.put("facing=east,channel=" + i4, JState.model((class_2960)Phonos.id("block/radio_player_piano_tuned_" + i4)).y(90));
            radioPianoVar.put("facing=west,channel=" + i4, JState.model((class_2960)Phonos.id("block/radio_player_piano_tuned_" + i4)).y(270));
        }
        pack.addBlockState(new JState().add(radioPianoVar), Phonos.id("radio_player_piano"));
        JVariant recorderVar = JState.variant();
        for (int i5 = 0; i5 < 20; ++i5) {
            recorderVar.put("powered=false,channel=" + i5, JState.model((class_2960)Phonos.id("block/radio_recorder_off_tuned_" + i5)));
            recorderVar.put("powered=true,channel=" + i5, JState.model((class_2960)Phonos.id("block/radio_recorder_on_tuned_" + i5)));
        }
        pack.addBlockState(new JState().add(recorderVar), Phonos.id("radio_recorder"));
        PhonosAssets.addBoomboxBlockState(pack, "boombox");
        PhonosAssets.addBoomboxBlockState(pack, "festive_boombox");
        PhonosAssets.addPianoBlockState(pack, "");
        PhonosAssets.addPianoBlockState(pack, "player_");
        PhonosAssets.addSidedBlockModel(pack, "item/loudspeaker", Phonos.id("block/speaker_bottom"), Phonos.id("block/speaker_side"), Phonos.id("block/speaker_top"));
        PhonosAssets.addSidedBlockModel(pack, "item/gourd_speaker", new class_2960("block/pumpkin_top"), Phonos.id("block/gourd_speaker_side"), Phonos.id("block/gourd_speaker_top"));
        PhonosAssets.addSidedBlockModel(pack, "item/speak_o_lantern", new class_2960("block/pumpkin_top"), Phonos.id("block/speak_o_lantern_side"), Phonos.id("block/gourd_speaker_top"));
        PhonosAssets.addSidedBlockModel(pack, "item/radio_jukebox", Phonos.id("block/speaker_bottom"), Phonos.id("block/radio_jukebox_side_off"), Phonos.id("block/speaker_top"));
        pack.addModel(new JModel().parent("phonos:block/radio_note_block_base").textures(new JTextures().var("side", "phonos:block/radio_note_block_side").var("overlay", "phonos:block/radio_note_block_overlay").var("bottom", "phonos:block/radio_note_block_bottom").var("top", "phonos:block/speaker_top")), Phonos.id("item/radio_note_block"));
        pack.addModel(new JModel().parent("phonos:block/radio_recorder_off_base").textures(new JTextures().var("top", "phonos:block/speaker_top")), Phonos.id("item/radio_recorder"));
        RRPCallback.AFTER_VANILLA.register(l -> l.add(pack));
    }

    public static void addGeneratedItem(RuntimeResourcePack pack, String item) {
        pack.addModel(new JModel().parent("item/generated").textures(JModel.textures().var("layer0", "phonos:item/" + item)), Phonos.id("item/" + item));
    }

    public static void addBoomboxItem(RuntimeResourcePack pack, String boomboxName) {
        JModel bbModel = new JModel().parent("phonos:block/" + boomboxName + "_base").textures(JModel.textures().var("display", "phonos:block/" + boomboxName + "_display"));
        for (int i = 0; i < 20; ++i) {
            bbModel.addOverride(JModel.override((JCondition)JModel.condition().parameter("radio_channel", (Number)Float.valueOf((float)i / 19.0f)), (class_2960)Phonos.id("block/" + boomboxName + "_tuned_" + i)));
        }
        pack.addModel(bbModel, Phonos.id("item/" + boomboxName));
    }

    public static void addPianoBlockState(RuntimeResourcePack pack, String prefix) {
        JVariant pianoVar = JState.variant();
        pianoVar.put("facing=north", JState.model((class_2960)Phonos.id("block/" + prefix + "piano")).y(0));
        pianoVar.put("facing=south", JState.model((class_2960)Phonos.id("block/" + prefix + "piano")).y(180));
        pianoVar.put("facing=east", JState.model((class_2960)Phonos.id("block/" + prefix + "piano")).y(90));
        pianoVar.put("facing=west", JState.model((class_2960)Phonos.id("block/" + prefix + "piano")).y(270));
        pack.addBlockState(new JState().add(pianoVar), Phonos.id(prefix + "piano"));
    }

    public static void addSidedBlockModel(RuntimeResourcePack pack, String path, class_2960 bottom, class_2960 side, class_2960 top) {
        pack.addModel(new JModel().parent("minecraft:block/cube").textures(new JTextures().var("particle", side.toString()).var("north", side.toString()).var("south", side.toString()).var("east", side.toString()).var("west", side.toString()).var("up", top.toString()).var("down", bottom.toString())), Phonos.id(path));
    }

    public static void addCopperSpeakerModels(RuntimeResourcePack pack, String prefix, int iter) {
        PhonosAssets.addSidedBlockModel(pack, "block/" + prefix + "copper_speaker_tuned_" + iter, Phonos.id("block/speaker_bottom"), Phonos.id("block/" + prefix + "copper_speaker_side"), Phonos.id("block/copper_speaker_top_" + iter));
        if (iter == 0) {
            String itemModelPath = "item/" + prefix + "copper_speaker";
            PhonosAssets.addSidedBlockModel(pack, itemModelPath, Phonos.id("block/speaker_bottom"), Phonos.id("block/" + prefix + "copper_speaker_side"), Phonos.id("block/copper_speaker_top"));
            pack.addModel(new JModel().parent("phonos:" + itemModelPath), Phonos.id("item/waxed_" + prefix + "copper_speaker"));
        }
    }

    public static void addBoomboxModels(RuntimeResourcePack pack, String boomboxName, int iter) {
        pack.addModel(new JModel().parent("phonos:block/" + boomboxName + "_base").textures(new JTextures().var("display", "phonos:block/" + boomboxName + "_display_" + iter)), Phonos.id("block/" + boomboxName + "_tuned_" + iter));
    }

    public static void addTinyPotatoSpeakerModel(RuntimeResourcePack pack, int iter) {
        if (iter == 0) {
            pack.addModel(new JModel().parent("phonos:block/tiny_potato_speaker_base").textures(JModel.textures().var("potato", "phonos:block/tiny_potato_speaker").var("display", "phonos:block/tiny_potato_speaker")), Phonos.id("item/tiny_potato_speaker"));
        }
        pack.addModel(new JModel().parent("phonos:block/tiny_potato_speaker_base").textures(JModel.textures().var("potato", "phonos:block/tiny_potato_speaker").var("display", "phonos:block/tiny_potato_speaker_display_" + iter)), Phonos.id("block/tiny_potato_speaker_tuned_" + iter));
    }

    public static void addTunableBlockState(RuntimeResourcePack pack, String path, String prefix) {
        JVariant variants = new JVariant();
        for (int i = 0; i < 20; ++i) {
            variants.put("channel=" + i, new JBlockModel(Phonos.id(prefix + i)));
        }
        pack.addBlockState(new JState().add(variants), Phonos.id(path));
    }

    public static void addBoomboxBlockState(RuntimeResourcePack pack, String boomboxName) {
        JVariant variant = JState.variant();
        for (int i = 0; i < 20; ++i) {
            variant.put("facing=north,channel=" + i, JState.model((class_2960)Phonos.id("block/" + boomboxName + "_tuned_" + i)).y(0));
            variant.put("facing=south,channel=" + i, JState.model((class_2960)Phonos.id("block/" + boomboxName + "_tuned_" + i)).y(180));
            variant.put("facing=east,channel=" + i, JState.model((class_2960)Phonos.id("block/" + boomboxName + "_tuned_" + i)).y(90));
            variant.put("facing=west,channel=" + i, JState.model((class_2960)Phonos.id("block/" + boomboxName + "_tuned_" + i)).y(270));
        }
        pack.addBlockState(new JState().add(variant), Phonos.id(boomboxName));
    }

    public static void addBlockItem(RuntimeResourcePack pack, String path, String parent) {
        pack.addModel(new JModel().parent(parent), Phonos.id(path));
    }
}

