/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.block.entity;

import com.mojang.datafixers.util.Pair;
import io.github.foundationgames.phonos.Phonos;
import io.github.foundationgames.phonos.block.PhonosBlocks;
import io.github.foundationgames.phonos.block.RadioJukeboxBlock;
import io.github.foundationgames.phonos.block.entity.Syncing;
import io.github.foundationgames.phonos.item.CustomMusicDiscItem;
import io.github.foundationgames.phonos.screen.RadioJukeboxGuiDescription;
import io.github.foundationgames.phonos.util.PhonosUtil;
import io.github.foundationgames.phonos.world.RadioChannelState;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class RadioJukeboxBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
class_1278,
Syncing {
    private final class_2371<class_1799> items = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    public float pitch = 1.0f;
    public boolean doShuffle = false;
    private boolean isPlaying = false;
    private int songProgress = 0;
    private int playingSong = 0;
    public int disc1Duration = 1;
    public int disc2Duration = 1;
    public int disc3Duration = 1;
    public int disc4Duration = 1;
    public int disc5Duration = 1;
    public int disc6Duration = 1;
    public static final Int2ByteMap SLOT_2_OP = PhonosUtil.create(() -> {
        Int2ByteOpenHashMap m = new Int2ByteOpenHashMap();
        m.put(0, (byte)2);
        m.put(1, (byte)3);
        m.put(2, (byte)4);
        m.put(3, (byte)5);
        m.put(4, (byte)6);
        m.put(5, (byte)7);
        return m;
    });

    public RadioJukeboxBlockEntity(class_2338 pos, class_2680 state) {
        super(PhonosBlocks.RADIO_JUKEBOX_ENTITY, pos, state);
    }

    public void onDiscRemoved(int slot) {
        if (this.isPlaying) {
            this.playOrStop();
        }
    }

    public void playOrStop() {
        if (!this.isPlaying) {
            if (this.doShuffle) {
                this.shuffle();
            }
            this.pushDiscs();
            this.playSong(0);
            this.isPlaying = true;
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.sync();
            }
        } else {
            this.stop();
        }
        this.field_11863.method_8455(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
    }

    public void stop() {
        if (this.isPlaying) {
            if (!this.field_11863.method_8608()) {
                RadioChannelState pstate = PhonosUtil.getRadioState((class_3218)this.field_11863);
                pstate.tryStopSound(this.field_11867, this.getChannel());
            }
            this.playingSong = 0;
            this.songProgress = 0;
            this.isPlaying = false;
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.sync();
            }
            this.field_11863.method_8455(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
        }
    }

    private void playSong(int slot) {
        if (((class_1799)this.items.get(slot = Math.max(0, Math.min(slot, 5)))).method_7960()) {
            this.songProgress = 0;
            this.isPlaying = false;
            return;
        }
        this.playingSong = slot;
        int d = this.getDuration(slot);
        this.songProgress = d * 20;
        this.isPlaying = true;
        if (!this.field_11863.method_8608()) {
            RadioChannelState pstate = PhonosUtil.getRadioState((class_3218)this.field_11863);
            class_1799 disc = (class_1799)this.items.get(slot);
            if (disc.method_7909() instanceof class_1813) {
                pstate.playSound(this.field_11867, ((class_1813)disc.method_7909()).method_8009(), this.getChannel(), 1.8f, this.pitch, true);
            }
            if (disc.method_7909() instanceof CustomMusicDiscItem) {
                class_2960 id = class_2960.method_12829((String)disc.method_7911("MusicData").method_10558("SoundId"));
                if (id == null) {
                    id = new class_2960("empty");
                }
                pstate.playSound(this.field_11867, id, this.getChannel(), 1.8f, this.pitch, true);
            }
            this.sync();
        }
        this.field_11863.method_8455(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
    }

    public int getComparatorOutput() {
        if (!this.isPlaying) {
            return 0;
        }
        class_1792 item = ((class_1799)this.items.get(this.playingSong)).method_7909();
        if (item instanceof class_1813) {
            return ((class_1813)item).method_8010();
        }
        if (item instanceof CustomMusicDiscItem) {
            class_1799 stack = (class_1799)this.items.get(this.playingSong);
            return stack.method_7911("MusicData").method_10550("ComparatorSignal");
        }
        return 0;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, RadioJukeboxBlockEntity self) {
        boolean s;
        if (self.isPlaying) {
            if (self.songProgress <= 0) {
                int nextSong = self.playingSong + 1;
                if (nextSong <= 5 && !((class_1799)self.items.get(nextSong)).method_7960()) {
                    self.playSong(nextSong);
                } else {
                    self.playOrStop();
                }
            }
            --self.songProgress;
        }
        boolean bl = s = world.method_8320(pos).method_26204() instanceof RadioJukeboxBlock && (Boolean)world.method_8320(pos).method_11654((class_2769)RadioJukeboxBlock.PLAYING) != false;
        if (s != self.isPlaying && world.method_8320(pos).method_26204() instanceof RadioJukeboxBlock) {
            world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)RadioJukeboxBlock.PLAYING, (Comparable)Boolean.valueOf(!s)));
        }
    }

    public void nextSong() {
        if (this.isPlaying && this.playingSong < 5) {
            int nextSong = this.playingSong + 1;
            if (!((class_1799)this.items.get(nextSong)).method_7960()) {
                this.playSong(nextSong);
            } else {
                this.playOrStop();
            }
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.sync();
            }
        }
    }

    public void prevSong() {
        if (this.isPlaying && this.playingSong > 0) {
            int nextSong = this.playingSong - 1;
            if (!((class_1799)this.items.get(nextSong)).method_7960()) {
                this.playSong(nextSong);
            } else {
                this.playOrStop();
            }
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.sync();
            }
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.pitch = nbt.method_10583("Pitch");
        this.doShuffle = nbt.method_10577("DoShuffle");
        this.items.clear();
        class_2487 durations = nbt.method_10562("Durations");
        this.disc1Duration = durations.method_10550("Track1");
        this.disc2Duration = durations.method_10550("Track2");
        this.disc3Duration = durations.method_10550("Track3");
        this.disc4Duration = durations.method_10550("Track4");
        this.disc5Duration = durations.method_10550("Track5");
        this.disc6Duration = durations.method_10550("Track6");
        class_1262.method_5429((class_2487)nbt, this.items);
        class_2487 playingMusic = nbt.method_10562("PlayingMusic");
        this.isPlaying = playingMusic.method_10577("Playing");
        this.playingSong = playingMusic.method_10550("Track");
        this.songProgress = playingMusic.method_10550("Progress");
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("Pitch", this.pitch);
        nbt.method_10556("DoShuffle", this.doShuffle);
        class_1262.method_5426((class_2487)nbt, this.items);
        class_2487 durations = new class_2487();
        durations.method_10569("Track1", this.disc1Duration);
        durations.method_10569("Track2", this.disc2Duration);
        durations.method_10569("Track3", this.disc3Duration);
        durations.method_10569("Track4", this.disc4Duration);
        durations.method_10569("Track5", this.disc5Duration);
        durations.method_10569("Track6", this.disc6Duration);
        nbt.method_10566("Durations", (class_2520)durations);
        class_2487 playingMusic = new class_2487();
        playingMusic.method_10556("Playing", this.isPlaying);
        playingMusic.method_10569("Track", this.playingSong);
        playingMusic.method_10569("Progress", this.songProgress);
        nbt.method_10566("PlayingMusic", (class_2520)playingMusic);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public float getProgress() {
        int d = 1;
        d = this.playingSong == 0 ? this.disc1Duration : d;
        d = this.playingSong == 1 ? this.disc2Duration : d;
        d = this.playingSong == 2 ? this.disc3Duration : d;
        d = this.playingSong == 3 ? this.disc4Duration : d;
        d = this.playingSong == 4 ? this.disc5Duration : d;
        d = this.playingSong == 5 ? this.disc6Duration : d;
        return (float)this.songProgress / 20.0f / (float)d;
    }

    public int getPlayingSong() {
        return this.playingSong;
    }

    private void shuffle() {
        int i;
        ArrayList<Pair> discs = new ArrayList<Pair>();
        for (i = 0; i < 6; ++i) {
            int d = this.getDuration(i);
            discs.add(Pair.of((Object)((class_1799)this.items.get(i)), (Object)d));
        }
        Collections.shuffle(discs);
        this.items.clear();
        for (i = 0; i < discs.size(); ++i) {
            this.items.set(i, (Object)((class_1799)((Pair)discs.get(i)).getFirst()));
            this.setDuration(i, (Integer)((Pair)discs.get(i)).getSecond());
        }
        if (!this.field_11863.method_8608()) {
            this.sync();
        }
    }

    private void pushDiscs() {
        ArrayList<Pair> discs = new ArrayList<Pair>();
        for (int i = 0; i < 6; ++i) {
            int d = this.getDuration(i);
            discs.add(Pair.of((Object)((class_1799)this.items.get(i)), (Object)d));
        }
        ArrayList<Pair> fdiscs = new ArrayList<Pair>();
        for (Pair p : discs) {
            if (((class_1799)p.getFirst()).method_7960()) continue;
            fdiscs.add(p);
        }
        for (Pair p : discs) {
            if (!((class_1799)p.getFirst()).method_7960()) continue;
            fdiscs.add(p);
        }
        this.items.clear();
        for (int i = 0; i < fdiscs.size(); ++i) {
            this.items.set(i, (Object)((class_1799)((Pair)fdiscs.get(i)).getFirst()));
            this.setDuration(i, (Integer)((Pair)fdiscs.get(i)).getSecond());
        }
        if (!this.field_11863.method_8608()) {
            this.sync();
        }
    }

    public int getDuration(int slot) {
        int d = 1;
        d = slot == 0 ? this.disc1Duration : d;
        d = slot == 1 ? this.disc2Duration : d;
        d = slot == 2 ? this.disc3Duration : d;
        d = slot == 3 ? this.disc4Duration : d;
        d = slot == 4 ? this.disc5Duration : d;
        d = slot == 5 ? this.disc6Duration : d;
        return d;
    }

    public void setDuration(int slot, int duration) {
        if (slot == 0) {
            this.disc1Duration = duration;
        } else if (slot == 1) {
            this.disc2Duration = duration;
        } else if (slot == 2) {
            this.disc3Duration = duration;
        } else if (slot == 3) {
            this.disc4Duration = duration;
        } else if (slot == 4) {
            this.disc5Duration = duration;
        } else if (slot == 5) {
            this.disc6Duration = duration;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void performSyncedOperation(byte operation, int data) {
        RadioJukeboxBlockEntity.doOperation(this, operation, data);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(this.field_11867);
        buf.writeByte((int)operation);
        buf.writeInt(data);
        ClientPlayNetworking.send((class_2960)Phonos.id("update_radio_jukebox"), (class_2540)buf);
    }

    public static void registerServerPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Phonos.id("update_radio_jukebox"), (server, player, handler, buf, sender) -> {
            class_2338 pos = buf.method_10811();
            byte operation = buf.readByte();
            int data = buf.readInt();
            server.execute(() -> {
                class_2586 b = player.field_6002.method_8321(pos);
                if (b instanceof RadioJukeboxBlockEntity && pos.method_19769((class_2374)player.method_19538(), 90.0)) {
                    RadioJukeboxBlockEntity be = (RadioJukeboxBlockEntity)b;
                    RadioJukeboxBlockEntity.doOperation(be, operation, data);
                }
            });
        });
    }

    public static void doOperation(RadioJukeboxBlockEntity be, byte op, int data) {
        if (op == 0) {
            be.pitch = (float)Math.min(20, Math.max(data, 1)) / 10.0f;
        } else if (op == 1) {
            be.doShuffle = data > 0;
        } else if (op == 8) {
            be.playOrStop();
        } else if (op == 2) {
            be.disc1Duration = Math.max(1, Math.min(data, 599));
        } else if (op == 3) {
            be.disc2Duration = Math.max(1, Math.min(data, 599));
        } else if (op == 4) {
            be.disc3Duration = Math.max(1, Math.min(data, 599));
        } else if (op == 5) {
            be.disc4Duration = Math.max(1, Math.min(data, 599));
        } else if (op == 6) {
            be.disc5Duration = Math.max(1, Math.min(data, 599));
        } else if (op == 7) {
            be.disc6Duration = Math.max(1, Math.min(data, 599));
        } else if (op == 9) {
            be.nextSong();
        } else if (op == 10) {
            be.prevSong();
        }
        be.method_5431();
    }

    private int getChannel() {
        if (this.field_11863.method_8320(this.field_11867).method_27852(PhonosBlocks.RADIO_JUKEBOX)) {
            return (Integer)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)RadioJukeboxBlock.CHANNEL);
        }
        return 0;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return stack.method_7909() instanceof class_1813 || stack.method_7909() instanceof CustomMusicDiscItem;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public int method_5439() {
        return 6;
    }

    public boolean method_5442() {
        for (class_1799 s : this.items) {
            if (s.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        this.onDiscRemoved(slot);
        return ((class_1799)this.items.get(slot)).method_7971(amount);
    }

    public class_1799 method_5441(int slot) {
        return (class_1799)this.items.remove(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.items.clear();
    }

    public class_2561 method_5476() {
        return new class_2585("");
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        this.sync();
        return new RadioJukeboxGuiDescription(syncId, inv, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867), this);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public static class Ops {
        public static final byte SET_PITCH = 0;
        public static final byte SET_SHUFFLE = 1;
        public static final byte SET_DURATION_1 = 2;
        public static final byte SET_DURATION_2 = 3;
        public static final byte SET_DURATION_3 = 4;
        public static final byte SET_DURATION_4 = 5;
        public static final byte SET_DURATION_5 = 6;
        public static final byte SET_DURATION_6 = 7;
        public static final byte PLAY_STOP = 8;
        public static final byte NEXT_SONG = 9;
        public static final byte PREV_SONG = 10;
    }
}

