/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.block.entity;

import io.github.foundationgames.phonos.block.PhonosBlocks;
import io.github.foundationgames.phonos.block.PianoBlock;
import io.github.foundationgames.phonos.block.RadioChannelBlock;
import io.github.foundationgames.phonos.block.entity.Syncing;
import io.github.foundationgames.phonos.item.PianoRollItem;
import io.github.foundationgames.phonos.network.PayloadPackets;
import io.github.foundationgames.phonos.util.PhonosUtil;
import io.github.foundationgames.phonos.util.piano.PianoKeyboard;
import io.github.foundationgames.phonos.util.piano.PianoRoll;
import io.github.foundationgames.phonos.world.RadioChannelState;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class PlayerPianoBlockEntity
extends class_2586
implements Syncing {
    public final PianoKeyboard keyboard = new PianoKeyboard();
    private boolean rollTurning = false;
    private class_1799 rollStack = class_1799.field_8037;
    private PianoRoll currentRoll = null;
    private PianoRoll.Player playingRoll = null;

    public PlayerPianoBlockEntity(class_2338 pos, class_2680 state) {
        super(PhonosBlocks.PLAYER_PIANO_ENTITY, pos, state);
    }

    protected PlayerPianoBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public boolean rollTurning() {
        return this.rollTurning;
    }

    public boolean hasRoll() {
        return this.currentRoll != null;
    }

    public void setItem(class_1799 rollStack) {
        this.rollStack = rollStack;
        this.currentRoll = PianoRollItem.getRoll(rollStack);
        this.sync();
    }

    public class_1799 takeItem() {
        class_1799 stack = this.rollStack;
        this.rollStack = class_1799.field_8037;
        this.currentRoll = null;
        this.playingRoll = null;
        this.sync();
        return stack;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PlayerPianoBlockEntity self) {
        if (!world.method_8608()) {
            boolean rollTurning;
            boolean bl = rollTurning = self.playingRoll != null && !self.playingRoll.done();
            if (rollTurning != self.rollTurning) {
                self.rollTurning = rollTurning;
                self.sync();
            }
        }
        if (self.playingRoll != null) {
            self.playingRoll.tick();
        }
        self.keyboard.tick();
    }

    public void togglePianoRoll() {
        this.playingRoll = this.playingRoll == null || this.playingRoll.done() ? (this.currentRoll != null ? this.currentRoll.createPlayable(this::playNote) : null) : null;
        this.sync();
    }

    public void playNote(float pitch) {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof PianoBlock) {
            PianoBlock piano = (PianoBlock)class_22482;
            int key = class_3532.method_15340((int)PhonosUtil.noteFromPitch(pitch), (int)0, (int)24);
            this.playSound(piano.getInstrument(pitch, state, this.field_11863, this.field_11867).method_11886(), pitch);
            this.keyboard.press(key);
            if (!this.field_11863.method_8608()) {
                this.field_11863.method_18456().forEach(player -> {
                    if (player instanceof class_3222) {
                        class_3222 sPlayer = (class_3222)player;
                        if (player.method_24515().method_19771((class_2382)this.method_11016(), 100.0)) {
                            PayloadPackets.sendPianoKeyPress(sPlayer, this, key);
                        }
                    }
                });
            }
        }
    }

    protected void playSound(class_3414 sound, float pitch) {
        this.field_11863.method_8396(null, this.field_11867, sound, class_3419.field_15247, 3.0f, pitch);
    }

    public void method_11014(class_2487 nbt) {
        this.rollTurning = nbt.method_10577("running");
        this.setItem(class_1799.method_7915((class_2487)nbt.method_10562("item")));
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10556("running", this.rollTurning);
        nbt.method_10566("item", (class_2520)this.rollStack.method_7953(new class_2487()));
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public static class Radio
    extends PlayerPianoBlockEntity {
        public Radio(class_2338 pos, class_2680 state) {
            super(PhonosBlocks.RADIO_PLAYER_PIANO_ENTITY, pos, state);
        }

        @Override
        protected void playSound(class_3414 sound, float pitch) {
            class_3218 world;
            class_1937 class_19372 = this.method_10997();
            if (class_19372 instanceof class_3218 && (class_19372 = (world = (class_3218)class_19372).method_8320(this.field_11867).method_26204()) instanceof RadioChannelBlock) {
                RadioChannelBlock radio = (RadioChannelBlock)class_19372;
                RadioChannelState channels = PhonosUtil.getRadioState(world);
                int channel = (Integer)world.method_8320(this.field_11867).method_11654((class_2769)radio.getChannelProperty());
                channels.playSound(this.field_11867, sound, channel, 3.0f, pitch, false);
                channels.alertNotePlayed(channel, pitch);
            }
        }
    }
}

