/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.block;

import io.github.foundationgames.phonos.util.ShapeDefinition;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class PianoBlock
extends class_2383 {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final ShapeDefinition SHAPE = new ShapeDefinition().cuboid(0.0, 0.0, 7.0, 16.0, 16.0, 15.0).cuboid(0.0, 16.0, 6.0, 16.0, 18.0, 16.0).cuboid(0.0, 6.0, 2.0, 16.0, 8.0, 7.0);
    public static final class_265 NORTH_SHAPE = SHAPE.toShape(class_2350.field_11043);
    public static final class_265 SOUTH_SHAPE = SHAPE.toShape(class_2350.field_11035);
    public static final class_265 EAST_SHAPE = SHAPE.toShape(class_2350.field_11034);
    public static final class_265 WEST_SHAPE = SHAPE.toShape(class_2350.field_11039);
    public final Side side;
    @Nullable
    protected final class_2248 neighbor;

    public PianoBlock(class_4970.class_2251 settings, Side side, @Nullable class_2248 neighbor) {
        super(settings);
        this.side = side;
        this.neighbor = neighbor;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11177, POWERED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2338 neighborPos = pos.method_10093(this.side.neighborDirection((class_2350)state.method_11654((class_2769)field_11177)));
        class_2680 neighborState = world.method_8320(neighborPos);
        if (neighborState.method_26204() instanceof PianoBlock) {
            return neighborState.method_26174(world, player, hand, hit.method_29328(neighborPos));
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void onPowered(class_2680 state, class_1937 world, class_2338 pos) {
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!newState.method_27852((class_2248)this)) {
            class_2338 neighborPos = pos.method_10093(this.side.neighborDirection((class_2350)state.method_11654((class_2769)field_11177)));
            class_2248 class_22482 = world.method_8320(neighborPos).method_26204();
            if (class_22482 instanceof PianoBlock) {
                PianoBlock piano = (PianoBlock)class_22482;
                if (piano.side == this.side.opposite()) {
                    world.method_22352(neighborPos, true);
                }
            }
        } else if (((Boolean)newState.method_11654((class_2769)POWERED)).booleanValue()) {
            this.onPowered(state, world, pos);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        boolean hasPower;
        super.method_9612(state, world, pos, block, fromPos, notify);
        class_2338 neighborPos = pos.method_10093(this.side.neighborDirection((class_2350)state.method_11654((class_2769)field_11177)));
        boolean bl = hasPower = world.method_8479(pos) || world.method_8479(neighborPos);
        if (hasPower != (Boolean)state.method_11654((class_2769)POWERED)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(hasPower)));
        }
    }

    public class_2680 getPlacementState(class_2350 playerFacing) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)playerFacing.method_10153());
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = this.getPlacementState(ctx.method_8042());
        class_2338 neighborPos = ctx.method_8037().method_10093(this.side.neighborDirection((class_2350)state.method_11654((class_2769)field_11177)));
        return ctx.method_8045().method_8320(neighborPos).method_26166(ctx) ? state : null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2248 class_22482;
        super.method_9567(world, pos, state, placer, itemStack);
        class_2338 neighborPos = pos.method_10093(this.side.neighborDirection((class_2350)state.method_11654((class_2769)field_11177)));
        if (this.neighbor != null && (class_22482 = this.neighbor) instanceof PianoBlock) {
            PianoBlock neighborPiano = (PianoBlock)class_22482;
            world.method_8501(neighborPos, neighborPiano.getPlacementState(placer != null ? placer.method_5735() : class_2350.field_11043));
        }
    }

    public class_2766 getInstrument(float pitch, class_2680 state, class_1937 world, class_2338 pos) {
        class_2338 neighborPos = pos.method_10093(this.side.neighborDirection((class_2350)state.method_11654((class_2769)field_11177)));
        class_2338 relevantPos = switch (this.side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.LEFT -> {
                if (pitch < 1.0f) {
                    yield pos;
                }
                yield neighborPos;
            }
            case Side.RIGHT -> pitch >= 1.0f ? pos : neighborPos;
        };
        return class_2766.method_11887((class_2680)world.method_8320(relevantPos.method_10074()));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)field_11177)) {
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11034 -> EAST_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public static enum Side {
        LEFT,
        RIGHT;


        public class_2350 neighborDirection(class_2350 facing) {
            return switch (this) {
                case LEFT -> facing.method_10160();
                default -> facing.method_10170();
            };
        }

        public Side opposite() {
            return switch (this) {
                case LEFT -> RIGHT;
                default -> LEFT;
            };
        }
    }
}

