/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import snownee.jade.addon.create.CreatePlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum BlazeBurnerProvider implements IBlockComponentProvider,
IServerDataProvider<class_2586>
{
    INSTANCE;


    @Environment(value=EnvType.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        class_2487 compound = accessor.getServerData();
        BlazeBurnerBlockEntity.FuelType activeFuel = BlazeBurnerBlockEntity.FuelType.NONE;
        boolean isCreative = compound.method_10577("isCreative");
        if (isCreative) {
            BlazeBurnerBlock.HeatLevel heatLevel = BasinBlockEntity.getHeatLevelOf((class_2680)accessor.getBlockState());
            if (heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING) {
                activeFuel = BlazeBurnerBlockEntity.FuelType.SPECIAL;
            } else if (heatLevel != BlazeBurnerBlock.HeatLevel.NONE) {
                activeFuel = BlazeBurnerBlockEntity.FuelType.NORMAL;
            }
        } else {
            activeFuel = BlazeBurnerBlockEntity.FuelType.values()[compound.method_10550("fuelLevel")];
        }
        if (activeFuel == BlazeBurnerBlockEntity.FuelType.NONE) {
            return;
        }
        class_1799 item = new class_1799((class_1935)(activeFuel == BlazeBurnerBlockEntity.FuelType.SPECIAL ? class_1802.field_23842 : class_1802.field_17346));
        tooltip.add(IElementHelper.get().smallItem(item));
        if (isCreative) {
            tooltip.append((class_2561)new class_2588("jade.infinity"));
        } else {
            tooltip.append((class_2561)new class_2588("jade.seconds", new Object[]{compound.method_10550("burnTimeRemaining") / 20}));
        }
    }

    public void appendServerData(class_2487 data, class_3222 player, class_1937 level, class_2586 blockEntity, boolean details) {
        BlazeBurnerBlockEntity burner = (BlazeBurnerBlockEntity)blockEntity;
        if (burner.isCreative()) {
            data.method_10556("isCreative", true);
        } else if (burner.getActiveFuel() != BlazeBurnerBlockEntity.FuelType.NONE) {
            data.method_10569("fuelLevel", burner.getActiveFuel().ordinal());
            data.method_10569("burnTimeRemaining", burner.getRemainingBurnTime());
        }
    }

    public class_2960 getUid() {
        return CreatePlugin.BLAZE_BURNER;
    }
}

