/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.searchtree;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1121;
import net.minecraft.class_1799;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.searchtree.DummySearchTree;

public class SearchTreeProviderRegistry {
    private static final List<Provider> searchTreeProviders = new ArrayList<Provider>();

    public static synchronized Provider getSearchTreeProvider() {
        for (Provider p : searchTreeProviders) {
            if (!p.canUse()) continue;
            return p;
        }
        Option option = ModernFixMixinPlugin.instance.config.getEffectiveOptionForMixin("perf.blast_search_trees.Registry");
        if (option != null && option.isOverridden()) {
            return DummySearchTree.PROVIDER;
        }
        return null;
    }

    public static synchronized void register(Provider p) {
        if (p.canUse()) {
            searchTreeProviders.add(p);
        }
    }

    public static interface Provider {
        public class_1121<class_1799> getSearchTree(boolean var1);

        public boolean canUse();

        public String getName();
    }
}

